%define version 1.1.0
%define name kreatecd
Name: %{name}
Summary: K Desktop Environment - KreateCD CD-R frontend
Version: %{version}
Release: 2.suse72
Source: %{name}-%{version}.tar.bz2
Group: X11/KDE/Applications
URL: http://www.kreatecd.de/
BuildRoot: /tmp/realhot_%{name}
Copyright: GPL
Distribution: SuSE Linux 7.2 (i386)
Packager: Niels Reedijk
Requires: cdrecord mkisofs cdparanoia

%package au-plugin
Summary: KreateCD .au plugin
Requires: kreatecd-wav-plugin
Group: X11/KDE/Applications

%package wav-plugin
Summary: KreateCD .wav plugin
Group: X11/KDE/Applications

%package mp3-plugin
Summary: KreateCD .mp3 plugin
Requires: mpg123 kreatecd-wav-plugin
Group: X11/KDE/Applications

%package vorbis-plugin
Summary: KreateCD ogg/vorbis plugin
Requires: libogg libvorbis kreatecd-wav-plugin
Group: X11/KDE/Applications

%description
KreateCD is a graphical frontend for CD-R recording. It uses the K Desktop
Environment to provide a intuitive user interface. KreateCD is able to
create ISO-9660 images and CDDA disks and copy them.

%description au-plugin
This is a plugin for KreateCD. If you install this plugin, you can use
.au files when you're burning an audio cd. You _must_ install the .wav
plugin first.

%description wav-plugin
This is a plugin for KreateCD. If you install this plugin, you can use
.wavfiles when you're burning an audio cd. You need this plugin if you
want to use the other plugins.

%description mp3-plugin
This is a plugin for KreateCD. If you install this plugin, you can use
.mp3 files when you're burning an audio cd. You _must_ install the .wav
plugin first, as well as mpg123.

%description vorbis-plugin
This is a plugin for KreateCD. If you install this plugin, you can use
ogg/vorbis files when you're burning an audio cd. You _must_ install the .wav
plugin first, as well as libogg and libvorbis.

%prep
rm -rf $RPM_BUILD_ROOT

%setup -n %{name}-%{version}

%build
./configure --prefix=/opt/kde2 --with-qt-dir=/usr/lib/qt2 --enable-final
make

%install
make DESTDIR=$RPM_BUILD_ROOT install

%clean
rm -rf $RPM_BUILD_ROOT

%files
/opt/kde2/bin/kreatecd
/opt/kde2/bin/kreatecd_rootwrapper
/opt/kde2/share/applnk/Applications/kreatecd.desktop
/opt/kde2/share/apps/konqueror/servicemenus/kcd_konqy.desktop
/opt/kde2/share/apps/kreatecd/kreatecdui.rc
#pics
/opt/kde2/share/apps/kreatecd/pics/burn.png
/opt/kde2/share/apps/kreatecd/pics/kcd_addsession.png
/opt/kde2/share/apps/kreatecd/pics/kcd_backward.png
/opt/kde2/share/apps/kreatecd/pics/kcd_folder_new.png
/opt/kde2/share/apps/kreatecd/pics/kcd_set_start.png
/opt/kde2/share/apps/kreatecd/pics/kcd_folder_red.png
/opt/kde2/share/apps/kreatecd/pics/kcd_set_stop.png
/opt/kde2/share/apps/kreatecd/pics/kcd_forward.png
/opt/kde2/share/apps/kreatecd/pics/kcd_stop.png
/opt/kde2/share/apps/kreatecd/pics/kcd_header.png
/opt/kde2/share/apps/kreatecd/pics/kcd_unknown.png
/opt/kde2/share/apps/kreatecd/pics/kcd_locked.png
/opt/kde2/share/apps/kreatecd/pics/kcd_unknown_blue.png
/opt/kde2/share/apps/kreatecd/pics/kcd_balance.png
/opt/kde2/share/apps/kreatecd/pics/kcd_lockedfolder.png
/opt/kde2/share/apps/kreatecd/pics/kcd_volume.png
/opt/kde2/share/apps/kreatecd/pics/kcd_cd.png
/opt/kde2/share/apps/kreatecd/pics/kcd_logo.png
/opt/kde2/share/apps/kreatecd/pics/kdelogo2.png
/opt/kde2/share/apps/kreatecd/pics/kcd_cd_copy_bg.png
/opt/kde2/share/apps/kreatecd/pics/kcd_mcstyle.png
/opt/kde2/share/apps/kreatecd/pics/lines.png
/opt/kde2/share/apps/kreatecd/pics/kcd_cdcopy.png
/opt/kde2/share/apps/kreatecd/pics/kcd_play.png
/opt/kde2/share/apps/kreatecd/pics/lines2.png
/opt/kde2/share/apps/kreatecd/pics/kcd_classic.png
/opt/kde2/share/apps/kreatecd/pics/kcd_play_begin.png
/opt/kde2/share/apps/kreatecd/pics/shadow1.png
/opt/kde2/share/apps/kreatecd/pics/kcd_folder.png
/opt/kde2/share/apps/kreatecd/pics/kcd_projecttype_config.png
/opt/kde2/share/apps/kreatecd/pics/kcd_folder_blue.png
/opt/kde2/share/apps/kreatecd/pics/kcd_remove.png
#config
/opt/kde2/share/config/kreatecdrc
#doc
/opt/kde2/share/doc/HTML/en/kreatecd/installation.html
/opt/kde2/share/doc/HTML/en/kreatecd/scsisettings.png
/opt/kde2/share/doc/HTML/en/kreatecd/introduction.html
/opt/kde2/share/doc/HTML/en/kreatecd/startupscreen.html
/opt/kde2/share/doc/HTML/en/kreatecd/burnersettings.png
/opt/kde2/share/doc/HTML/en/kreatecd/isoconfig.html
/opt/kde2/share/doc/HTML/en/kreatecd/startupscreen.png
/opt/kde2/share/doc/HTML/en/kreatecd/commands.html
/opt/kde2/share/doc/HTML/en/kreatecd/isosettings.png
/opt/kde2/share/doc/HTML/en/kreatecd/trackdialog.png
/opt/kde2/share/doc/HTML/en/kreatecd/obtaininst.html
/opt/kde2/share/doc/HTML/en/kreatecd/tracks.html
/opt/kde2/share/doc/HTML/en/kreatecd/confdiag.html
/opt/kde2/share/doc/HTML/en/kreatecd/pathsettings.png
/opt/kde2/share/doc/HTML/en/kreatecd/uninstall.html
/opt/kde2/share/doc/HTML/en/kreatecd/credits.html
/opt/kde2/share/doc/HTML/en/kreatecd/projectconfig.html
/opt/kde2/share/doc/HTML/en/kreatecd/using-kreatecd.html
/opt/kde2/share/doc/HTML/en/kreatecd/index.docbook
/opt/kde2/share/doc/HTML/en/kreatecd/projectsettings.png
/opt/kde2/share/doc/HTML/en/kreatecd/index.html
/opt/kde2/share/doc/HTML/en/kreatecd/scsiconfig.html
/opt/kde2/share/doc/HTML/en/kreatecd/common/bsd-license.html
/opt/kde2/share/doc/HTML/en/kreatecd/common/logotp3-small.png
/opt/kde2/share/doc/HTML/en/kreatecd/common/caution.png
/opt/kde2/share/doc/HTML/en/kreatecd/common/logotp3.png
/opt/kde2/share/doc/HTML/en/kreatecd/common/1.png
/opt/kde2/share/doc/HTML/en/kreatecd/common/doctop1.png
/opt/kde2/share/doc/HTML/en/kreatecd/common/note.png
/opt/kde2/share/doc/HTML/en/kreatecd/common/10.png
/opt/kde2/share/doc/HTML/en/kreatecd/common/doctop1a.png
/opt/kde2/share/doc/HTML/en/kreatecd/common/prev.png
/opt/kde2/share/doc/HTML/en/kreatecd/common/2.png
/opt/kde2/share/doc/HTML/en/kreatecd/common/doctop1b.png
/opt/kde2/share/doc/HTML/en/kreatecd/common/qpl-license.html
/opt/kde2/share/doc/HTML/en/kreatecd/common/3.png
/opt/kde2/share/doc/HTML/en/kreatecd/common/doctop2.png
/opt/kde2/share/doc/HTML/en/kreatecd/common/shadow.png
/opt/kde2/share/doc/HTML/en/kreatecd/common/4.png
/opt/kde2/share/doc/HTML/en/kreatecd/common/fdl-license
/opt/kde2/share/doc/HTML/en/kreatecd/common/tip.png
/opt/kde2/share/doc/HTML/en/kreatecd/common/5.png
/opt/kde2/share/doc/HTML/en/kreatecd/common/fdl-license.html
/opt/kde2/share/doc/HTML/en/kreatecd/common/toc-blank.png
/opt/kde2/share/doc/HTML/en/kreatecd/common/6.png
/opt/kde2/share/doc/HTML/en/kreatecd/common/gpl-license
/opt/kde2/share/doc/HTML/en/kreatecd/common/toc-minus.png
/opt/kde2/share/doc/HTML/en/kreatecd/common/7.png
/opt/kde2/share/doc/HTML/en/kreatecd/common/gpl-license.html
/opt/kde2/share/doc/HTML/en/kreatecd/common/toc-plus.png
/opt/kde2/share/doc/HTML/en/kreatecd/common/8.png
/opt/kde2/share/doc/HTML/en/kreatecd/common/important.png
/opt/kde2/share/doc/HTML/en/kreatecd/common/up.png
/opt/kde2/share/doc/HTML/en/kreatecd/common/9.png
/opt/kde2/share/doc/HTML/en/kreatecd/common/kde-common.css
/opt/kde2/share/doc/HTML/en/kreatecd/common/warning.png
/opt/kde2/share/doc/HTML/en/kreatecd/common/kde-default.css
/opt/kde2/share/doc/HTML/en/kreatecd/common/x11-license.html
/opt/kde2/share/doc/HTML/en/kreatecd/common/artistic-license.html
/opt/kde2/share/doc/HTML/en/kreatecd/common/kde-localised.css.template
/opt/kde2/share/doc/HTML/en/kreatecd/common/xml.dcl
/opt/kde2/share/doc/HTML/en/kreatecd/common/bottom1.png
/opt/kde2/share/doc/HTML/en/kreatecd/common/lgpl-license
/opt/kde2/share/doc/HTML/en/kreatecd/common/bottom2.png
/opt/kde2/share/doc/HTML/en/kreatecd/common/lgpl-license.html
#icons
/opt/kde2/share/icons/hicolor/32x32/apps/kreatecd.png
/opt/kde2/share/icons/locolor/16x16/apps/kreatecd.png
#translations
/opt/kde2/share/locale/is/LC_MESSAGES/kreatecd.mo
/opt/kde2/share/locale/de/LC_MESSAGES/kreatecd.mo
/opt/kde2/share/locale/sv/LC_MESSAGES/kreatecd.mo
/opt/kde2/share/locale/it/LC_MESSAGES/kreatecd.mo
/opt/kde2/share/locale/nl/LC_MESSAGES/kreatecd.mo
#mimitype
/opt/kde2/share/mimelnk/application/x-kreatecd.desktop
#trackviewpart

/opt/kde2/lib/libkreatecdtrackviewpart.so
/opt/kde2/lib/libkreatecdtrackviewpart.la
/opt/kde2/share/services/kreatecdtrackview_component.desktop
%files au-plugin
/opt/kde2/share/apps/kreatecd/plugins/libkcd_au.la
/opt/kde2/share/apps/kreatecd/plugins/libkcd_au.so


%files wav-plugin
/opt/kde2/share/apps/kreatecd/plugins/libkcd_wav.la
/opt/kde2/share/apps/kreatecd/plugins/libkcd_wav.so


%files mp3-plugin
/opt/kde2/share/apps/kreatecd/plugins/libkcd_mp3.la
/opt/kde2/share/apps/kreatecd/plugins/libkcd_mp3.so

%files vorbis-plugin
/opt/kde2/share/apps/kreatecd/plugins/libkcd_vorbis.la
/opt/kde2/share/apps/kreatecd/plugins/libkcd_vorbis.so

