/*
 * This source code is part of my universal C library "libch".
 * Copyright (C) 1998,99 by Christian Hammers <ch@westend.com>.
 *
 * This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include <stdio.h>
#include <regex.h>
#include "libch.h"

int ch_regex_match(char *s, char *ex) {
	int 	error;
	string	errbuf;
	regex_t	preg;

	error = regcomp(&preg, ex, REG_NOSUB);
	if (error) {
		regerror(error, &preg, errbuf, sizeof(errbuf)-1);
		ch_panic("ch_regex_match: compiling: %s",errbuf);
	}

	return !regexec(&preg, s, 0, NULL, 0);
}
