/**
 * =========================================
 * LibFormula : a free Java formula library
 * =========================================
 *
 * Project Info:  http://reporting.pentaho.org/libformula/
 *
 * (C) Copyright 2006-2007, by Pentaho Corporation and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * [Java is a trademark or registered trademark of Sun Microsystems, Inc.
 * in the United States and other countries.]
 *
 *
 * ------------
 * $Id: EvaluationException.java 2887 2007-06-06 17:07:52Z taqua $
 * ------------
 * (C) Copyright 2006-2007, by Pentaho Corporation.
 */
package org.jfree.formula;

import org.jfree.util.StackableException;

/**
 * Creation-Date: 31.10.2006, 14:15:29
 *
 * @author Thomas Morgner
 */
public class EvaluationException extends StackableException
{
  private ErrorValue errorValue;

  /**
   * Creates a StackableRuntimeException with no message and no parent.
   */
  public EvaluationException(final ErrorValue errorValue)
  {
    super(String.valueOf(errorValue));
    this.errorValue = errorValue;
  }

  public ErrorValue getErrorValue()
  {
    return errorValue;
  }
}
