/**
 * =========================================
 * LibFormula : a free Java formula library
 * =========================================
 *
 * Project Info:  http://reporting.pentaho.org/libformula/
 *
 * (C) Copyright 2006-2007, by Pentaho Corporation and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * [Java is a trademark or registered trademark of Sun Microsystems, Inc.
 * in the United States and other countries.]
 *
 *
 * ------------
 * $Id: MappedFunctionDescription.java 3521 2007-10-16 10:55:14Z tmorgner $
 * ------------
 * (C) Copyright 2006-2007, by Pentaho Corporation.
 */
package org.jfree.formula.function.userdefined;

import java.util.Locale;

import org.jfree.formula.typing.Type;
import org.jfree.formula.function.FunctionDescription;
import org.jfree.formula.function.FunctionCategory;

/**
 * Creation-Date: 05.11.2006, 14:01:22
 *
 * @author Thomas Morgner
 */
public class MappedFunctionDescription implements FunctionDescription
{
  public MappedFunctionDescription()
  {
  }

  public String getDisplayName(final Locale locale)
  {
    return null;
  }

  public String getDescription(final Locale locale)
  {
    return null;
  }

  public boolean isVolatile()
  {
    return false;
  }

  public Type getValueType()
  {
    return null;
  }

  public int getParameterCount()
  {
    return 0;
  }

  public boolean isInfiniteParameterCount()
  {
    return false;
  }

  public Type getParameterType(final int position)
  {
    return null;
  }

  public String getParameterDisplayName(final int position, final Locale locale)
  {
    return null;
  }

  public String getParameterDescription(final int position, final Locale locale)
  {
    return null;
  }

  /**
   * Defines, whether the parameter at the given position is mandatory. A
   * mandatory parameter must be filled in, while optional parameters need not
   * to be filled in.
   *
   * @return
   */
  public boolean isParameterMandatory(final int position)
  {
    return false;
  }

  /**
   * Returns the default value for an optional parameter. If the value returned
   * here is null, then this either means, that the parameter is mandatory or
   * that the default value is computed by the expression itself.
   *
   * @param position
   * @return
   */
  public Object getDefaultValue(final int position)
  {
    return null;
  }

  public FunctionCategory getCategory()
  {
    return UserDefinedFunctionCategory.CATEGORY;
  }
}
