""" An extension point. """


# Enthought library imports.
from enthought.traits.api import HasPrivateTraits, Instance


class ExtensionPoint(HasPrivateTraits):
    """ An extension point.
    
    All extension points *must* derive from this class. Plug-ins contribute
    to the extension point by creating instances of the derived classes.

    Extension points are intended to be *declarative* and should *not* contain
    any methods (other than those inherited from HasPrivateTraits).
    
    """

    #### 'ExtensionPoint' interface ###########################################

    # The following traits are 'special' traits provided by the framework. They
    # are prefixed and suffixed with an underscore to prevent name collisions
    # with trait names of the actual extension point classes that derive from
    # this one.
    
    # The plugin definition that the EXTENSION is defined in.
    _definition_ = Instance(
        'enthought.envisage.core.plugin_definition.PluginDefinition'
    )
    
#### EOF ######################################################################
