"""Script to remove the RTC applications

  History:
    121405  mlr  Allowed for the path variable to contain a ".."
"""

# import the cp directory
import cp

from cp.rtc.script_action \
    import remove_menu_action

path1 = "\\lib\\cp\\__init__.pyc"
path2 = "\\lib\\cp\\__init__.py"

#-------------------------------------------------------------------------------
#  Remove the context menu actions
#-------------------------------------------------------------------------------

def remove_rtc_apps():
    path = cp.__file__
    # change to the absolute path if ".." found
    if path.startswith(".."):
        abs_path = os.path.abspath(path)
    else:
        abs_path = path

    # look for either a .pyc or .py file
    if abs_path.endswith(path1):
        end_path = path1
        path = abs_path
    elif abs_path.endswith(path2):
        end_path = path2
        path = abs_path
    else:
        print "Unable to find cplab plugin definition file."
        return

    path = path[:-len(end_path)]
    save_path = path + "\\apps\\cplab\\plugin_definitions_sv.py"
    tmp_path = path + "\\apps\\cplab\\plugin_definitions_tmp.py"
    def_path = path + "\\apps\\cplab\\plugin_definitions.py"

    icflg = 0
    # look for rtc comment if a saved file found
    if path.endswith(save_path):
        f1 = file(save_path, "r")

        line = f1.readline()
        while line != "":
            if line.strip().startswith("#RTCPLUGIN"):
                icflg = 1
                first = line.index("#RTCPLUGIN")
                last = line.index("join")
                newline = line[:first] + line[last:]
                line = newline

            line = f1.readline()

        f1.close()

    # copy the file (if RTC comment line found)
    if icflg == 1:
        cmd = "copy " + save_path + " " + def_path
        os.system(cmd)
        cmd = "erase " + save_path
        os.system(cmd)

    # find plugin definition if saved file not found
    else:
        f2 = file(def_path, "r")
        f3 = file(tmp_path, "w")

        line = f2.readline()
        idflg = 0
        while line != "":
            if line.strip().startswith("join"):
                if line.find("log_rtc_plugin_definition") != -1:
                    idflg = 1
                    first = line.index("join")
                    last = first
                    newline = line[:first] + "#RTCPLUGIN " + line[last:]
                    line = newline
            f3.write(line)

            line = f2.readline()

        f2.close()
        f3.close()
        # copy the file (if RTC plugin definition found)
        if idflg == 1:
            cmd = "copy " + tmp_path + " " + def_path
            os.system(cmd)
        # erase the temporary file
        cmd = "erase " + tmp_path
        os.system(cmd)

    # Remove contex menu items
    remove_menu_action("RTC Median filter")
    remove_menu_action("RTC Backus Average")
    remove_menu_action("RTC Flagexpander")
    remove_menu_action("RTC Sumlog")
    remove_menu_action("RTC Sawtooth discriminator")
    remove_menu_action( "RTC Bed report")

# remove the rtc applications
remove_rtc_apps()
