""" The resource type for Python dictionaries. """


# Enthought library imports.
from enthought.envisage.resource import ObjectResourceType
from enthought.naming.adapter import DictContextAdapterFactory
from enthought.traits.api import Dict

# Local imports.
from dict_node_type import DictNodeType


class DictResourceType(ObjectResourceType):
    """ The resource type for Python dictionaries. """

    #### 'ResourceType' interface #############################################

    # A trait that describes the kind of domain object that the type
    # represents.
    type = Dict

    ###########################################################################
    # 'ResourceType' interface.
    ###########################################################################

    #### Initializers #########################################################

    def _node_type_default(self):
        """ Initializes the node type. """

        return DictNodeType(resource_type=self)

    def _context_adapter_factory_default(self):
        """ Initializes the context adapter factory. """

        return DictContextAdapterFactory()

##### EOF #####################################################################
