""" The resource type for Python strings. """


# Enthought library imports.
from enthought.envisage.resource import ObjectResourceType
from enthought.traits.api import String

# Local imports.
from string_node_type import StringNodeType


class StringResourceType(ObjectResourceType):
    """ The resource type for Python strings. """

    #### 'ResourceType' interface #############################################

    # A trait that describes the kind of domain object that the type
    # represents.
    type = String

    ###########################################################################
    # 'ResourceType' interface.
    ###########################################################################

    #### Initializers #########################################################

    def _node_type_default(self):
        """ Initializes the node type. """

        return StringNodeType(resource_type=self)

##### EOF #####################################################################
