""" Some common filters for use with a resource tree. """


# Enthought library imports.
from enthought.naming.api import Context
from enthought.pyface.api import Filter


class AllowOnlyFolders(Filter):
    """ A filter that allows only folders (ie. contexts). """
    
    def select(self, widget, parent, node):
        """ Returns True if the element is 'allowed' (ie. NOT filtered).

        'widget' is the widget that we are filtering nodes for.
        'parent' is the parent node.
        'node'   is the node to select.

        """

        return isinstance(node.obj, Context)

#### EOF ######################################################################
