#-----------------------------------------------------------------------------
#
#  Copyright (c) 2006 by Enthought, Inc.
#  All rights reserved.
#
#  Author: Dave Peterson <dpeterson@enthought.com>
#
#-----------------------------------------------------------------------------

""" A base class for action controllers for resource tree context menus.
"""

# Enthought library imports.
from enthought.pyface.action.api import ActionController
from enthought.traits.api import HasTraits, Instance


##############################################################################
# class 'ResourceTreeActionController'
##############################################################################

class ResourceTreeActionController(ActionController):
    """ A base class for action controllers for resource tree context menus.

        Users of ResourceTree can set an instance of this class as the
        controller for every action triggered from a context menu in order
        to customize the attributes of the events that those actions receive.

        This would be done so that additional information can be added to the
        events.
    """

    ##########################################################################
    # Traits
    ##########################################################################

    #### public 'ResourceTreeActionController' interface #####################

    # The application that an action is being executed within
    application = Instance('enthought.envisage.api.Application')

    # The tree node that an action is being performed for.
    node = Instance('enthought.naming.api.Binding')

    # The tree control that we are associated with
    tree = Instance('enthought.envisage.resource.ui.api.ResourceTree')

    # The workbench window that the controller is associated with.
    window = Instance('enthought.pyface.api.Window')


    ##########################################################################
    # 'ActionController' interface.
    ##########################################################################

    #### public interface ####################################################

    def perform(self, action, event):
        """ Control an action invocation.
        """
        # Ensure the event contains a referece to all the data (application,
        # node, tree, and window) we know about.
        event.application = self.window.application
        event.node = self.node
        event.tree = self.tree
        event.widget = self.tree
        event.window = self.window

        return action.perform(event)


#### EOF #####################################################################
