.\" $NCDId: @(#)AuSRec.man,v 1.1 1995/05/23 23:55:02 greg Exp $
.\" copyright 1995 Yoav Eilat
.\"
.\" portions are
.\" * Copyright 1993 Network Computing Devices, Inc.
.\" *
.\" * Permission to use, copy, modify, distribute, and sell this software and its
.\" * documentation for any purpose is hereby granted without fee, provided that
.\" * the above copyright notice appear in all copies and that both that
.\" * copyright notice and this permission notice appear in supporting
.\" * documentation, and that the name Network Computing Devices, Inc. not be
.\" * used in advertising or publicity pertaining to distribution of this
.\" * software without specific, written prior permission.
.\" * 
.\" * THIS SOFTWARE IS PROVIDED 'AS-IS'.  NETWORK COMPUTING DEVICES, INC.,
.\" * DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING WITHOUT
.\" * LIMITATION ALL IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
.\" * PARTICULAR PURPOSE, OR NONINFRINGEMENT.  IN NO EVENT SHALL NETWORK
.\" * COMPUTING DEVICES, INC., BE LIABLE FOR ANY DAMAGES WHATSOEVER, INCLUDING
.\" * SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES, INCLUDING LOSS OF USE, DATA,
.\" * OR PROFITS, EVEN IF ADVISED OF THE POSSIBILITY THEREOF, AND REGARDLESS OF
.\" * WHETHER IN AN ACTION IN CONTRACT, TORT OR NEGLIGENCE, ARISING OUT OF OR IN
.\" * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.\"
.\" $Id: AuSRec.man,v 1.1.1.1 1999/05/08 18:47:27 jon Exp $
.TH AuSoundRecord 3 "1.2" "soundlib"
.SH \fBName\fP
\fBAuSoundRecord\fP \- create a flow to record audio to any destination.
.SH \fBSynopsis\fP
#include <audio/audiolib.h>
.br
#include <audio/soundlib.h>
.sp 1
\fBAuEventHandlerRec\fP *\fBAuSoundRecord\fP(\fIserver\fP, \fIsource\fP, \fIgain\fP, \fInum_samples\fP, \fImode\fP, \fIsound_data\fP, \fIflow\fP, \fIvolume_mult_elem\fP, \fIstatus\fP)
.br
    \fBAuServer\fP *\fIserver\fP;
.br
    \fBAuDeviceID\fP \fIsource\fP;
.br
    \fBAuFixedPoint\fP \fIgain\fP;
.br
    \fBAuUint32\fP \fInum_samples\fP;
.br
    int \fImode\fP;
.br
    \fBAuSoundDataPtr\fP \fIsound_data\fP;
.br
    \fBAuFlowID\fP *\fIflow\fP; /* \fBRETURN\fP */
.br
    int *\fIvolume_mult_elem\fP; /* \fBRETURN\fP */
.br
    \fBAuStatus\fP *\fIstatus\fP; /* \fBRETURN\fP */
.SH \fBArguments\fP
.IP \fIserver\fP 1i
Specifies the connection to the audio server.
.IP \fIsource\fP 1i
Specifies the input device to use.
.IP \fIgain\fP 1i
Specifies the gain for the input device.
.IP \fInum_samples\fP 1i
Specifies the number of samples to record.
.IP \fImode\fP 1i
Specifies the line mode for the input device.
Currently the following line modes are defined: \fBAuDeviceInputModeNone\fP, \fBAuDeviceInputModeLineIn\fP, \fBAuDeviceInputModeMicrophone\fP.
.IP \fIsound_data\fP 1i
Specifies the sound information.
.IP \fIflow\fP 1i
If non-NULL, returns the flow ID.
.IP \fIvolume_mult_elem\fP 1i
Accord to the comment in the source, not implemented.
.IP \fIstatus\fP 1i
If non-NULL, flush the output buffer and return the status from the server.
.SH \fBDescription\fP
\fBAuSoundRecord\fP creates a flow to record audio from \fIsource\fP to any destination and returns a pointer to the event handler created or NULL if there was an error. The \fIsound_data\fP structure contains the necessary information about the audio format and the data handling function.
.SH \fBErrors\fP
\fBAuBadDevice\fP.
.SH \fBSee Also\fP
\fBAuSoundRecordToBucket\fP,
\fBAuSoundRecordToData\fP,
\fBAuSoundRecordToFile\fP,
\fBAuSoundRecordToFileN\fP.
.sp 1
audiolib \- \fBNetwork Audio System\fP C Language Interface
