/*
    nwcalls.h
    Copyright (C) 1998, 1999  Petr Vandrovec

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    Revision history:

	0.00  1998			Petr Vandrovec <vandrove@vc.cvut.cz>

		Initial revision.

	1.00  1999, November 20		Petr Vandrovec <vandrove@vc.cvut.cz>
		Added license.

	1.01  2000, June 1		Petr Vandrovec <vandrove@vc.cvut.cz>
		Added NWGetBinderyAccessLevel.
 */

#ifndef __NWCALLS_H__
#define __NWCALLS_H__

/* Stub for nwdir.c ... Maybe more? */

#include <ncp/ncplib.h>
#include <ncp/ext/stdint.h>

typedef unsigned int	nuint;
typedef u_int8_t	nuint8;
typedef u_int16_t	nuint16;
typedef u_int32_t	nuint32;

typedef int		nint;
typedef int16_t		nint16;
typedef int32_t		nint32;

typedef uint_least16_t	nuint16a;
typedef uint_least32_t	nuint32a;
typedef int_least16_t	nint16a;
typedef int_least32_t	nint32a;

typedef u_int8_t	nbool8;

typedef nuint32a	nflag32;

typedef struct ncp_conn* NWCONN_HANDLE;
typedef struct nw_info_struct NW_ENTRY_INFO;
typedef nuint		NWCONN_NUM;	/* nuint16 ? */
#define nameLength nameLen

typedef struct {
	union {
	void*		rw;
	const void*	ro;
		} fragAddr;
#define fragAddress fragAddr.rw
	size_t	fragSize;
		} NW_FRAGMENT;

#define TR_READ		NCP_PERM_READ
#define TR_WRITE	NCP_PERM_WRITE
#define TR_CREATE	NCP_PERM_CREATE
#define TR_ERASE	NCP_PERM_DELETE
#define TR_ACCESS_CTRL	NCP_PERM_OWNER
#define TR_SEARCH	NCP_PERM_SEARCH
#define TR_MODIFY	NCP_PERM_MODIFY
#define TR_SUPERVISOR	NCP_PERM_SUPER

#define OT_USER		NCP_BINDERY_USER
#define OT_USER_GROUP	NCP_BINDERY_UGROUP
#define OT_FILE_SERVER	NCP_BINDERY_FSERVER

#define IM_NAME		RIM_NAME
#define IM_DIRECTORY	RIM_DIRECTORY
#define IM_ALL		RIM_ALL

#define A_READ_ONLY	0x00000001	/* aRDONLY... but it is htonl-ed... fixme... */
#define A_HIDDEN	0x00000002
#define A_SYSTEM	0x00000004
#define A_EXECUTE_ONLY	0x00000008
#define A_DIRECTORY	0x00000010
#define A_NEEDS_ARCHIVED 0x00000020
#define A_SHAREABLE	0x00000080
#define A_DONT_SUBALLOCATE 0x00000800
#define A_TRANSACTIONAL	0x00001000
#define A_INDEXED	0x00002000
#define A_READ_AUDIT	0x00004000
#define A_WRITE_AUDIT	0x00008000
#define A_IMMEDIATE_PURGE 0x00010000
#define A_RENAME_INHIBIT 0x00020000
#define A_DELETE_INHIBIT 0x00040000
#define A_COPY_INHIBIT	0x00080000
#define A_FILE_MIGRATED	0x00400000
#define A_DONT_MIGRATE	0x00800000
#define A_IMMEDIATE_COMPRESS 0x02000000
#define A_FILE_COMPRESSED 0x04000000
#define A_DONT_COMPRESS	0x08000000
#define A_CANT_COMPRESS	0x20000000

#define NWCC_RESERVED	0x00000000

#define NWCC_TRAN_TYPE_IPX	1
#define NWCC_TRAN_TYPE_UDP	8
#define NWCC_TRAN_TYPE_TCP	9

#define NWCC_OPEN_PRIVATE	0x00000004
#define NWCC_OPEN_PUBLIC	0x00000008

#define NWCC_INFO_CONN_NUMBER		     5
#define NWCC_INFO_USER_ID		     6
#define NWCC_INFO_SERVER_NAME		     7
#define NWCC_INFO_MAX_PACKET_SIZE	     9
#define NWCC_INFO_SERVER_VERSION	    12
#define NWCC_INFO_TRAN_ADDR		    13
#define NWCC_INFO_USER_NAME		0x4000
#define NWCC_INFO_ROOT_ENTRY		0x4001
#define NWCC_INFO_MOUNT_UID		0x4002
#define NWCC_INFO_SECURITY		0x4003

#define NW_MAX_SERVER_NAME_LEN		49

#define NWCC_SECUR_SIGNING_IN_USE	0x0001
#define NWCC_SECUR_LEVEL_CHECKSUM	0x0100
#define NWCC_SECUR_LEVEL_SIGN_HEADERS	0x0200
#define NWCC_SECUR_LEVEL_SIGN_ALL	0x0400
#define NWCC_SECUR_LEVEL_ENCRYPT	0x0800

typedef struct {
	unsigned int major;
	unsigned int minor;
	unsigned int revision;
} NWCCVersion;

typedef struct {
	nuint32	type;
	size_t	len;
	void*	buffer;
} NWCCTranAddr;

struct NWCCRootEntry {
	NWVOL_NUM	volume;
	NWDIR_ENTRY	dirEnt;
};

#ifdef __cplusplus
extern "C" {
#endif

/* misc */
NWCCODE NWCallsInit(void* __NULL1, void* __NULL2);
NWCCODE NWRequest(NWCONN_HANDLE __conn, nuint, nuint, const NW_FRAGMENT*, nuint, NW_FRAGMENT*);
NWCCODE NWRequestSimple(NWCONN_HANDLE __conn, nuint, const void*, size_t, NW_FRAGMENT*);

/* bindery */
NWCCODE NWGetObjectName(NWCONN_HANDLE __conn, NWObjectID, char*, NWObjectType*);
NWCCODE NWGetObjectID(NWCONN_HANDLE __conn, char*, NWObjectType, NWObjectID*);
NWCCODE NWGetBinderyAccessLevel(NWCONN_HANDLE __conn, nuint8* __rights, NWObjectID* __id);
NWCCODE NWLogoutFromFileServer(NWCONN_HANDLE __conn);	/* ncplib.c */
NWCCODE NWVerifyObjectPassword(NWCONN_HANDLE __conn, 
		const char*, NWObjectType, const char*); /* ncplib.c */

/* filesystem */
NWCCODE NWGetNSEntryInfo(NWCONN_HANDLE __conn, nuint, const char*, nuint, nuint, nuint16, nuint32, NW_ENTRY_INFO*);
NWCCODE NWParsePath(const char*, char*, NWCONN_HANDLE* __pconn, char*, char*);

NWCCODE ncp_get_volume_name(NWCONN_HANDLE __conn, NWVOL_NUM, char*, size_t);	/* filemgmt.c */
NWCCODE NWGetVolumeNumber(NWCONN_HANDLE __conn, NWVOL_NUM, char*);		/* filemgmt.c */
NWCCODE NWGetNSLoadedList(NWCONN_HANDLE __conn, 
			  NWVOL_NUM __vol, 
			  size_t __maxlen, 
			  nuint8* __nslist, 
			  size_t* __nslen);	/* filemgmt.c */

/* management services */
NWCCODE NWOpenBindery(NWCONN_HANDLE __conn);
NWCCODE NWCloseBindery(NWCONN_HANDLE __conn);
NWCCODE NWDownFileServer(NWCONN_HANDLE __conn, nuint __force);
NWCCODE NWEnableFileServerLogin(NWCONN_HANDLE __conn);
NWCCODE NWDisableFileServerLogin(NWCONN_HANDLE __conn);
NWCCODE NWDisableTTS(NWCONN_HANDLE __conn);
NWCCODE NWEnableTTS(NWCONN_HANDLE __conn);

/* RPC services */
NWCCODE NWSMLoadNLM(NWCONN_HANDLE __conn, const char*);
NWCCODE NWSMUnloadNLM(NWCONN_HANDLE __conn, const char*);
NWCCODE NWSMMountVolume(NWCONN_HANDLE __conn, const char*, nuint32*);
NWCCODE NWSMDismountVolumeByName(NWCONN_HANDLE __conn, const char*);
NWCCODE NWSMDismountVolumeByNumber(NWCONN_HANDLE __conn, nuint32);
NWCCODE NWSMExecuteNCFFile(NWCONN_HANDLE __conn, const char*);
NWCCODE NWSMSetDynamicCmdStrValue(NWCONN_HANDLE __conn, const char*, const char*);
NWCCODE NWSMSetDynamicCmdIntValue(NWCONN_HANDLE __conn, const char*, nuint32);

/* connection services */
NWCCODE NWClearConnectionNumber(NWCONN_HANDLE __conn, NWCONN_NUM);

NWCCODE NWGetObjectConnectionNumbers(NWCONN_HANDLE __conn, const char* name,
		NWObjectType type, size_t* noOfReturnedConns, NWCONN_NUM* conns,
		size_t maxConns);
NWCCODE NWGetConnListFromObject(NWCONN_HANDLE __conn, NWObjectID objID, 
		NWCONN_NUM firstConn,
		size_t* noOfReturnedConns, NWCONN_NUM* conns); /* returned max. 125 */
		
/* message services */
NWCCODE NWSendBroadcastMessage(NWCONN_HANDLE __conn, const char* message,
		size_t conns, NWCONN_NUM* connArray, nuint8* deliveryStatus);

/* local connection services */
NWCCODE NWGetConnectionNumber(NWCONN_HANDLE __conn, NWCONN_NUM*);
NWCCODE NWGetFileServerName(NWCONN_HANDLE __conn, char*);
NWCCODE NWGetFileServerVersion(NWCONN_HANDLE __conn, u_int16_t* version);

NWCCODE NWCCGetConnInfo(NWCONN_HANDLE __conn, nuint info, size_t len, void*);
NWCCODE NWCCOpenConnBySockAddr(const struct sockaddr* addr, 
		enum NET_ADDRESS_TYPE type, nuint openState,
		nuint reserved, NWCONN_HANDLE* __pconn);
NWCCODE NWCCOpenConnByAddr(const NWCCTranAddr* addr, nuint openState,
		nuint reserved, NWCONN_HANDLE* __pconn);
NWCCODE NWCCCloseConn(NWCONN_HANDLE __conn);

#ifdef __cplusplus
}
#endif
		
#endif	/* __NWCALLS_H__ */

