/*
 * <kupdate.h>
 * Interaction with kupdate kernel daemon.
 * 
 * (C) 2000 Daniel Kobras <kobras@linux.de>
 * 
 * $Id: kupdate.h,v 1.4 2000/10/04 20:20:01 belbo Exp $
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */             

#include <stdio.h>
#include <sys/types.h>

#ifndef _NFD_KUPDATE_H
#define _NFD_KUPDATE_H

typedef struct kupdate_s {
	int	stopped;
	long	interval;
	pid_t	pid;
	FILE	*stat;
} *kupdate_t;

/* Initialise kupdate handle. */
kupdate_t kupdate_init(void);
/* Query kupdate wakeup interval. */
long kupdate_get_interval(kupdate_t);
/* Set kupdate to new state. */
void __kupdate_start(kupdate_t);
void __kupdate_stop(kupdate_t);

/* Wrappers to start/stop kupdate daemon. */
static inline void kupdate_start(kupdate_t k)
{
	if (!k->stopped)
		return;
	__kupdate_start(k);
}

static inline void kupdate_stop(kupdate_t k)
{
	if (k->stopped)
		return;
	__kupdate_stop(k);
}

#endif
