#ifndef __STRUCTFILL_H__
#define __STRUCTFILL_H__

#include <stdarg.h>
#include <string.h>

#include "session.h"
#include "oidseq.h"

class TableEntry {
public:
  const char *oidstr;
  Tags type;
  unsigned int offset;

  struct TableEntry *next;

  TableEntry(const char *ostr,Tags thetype,unsigned int off,
	     TableEntry *nxt);
  
  int operator==(const char *str){ return !strcmp(str,oidstr);}
};

class SNMP_structFiller{
  TableEntry *tabdef;
  OidSeq *oidseq;
  OidSeq *retseq;
  SNMP_session &session;

  SNMP_structFiller(SNMP_session &sess, unsigned int num, va_list args);
  int fillStruct(OidSeq *data,unsigned char *curstruct);
public:
  inline SNMP_structFiller(SNMP_session &sess): tabdef(NULL),oidseq(NULL),
    session(sess),retseq(NULL){}

  ~SNMP_structFiller();

  void append(const char *oidstr,Tags tag,unsigned int offset);
  void remove(const char *oidstr);
  void reset(){delete retseq; retseq=NULL;}

  void *get(void *tobefilled);
  void *get_next(void *tobefilled);
};

class SNMP_table:public SNMP_structFiller{
  unsigned int structlen;
public:
  inline SNMP_table(SNMP_session &session, unsigned int slen):
    structlen(slen),SNMP_structFiller(session){}

  /* returns a pointer to a vector of the type defined with the 
     data elements filled in. needs to be freed. */
  void *get(unsigned int &len);
};

#endif
