/*
 *  wordtree.h - 
 *
 *  Copyright (C) 2003 Giuseppe Modugno
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

typedef struct WTelem WTelem;
typedef struct SLelem SLelem;

/* Definition of WTelem (Word Tree element). A single element of the tree
 * structure. */
struct WTelem {
  char *word;            /* Null-terminating string that represents word. */
  unsigned int index;    /* Index of word in the sorted list. */
  unsigned char isword;  /* 1 if word is a "word" (first column). */
  
  SLelem *synlist;       /* Pointer to synonimous list first element. */
  unsigned int num_syn;  /* Number of synonimous for the word. */
  
  WTelem *left;          /* Left subtree of the element. */
  WTelem *right;          /* Right subtree of the element. */
};


/* Definition of SLelem (Synonimous List element). A single element
 * of the list of synonimous. */
struct SLelem {
  WTelem *syn;			/* Pointer to the synonimous (in the tree). */
  SLelem *next;			/* Pointer to the next synonimous. */
};


/* Function prototypes. */
WTelem *wordtree_add( char *word, WTelem **tree );
SLelem *synlist_add( WTelem *word, WTelem *syn );
void wordtree_output( WTelem *tree, FILE *idx, FILE *dat );
void wordtree_free( WTelem *tree );
