//                                               -*- C++ -*-
/**
 *  @brief The external header file of OpenTURNS for subdir Algo
 *
 *  Copyright 2005-2015 Airbus-EDF-IMACS-Phimeca
 *
 *  This library is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef OPENTURNS_OTALGO_HXX
#define OPENTURNS_OTALGO_HXX

#include "ApproximationAlgorithmImplementation.hxx"
#include "ApproximationAlgorithm.hxx"
#include "ApproximationAlgorithmImplementationFactory.hxx"
#include "ClassifierImplementation.hxx"
#include "Classifier.hxx"
#include "ApproximationAlgorithm.hxx"
#include "FittingAlgorithmImplementation.hxx"
#include "FittingAlgorithm.hxx"
#include "KDTree.hxx"
#include "KFold.hxx"
#include "CorrectedLeaveOneOut.hxx"
#include "LeastSquaresMetaModelSelection.hxx"
#include "LeastSquaresMetaModelSelectionFactory.hxx"
#include "PenalizedLeastSquaresAlgorithm.hxx"
#include "PenalizedLeastSquaresAlgorithmFactory.hxx"
#include "FFTImplementation.hxx"
#include "FFT.hxx"
#include "KissFFT.hxx"
#include "IntegrationAlgorithmImplementation.hxx"
#include "IntegrationAlgorithm.hxx"
#include "GaussKronrod.hxx"
#include "GaussKronrodRule.hxx"
#include "IteratedQuadrature.hxx"
#include "KarhunenLoeveP1Factory.hxx"

#endif /* OPENTURNS_OTALGO_HXX */
