/*
 * Author: 
 *  Richard Hult <rhult@codefactory.se>
 * 
 * Copyright (C) 1999-2001  Richard Hult 
 * 
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the 
 * License, or (at your option) any later version. 
 * 
 * This program is distributed in the hope that it will be useful, 
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#include <config.h>
#include <gnome.h>
#include "dialogs.h"
#include "main.h"

static void about_destroy_event (void);
static GtkWidget *about = NULL;

void
oregano_error (gchar *msg)
{
	GtkWidget *dialog;
	dialog = gnome_message_box_new (
		msg, 
		GNOME_MESSAGE_BOX_ERROR, 
		GNOME_STOCK_BUTTON_OK, 
		NULL);
	
	gnome_dialog_run_and_close (GNOME_DIALOG (dialog));
}

gint
oregano_question (gchar *msg)
{
	GtkWidget *dialog;
	gint ans;

	dialog = gnome_message_box_new (
		msg, 
		GNOME_MESSAGE_BOX_QUESTION, 
		GNOME_STOCK_BUTTON_OK,
		GNOME_STOCK_BUTTON_CANCEL,
		NULL);
	
	ans = gnome_dialog_run_and_close (GNOME_DIALOG (dialog));

	if (ans == 0)
		return 1;
	else
		return 0;
}

void
dialog_about (void)
{
        const gchar *authors[] = {
		"Richard Hult <richard.hult@telia.com>",
		NULL
	};
	
	/* Allow only one about box at a time. */
	if (about){
		gdk_window_raise (about->window);
		return;
	}
	
        about = gnome_about_new (
		"Oregano", 
		VERSION,
		_("(c) 1999, 2000, 2001  Richard Hult"),
		authors,
		_("Schematic capture and circuit simulation.\n"),
		NULL);
	
	gnome_dialog_set_close (GNOME_DIALOG (about), TRUE);
	gtk_signal_connect (GTK_OBJECT (about),
			    "destroy",
			    (GtkSignalFunc) about_destroy_event,
			    NULL);
	
	gtk_widget_show (about);
}
	
static void
about_destroy_event (void)
{
	about = NULL;
}

