/*
 * node.h
 *
 * 
 * Author: 
 *  Richard Hult <rhult@hem.passagen.se>
 * 
 *  http://www.dtek.chalmers.se/~d4hult/oregano/ 
 * 
 * Copyright (C) 1999,2000  Richard Hult 
 * 
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the 
 * License, or (at your option) any later version. 
 * 
 * This program is distributed in the hope that it will be useful, 
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef __NODE_H
#define __NODE_H

#include <gtk/gtk.h>
#include "sheet-pos.h"
#include "part.h"

#define TYPE_NODE            (node_get_type ())
#define NODE(obj)            (GTK_CHECK_CAST ((obj), TYPE_NODE, Node))
#define NODE_CLASS(klass)    (GTK_CHECK_CLASS_CAST ((klass), TYPE_NODE, NodeClass))
#define IS_NODE(obj)         (GTK_CHECK_TYPE ((obj), TYPE_NODE))
#define IS_NODE_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), TYPE_NODE))

typedef struct _Node Node;
typedef struct _NodeClass NodeClass;

#include "wire.h"

struct _Node {
	GtkObject parent;

	/*
	 * Used for traversing all nodes in the netlist generation.
	 */
	guint visited : 1;

	char *netlist_node_name;
	
	/*
	 * The number of wires and pins in this node. 
	 */
	guint16 pin_count;
	guint16 wire_count;

	GSList *pins;
	GSList *wires;

	SheetPos key;
};

struct _NodeClass
{
	GtkObjectClass parent_class;
	
/*	void (*something) (Node *node);*/
};

guint node_get_type (void);
Node *node_new (SheetPos pos);
gint node_is_empty (Node *node);

gint node_add_pin (Node *node, Pin *pin);
gint node_remove_pin (Node *node, Pin *pin);

gint node_add_wire (Node *node, Wire *wire);
gint node_remove_wire (Node *node, Wire *wire);

gint node_is_visited (Node *node);
void node_set_visited (Node *node, gboolean is_visited);

gboolean node_needs_dot (Node *node);

#endif
