#==========================================================
# Views --
#
#   handling of PostgreSQL views, most of which is in
#   Queries namespace
#==========================================================
#
namespace eval Views {}


#----------------------------------------------------------
#----------------------------------------------------------
#
proc ::Views::new {} {

    global PgAcVar

    set PgAcVar(query,oid) 0
    set PgAcVar(query,name) {}

    Window show .pgaw:QueryBuilder

    set PgAcVar(query,asview) 1

    $::Queries::Win(saveasview) configure -state disabled

}; # end proc ::Views::new


#----------------------------------------------------------
#----------------------------------------------------------
#
proc ::Views::open {viewname_} {

    global PgAcVar

    if {$viewname_==""} return;
    set wn [Tables::getNewWindowName]

    Tables::createWindow

    set PgAcVar(mw,$wn,query) "SELECT * FROM [::Database::quoteObject $viewname_]"
    set PgAcVar(mw,$wn,isaquery) 0
    set PgAcVar(mw,$wn,updatable) 0

    Tables::loadLayout $wn $viewname_
    Tables::selectRecords $wn $PgAcVar(mw,$wn,query)

}; # end proc ::Views::open


#----------------------------------------------------------
#----------------------------------------------------------
#
proc ::Views::design {viewname_} {

    global PgAcVar CurrentDB

    set vd {}

    wpg_select $CurrentDB "SELECT pg_get_viewdef('$viewname_')as vd" tup {
        set vd $tup(vd)
    }

    if {$vd==""} {
        showError "[intlmsg {Error retrieving view definition for}] '$viewname_'!"
        return
    }

    Window show .pgaw:QueryBuilder
    $::Queries::Win(qrytxt) delete 0.0 end
    $::Queries::Win(qrytxt) insert end $vd

    set PgAcVar(query,asview) 1

    $::Queries::Win(saveasview) configure -state disabled

    set PgAcVar(query,name) $viewname_

    Syntax::highlight $::Queries::Win(qrytxt) sql

}; # end proc ::Views::design


#----------------------------------------------------------
# ::Views::introspect --
#
#   Given a viewname, returns the SQL needed to recreate it
#
# Arguments:
#   viewname_  name of a view to introspect
#   dbh_       an optional database handle
#
# Returns:
#   insql      the CREATE statement to make this view
#----------------------------------------------------------
#
proc ::Views::introspect {viewname_ {dbh_ ""}} {

    set insql [::Views::clone $viewname_ $viewname_ $dbh_]

    return $insql

}; # end proc ::Views::introspect


#----------------------------------------------------------
# ::Views::clone --
#
#   Like introspect, only changes the viewname
#
# Arguments:
#   srcview_    the original view
#   destview_   the clone view
#   dbh_        an optional database handle
#
# Returns:
#   insql       the CREATE statement to clone this view
#----------------------------------------------------------
#
proc ::Views::clone {srcview_ destview_ {dbh_ ""}} {

    global CurrentDB

    if {[string match "" $dbh_]} {
        set dbh_ $CurrentDB
    }

    set insql ""

    set sql "SELECT pg_get_viewdef('[::Database::quoteObject $srcview_]')
                 AS vd"

    wpg_select $dbh_ $sql rec {
        set insql "
            CREATE VIEW [::Database::quoteObject $destview_]
                     AS $rec(vd)"
    }

    return $insql

}; # end proc ::Views::clone


