/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.io.File;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Vector;
import loci.formats.Location;
import loci.formats.LogTools;
import loci.formats.NumberFilter;

public class FilePattern {
    private String pattern;
    private boolean valid;
    private String msg;
    private int[] startIndex;
    private int[] endIndex;
    private BigInteger[] begin;
    private BigInteger[] end;
    private BigInteger[] step;
    private int[] count;
    private boolean[] fixed;
    private int[] zeroes;
    private String[] files;

    public FilePattern(Location file) {
        this(FilePattern.findPattern(file));
    }

    public FilePattern(String name, String dir) {
        this(FilePattern.findPattern(name, dir));
    }

    public FilePattern(String pattern) {
        int i;
        this.pattern = pattern;
        this.valid = false;
        if (pattern == null) {
            this.msg = "Null pattern string.";
            return;
        }
        int len = pattern.length();
        Vector<Integer> lt = new Vector<Integer>(len);
        Vector<Integer> gt = new Vector<Integer>(len);
        int left = -1;
        while ((left = pattern.indexOf("<", left + 1)) >= 0) {
            lt.add(new Integer(left));
        }
        int right = -1;
        while ((right = pattern.indexOf(">", right + 1)) >= 0) {
            gt.add(new Integer(right));
        }
        int num = lt.size();
        if (num != gt.size()) {
            this.msg = "Mismatched numerical block markers.";
            return;
        }
        this.startIndex = new int[num];
        this.endIndex = new int[num];
        for (i = 0; i < num; ++i) {
            int val = (Integer)lt.elementAt(i);
            if (i > 0 && val < this.endIndex[i - 1]) {
                this.msg = "Bad numerical block marker order.";
                return;
            }
            this.startIndex[i] = val;
            val = (Integer)gt.elementAt(i);
            if (val <= this.startIndex[i]) {
                this.msg = "Bad numerical block marker order.";
                return;
            }
            this.endIndex[i] = val + 1;
        }
        this.begin = new BigInteger[num];
        this.end = new BigInteger[num];
        this.step = new BigInteger[num];
        this.count = new int[num];
        this.fixed = new boolean[num];
        this.zeroes = new int[num];
        for (i = 0; i < num; ++i) {
            String s;
            String b;
            String e;
            String block = pattern.substring(this.startIndex[i], this.endIndex[i]);
            int dash = block.indexOf("-");
            if (dash < 0) {
                b = e = block.substring(1, block.length() - 1);
                s = "1";
            } else {
                int colon = block.indexOf(":");
                b = block.substring(1, dash);
                if (colon < 0) {
                    e = block.substring(dash + 1, block.length() - 1);
                    s = "1";
                } else {
                    e = block.substring(dash + 1, colon);
                    s = block.substring(colon + 1, block.length() - 1);
                }
            }
            try {
                this.begin[i] = new BigInteger(b);
                this.end[i] = new BigInteger(e);
                if (this.begin[i].compareTo(this.end[i]) > 0) {
                    this.msg = "Begin value cannot be greater than ending value.";
                    return;
                }
                this.step[i] = new BigInteger(s);
                if (this.step[i].compareTo(BigInteger.ONE) < 0) {
                    this.msg = "Step value must be at least one.";
                    return;
                }
                this.count[i] = this.end[i].subtract(this.begin[i]).divide(this.step[i]).intValue() + 1;
                this.fixed[i] = b.length() == e.length();
                int z = 0;
                for (z = 0; z < e.length() && e.charAt(z) == '0'; ++z) {
                }
                this.zeroes[i] = z;
                continue;
            }
            catch (NumberFormatException exc) {
                this.msg = "Invalid numerical range values.";
                return;
            }
        }
        Vector v = new Vector();
        this.buildFiles("", num, v);
        this.files = new String[v.size()];
        v.copyInto(this.files);
        this.valid = true;
    }

    public String getPattern() {
        return this.pattern;
    }

    public boolean isValid() {
        return this.valid;
    }

    public String getErrorMessage() {
        return this.msg;
    }

    public BigInteger[] getFirst() {
        return this.begin;
    }

    public BigInteger[] getLast() {
        return this.end;
    }

    public BigInteger[] getStep() {
        return this.step;
    }

    public int[] getCount() {
        return this.count;
    }

    public String[] getFiles() {
        return this.files;
    }

    public String getBlock(int i) {
        if (i < 0 || i >= this.startIndex.length) {
            return null;
        }
        return this.pattern.substring(this.startIndex[i], this.endIndex[i]);
    }

    public String[] getBlocks() {
        String[] s = new String[this.startIndex.length];
        for (int i = 0; i < s.length; ++i) {
            s[i] = this.getBlock(i);
        }
        return s;
    }

    public String getPrefix() {
        int dot;
        int s = this.pattern.lastIndexOf(File.separator) + 1;
        int e = this.startIndex.length > 0 ? this.startIndex[0] : ((dot = this.pattern.lastIndexOf(".")) < s ? this.pattern.length() : dot);
        return s <= e ? this.pattern.substring(s, e) : "";
    }

    public String getSuffix() {
        return this.endIndex.length > 0 ? this.pattern.substring(this.endIndex[this.endIndex.length - 1]) : this.pattern;
    }

    public String getPrefix(int i) {
        if (i < 0 || i >= this.startIndex.length) {
            return null;
        }
        int s = i > 0 ? this.endIndex[i - 1] : this.pattern.lastIndexOf(File.separator) + 1;
        int e = this.startIndex[i];
        return s <= e ? this.pattern.substring(s, e) : null;
    }

    public String[] getPrefixes() {
        String[] s = new String[this.startIndex.length];
        for (int i = 0; i < s.length; ++i) {
            s[i] = this.getPrefix(i);
        }
        return s;
    }

    public static String findPattern(Location file) {
        return FilePattern.findPattern(file.getName(), file.getAbsoluteFile().getParent());
    }

    public static String findPattern(File file) {
        return FilePattern.findPattern(file.getName(), file.getAbsoluteFile().getParent());
    }

    public static String findPattern(String name, String dir) {
        if (dir == null) {
            dir = "";
        } else if (!dir.equals("") && !dir.endsWith(File.separator)) {
            dir = dir + File.separator;
        }
        Location dirFile = new Location(dir.equals("") ? "." : dir);
        Location[] f = dirFile.listFiles();
        if (f == null) {
            return null;
        }
        String[] nameList = new String[f.length];
        for (int i = 0; i < nameList.length; ++i) {
            nameList[i] = f[i].getName();
        }
        return FilePattern.findPattern(name, dir, nameList);
    }

    public static String findPattern(String name, String dir, String[] nameList) {
        if (dir == null) {
            dir = "";
        } else if (!dir.equals("") && !dir.endsWith(File.separator)) {
            dir = dir + File.separator;
        }
        int len = name.length();
        int bound = (len + 1) / 2;
        int[] indexList = new int[bound];
        int[] endList = new int[bound];
        int q = 0;
        boolean num = false;
        int ndx = -1;
        int e = 0;
        for (int i = 0; i < len; ++i) {
            char c = name.charAt(i);
            if (c >= '0' && c <= '9') {
                if (num) {
                    ++e;
                    continue;
                }
                num = true;
                ndx = i;
                e = ndx + 1;
                continue;
            }
            if (!num) continue;
            num = false;
            indexList[q] = ndx;
            endList[q] = e;
            ++q;
        }
        if (num) {
            indexList[q] = ndx;
            endList[q] = e;
            ++q;
        }
        StringBuffer sb = new StringBuffer(dir);
        for (int i = 0; i < q; ++i) {
            int last = i > 0 ? endList[i - 1] : 0;
            sb.append(name.substring(last, indexList[i]));
            String pre = name.substring(0, indexList[i]);
            String post = name.substring(endList[i]);
            NumberFilter filter = new NumberFilter(pre, post);
            String[] list = FilePattern.matchFiles(nameList, filter);
            if (list == null || list.length == 0) {
                return null;
            }
            if (list.length == 1) {
                sb.append(name.substring(indexList[i], endList[i]));
                continue;
            }
            boolean fix = true;
            for (int j = 0; j < list.length; ++j) {
                if (list[j].length() == len) continue;
                fix = false;
                break;
            }
            if (fix) {
                int jx;
                int j;
                int width = endList[i] - indexList[i];
                boolean[] same = new boolean[width];
                block3: for (j = 0; j < width; ++j) {
                    same[j] = true;
                    jx = indexList[i] + j;
                    char c = name.charAt(jx);
                    for (int k = 0; k < list.length; ++k) {
                        if (list[k].charAt(jx) == c) continue;
                        same[j] = false;
                        continue block3;
                    }
                }
                j = 0;
                while (j < width) {
                    jx = indexList[i] + j;
                    if (same[j]) {
                        sb.append(name.charAt(jx));
                        ++j;
                        continue;
                    }
                    while (j < width && !same[j]) {
                        ++j;
                    }
                    String p = FilePattern.findPattern(name, nameList, jx, indexList[i] + j, "");
                    if (p == null) {
                        return null;
                    }
                    sb.append(p);
                }
                continue;
            }
            Object[] numbers = new BigInteger[list.length];
            for (int j = 0; j < list.length; ++j) {
                numbers[j] = filter.getNumber(list[j]);
            }
            Arrays.sort(numbers);
            String bounds = FilePattern.getBounds((BigInteger[])numbers, false);
            if (bounds == null) {
                return null;
            }
            sb.append(bounds);
        }
        sb.append(q > 0 ? name.substring(endList[q - 1]) : name);
        return sb.toString();
    }

    private static String findPattern(String name, String[] nameList, int ndx, int end, String p) {
        if (ndx == end) {
            return p;
        }
        for (int i = end - ndx; i >= 1; --i) {
            String pat;
            NumberFilter filter = new NumberFilter(name.substring(0, ndx), name.substring(ndx + i));
            String[] list = FilePattern.matchFiles(nameList, filter);
            Object[] numbers = new BigInteger[list.length];
            for (int j = 0; j < list.length; ++j) {
                numbers[j] = new BigInteger(list[j].substring(ndx, ndx + i));
            }
            Arrays.sort(numbers);
            String bounds = FilePattern.getBounds((BigInteger[])numbers, true);
            if (bounds == null || (pat = FilePattern.findPattern(name, nameList, ndx + i, end, p + bounds)) == null) continue;
            return pat;
        }
        return null;
    }

    private static String getBounds(BigInteger[] numbers, boolean fixed) {
        if (numbers.length < 2) {
            return null;
        }
        BigInteger b = numbers[0];
        BigInteger e = numbers[numbers.length - 1];
        BigInteger s = numbers[1].subtract(b);
        if (s.equals(BigInteger.ZERO)) {
            return null;
        }
        for (int i = 2; i < numbers.length; ++i) {
            if (numbers[i].subtract(numbers[i - 1]).equals(s)) continue;
            return null;
        }
        String sb = b.toString();
        String se = e.toString();
        StringBuffer bounds = new StringBuffer("<");
        if (fixed) {
            int zeroes = se.length() - sb.length();
            for (int i = 0; i < zeroes; ++i) {
                bounds.append("0");
            }
        }
        bounds.append(sb);
        bounds.append("-");
        bounds.append(se);
        if (!s.equals(BigInteger.ONE)) {
            bounds.append(":");
            bounds.append(s);
        }
        bounds.append(">");
        return bounds.toString();
    }

    private static String[] matchFiles(String[] inFiles, NumberFilter filter) {
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < inFiles.length; ++i) {
            if (!filter.accept(inFiles[i])) continue;
            v.add(inFiles[i]);
        }
        Object[] s = new String[v.size()];
        v.copyInto(s);
        return s;
    }

    private void buildFiles(String prefix, int ndx, Vector fileList) {
        int num = this.startIndex.length;
        int n1 = ndx == 0 ? 0 : this.endIndex[ndx - 1];
        int n2 = ndx == num ? this.pattern.length() : this.startIndex[ndx];
        String pre = this.pattern.substring(n1, n2);
        if (ndx == 0) {
            fileList.add(pre + prefix);
        } else {
            BigInteger bi = this.begin[--ndx];
            while (bi.compareTo(this.end[ndx]) <= 0) {
                String s = bi.toString();
                int z = this.zeroes[ndx];
                if (this.fixed[ndx]) {
                    z += this.end[ndx].toString().length() - s.length();
                }
                for (int j = 0; j < z; ++j) {
                    s = "0" + s;
                }
                this.buildFiles(s + pre + prefix, ndx, fileList);
                bi = bi.add(this.step[ndx]);
            }
        }
    }

    public static void main(String[] args) {
        int i;
        String pat = null;
        if (args.length > 0) {
            Location file = new Location(args[0]);
            LogTools.println("File = " + file.getAbsoluteFile());
            pat = FilePattern.findPattern(file);
        } else {
            String[] nameList = new String[289];
            nameList[0] = "outlier.ext";
            int count = 1;
            for (i = 1; i <= 2; ++i) {
                for (int j = 1; j <= 4; ++j) {
                    for (int k = 0; k <= 2; ++k) {
                        for (int l = 1; l <= 12; ++l) {
                            String sl = (l < 10 ? "0" : "") + l;
                            nameList[count++] = "hypothetical" + sl + k + j + "c" + i + ".ext";
                        }
                    }
                }
            }
            pat = FilePattern.findPattern(nameList[1], null, nameList);
        }
        if (pat == null) {
            LogTools.println("No pattern found.");
        } else {
            LogTools.println("Pattern = " + pat);
            FilePattern fp = new FilePattern(pat);
            if (fp.isValid()) {
                LogTools.println("Pattern is valid.");
                LogTools.println("Files:");
                String[] ids = fp.getFiles();
                for (i = 0; i < ids.length; ++i) {
                    LogTools.println("  #" + i + ": " + ids[i]);
                }
            } else {
                LogTools.println("Pattern is invalid: " + fp.getErrorMessage());
            }
        }
    }
}

