/*
 * Decompiled with CFR 0.152.
 */
package visad.data.mcidas;

import edu.wisc.ssec.mcidas.AreaDirectory;
import edu.wisc.ssec.mcidas.AreaFile;
import edu.wisc.ssec.mcidas.AreaFileFactory;
import edu.wisc.ssec.mcidas.McIDASException;
import java.io.IOException;
import java.rmi.RemoteException;
import visad.CoordinateSystem;
import visad.DateTime;
import visad.FlatField;
import visad.FunctionType;
import visad.Integer1DSet;
import visad.Linear2DSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.Set;
import visad.Unit;
import visad.UnitException;
import visad.VisADException;
import visad.data.mcidas.AREACoordinateSystem;
import visad.data.units.Parser;
import visad.jmet.MetUnits;
import visad.meteorology.NavigatedImage;
import visad.meteorology.SingleBandedImage;
import visad.meteorology.SingleBandedImageImpl;

public class AreaAdapter {
    private FlatField field = null;
    private AREACoordinateSystem cs;
    private AreaDirectory areaDirectory;
    private AreaFile af;

    public AreaAdapter(String imageSource) throws IOException, VisADException {
        this(imageSource, 0, 0, 0, 0, 0, 0, -1, 0, true);
    }

    public AreaAdapter(String imageSource, int cal) throws IOException, VisADException {
        this(imageSource, 0, 0, 0, 0, 0, 0, cal, 0, true);
    }

    public AreaAdapter(String imageSource, boolean pack) throws IOException, VisADException {
        this(imageSource, 0, 0, 0, 0, 0, 0, -1, 0, pack);
    }

    public AreaAdapter(String imageSource, int startLine, int startEle, int numLines, int numEles) throws IOException, VisADException {
        this(imageSource, startLine, startEle, numLines, numEles, 0, 0, -1, 0, true);
    }

    public AreaAdapter(String imageSource, int startLine, int startEle, int numLines, int numEles, int band) throws IOException, VisADException {
        this(imageSource, startLine, startEle, numLines, numEles, 0, 0, -1, band, true);
    }

    public AreaAdapter(String imageSource, int startLine, int startEle, int numLines, int numEles, int band, boolean pack) throws IOException, VisADException {
        this(imageSource, startLine, startEle, numLines, numEles, 0, 0, -1, band, pack);
    }

    public AreaAdapter(String imageSource, int startLine, int startEle, int numLines, int numEles, int lineMag, int eleMag, int band) throws IOException, VisADException {
        this(imageSource, startLine, startEle, numLines, numEles, lineMag, eleMag, -1, band, true);
    }

    public AreaAdapter(String imageSource, int startLine, int startEle, int numLines, int numEles, int lineMag, int eleMag, int cal, int band) throws IOException, VisADException {
        this(imageSource, startLine, startEle, numLines, numEles, lineMag, eleMag, cal, band, true);
    }

    public AreaAdapter(String imageSource, int startLine, int startEle, int numLines, int numEles, int lineMag, int eleMag, int band, boolean pack) throws IOException, VisADException {
        this(imageSource, startLine, startEle, numLines, numEles, lineMag, eleMag, -1, band, pack);
    }

    public AreaFile getAreaFile() {
        return this.af;
    }

    public AreaAdapter(String imageSource, int startLine, int startEle, int numLines, int numEles, int lineMag, int eleMag, int cal, int band, boolean pack) throws IOException, VisADException {
        try {
            boolean paramSubset;
            this.af = AreaFileFactory.getAreaFileInstance(imageSource);
            if (this.af.getCalType() == -1) {
                this.af.setCalType(cal);
            }
            AreaDirectory dir = this.af.getAreaDirectory();
            boolean bl = paramSubset = numLines != 0 && numEles != 0 && band != 0;
            if (this.af.isSubsetted()) {
                this.buildFlatField(this.af, 0, 0, dir.getLines(), dir.getElements(), dir.getBands()[0], pack);
            } else if (!this.af.isSubsetted() && paramSubset) {
                this.af = AreaFileFactory.getAreaFileInstance(imageSource, startLine, numLines, lineMag, startEle, numEles, eleMag, band);
                if (this.af.getCalType() == -1) {
                    this.af.setCalType(cal);
                }
                dir = this.af.getAreaDirectory();
                this.buildFlatField(this.af, 0, 0, dir.getLines(), dir.getElements(), dir.getBands()[0], pack);
            } else {
                this.buildFlatField(this.af, 0, 0, dir.getLines(), dir.getElements(), 0, pack);
            }
        }
        catch (McIDASException afe) {
            throw new VisADException("Problem with McIDAS AREA file: " + afe);
        }
    }

    private void buildFlatField(AreaFile af, int startLine, int startEle, int numLines, int numEles, int band, boolean pack) throws VisADException {
        float[][][] flt_samples;
        int i;
        int[] nav = null;
        int[] aux = null;
        try {
            this.areaDirectory = af.getAreaDirectory();
            nav = af.getNav();
            aux = af.getAux();
        }
        catch (Exception rmd) {
            throw new VisADException("Problem getting Area file directory or navigation: " + rmd);
        }
        int nLines = numLines == 0 ? this.areaDirectory.getLines() : numLines;
        int nEles = numEles == 0 ? this.areaDirectory.getElements() : numEles;
        RealType line = RealType.getRealType("ImageLine", null, null);
        RealType element = RealType.getRealType("ImageElement", null, null);
        int[] bandNums = this.areaDirectory.getBands();
        int numBands = this.areaDirectory.getNumberOfBands();
        int[] bandIndices = new int[numBands];
        if (band != 0) {
            bandIndices[0] = -1;
            for (i = 0; i < numBands; ++i) {
                if (band != bandNums[i]) continue;
                bandIndices[0] = i;
                break;
            }
            if (bandIndices[0] == -1) {
                throw new VisADException("requested band number not in image");
            }
            bandNums = new int[]{band};
            numBands = 1;
        } else {
            for (i = 0; i < numBands; ++i) {
                bandIndices[i] = i;
            }
        }
        RealType[] bands = new RealType[numBands];
        Unit calUnit = null;
        float calScale = 1.0f;
        String unit = this.areaDirectory.getCalibrationUnitName();
        if (unit != null) {
            try {
                String unitName = MetUnits.makeSymbol(this.areaDirectory.getCalibrationUnitName());
                calUnit = Parser.parse(unitName);
                try {
                    calUnit = calUnit.clone(unitName);
                }
                catch (UnitException ue) {}
            }
            catch (Exception e) {
                calUnit = null;
            }
            calScale = 1.0f / (float)this.areaDirectory.getCalibrationScaleFactor();
        }
        String calType = this.areaDirectory.getCalibrationType();
        for (int i2 = 0; i2 < numBands; ++i2) {
            bands[i2] = calUnit != null ? RealType.getRealType("Band" + bandNums[i2] + "_" + calType, calUnit) : RealType.getRealType("Band" + bandNums[i2]);
        }
        RealTupleType radiance = new RealTupleType(bands);
        RealType[] domain_components = new RealType[]{element, line};
        try {
            int[] dirBlock = (int[])this.areaDirectory.getDirectoryBlock().clone();
            this.cs = new AREACoordinateSystem(dirBlock, nav, aux);
        }
        catch (VisADException e) {
            System.out.println(e);
            System.out.println("Using null CoordinateSystem");
            this.cs = null;
        }
        RealTupleType image_domain = new RealTupleType(domain_components, (CoordinateSystem)this.cs, null);
        Linear2DSet domain_set = new Linear2DSet((MathType)image_domain, 0.0, (double)(nEles - 1), nEles, nLines - 1, 0.0, nLines);
        FunctionType image_type = new FunctionType(image_domain, radiance);
        Set[] rangeSets = null;
        boolean bl = pack = pack && calType.equalsIgnoreCase("BRIT");
        if (pack) {
            rangeSets = new Set[numBands];
            for (int i3 = 0; i3 < numBands; ++i3) {
                rangeSets[i3] = new Integer1DSet((MathType)bands[i3], 255);
            }
        }
        Unit[] rangeUnits = null;
        if (calUnit != null) {
            rangeUnits = new Unit[numBands];
            for (int i4 = 0; i4 < numBands; ++i4) {
                rangeUnits[i4] = calUnit;
            }
        }
        this.field = new FlatField(image_type, (Set)domain_set, (CoordinateSystem[])null, rangeSets, rangeUnits);
        if (radiance.getDimension() == 1) {
            this.field = this.cs == null ? new SingleBandedImageImpl(this.field, this.getNominalTime(), "McIDAS Image") : new NavigatedImage(this.field, this.getNominalTime(), "McIDAS Image");
        }
        try {
            flt_samples = af.getFloatData();
        }
        catch (McIDASException samp) {
            throw new VisADException("Problem reading AREA file: " + samp);
        }
        try {
            float[][] samples = new float[numBands][nEles * nLines];
            if (pack) {
                for (int b = 0; b < numBands; ++b) {
                    for (int i5 = 0; i5 < nLines; ++i5) {
                        for (int j = 0; j < nEles; ++j) {
                            float val = flt_samples[bandIndices[b]][startLine + i5][startEle + j];
                            samples[b][j + nEles * i5] = val == 255.0f ? 254.0f : val * calScale;
                        }
                    }
                }
            } else {
                for (int b = 0; b < numBands; ++b) {
                    for (int i6 = 0; i6 < nLines; ++i6) {
                        for (int j = 0; j < nEles; ++j) {
                            samples[b][j + nEles * i6] = calScale * flt_samples[bandIndices[b]][startLine + i6][startEle + j];
                        }
                    }
                }
            }
            this.field.setSamples(samples, false);
        }
        catch (RemoteException e) {
            throw new VisADException("Couldn't finish image initialization");
        }
    }

    public int[] getDimensions() {
        int[] dim = new int[]{this.areaDirectory.getNumberOfBands(), this.areaDirectory.getElements(), this.areaDirectory.getLines()};
        return dim;
    }

    public CoordinateSystem getCoordinateSystem() {
        return this.cs;
    }

    public AreaDirectory getAreaDirectory() {
        return this.areaDirectory;
    }

    public FlatField getData() {
        return this.field;
    }

    public DateTime getNominalTime() throws VisADException {
        return new DateTime(this.areaDirectory.getNominalTime());
    }

    public DateTime getImageStartTime() throws VisADException {
        return new DateTime(this.areaDirectory.getStartTime());
    }

    public SingleBandedImage getImage() throws VisADException {
        SingleBandedImage firstBand;
        if (this.field.getRangeDimension() > 1) {
            try {
                firstBand = this.cs == null ? new SingleBandedImageImpl((FlatField)this.field.extract(0), this.getNominalTime(), "McIDAS Image", false) : new NavigatedImage((FlatField)this.field.extract(0), this.getNominalTime(), "McIDAS Image", false);
            }
            catch (RemoteException excp) {
                throw new VisADException("AreaAdapter.getImage(): RemoteException");
            }
        } else {
            firstBand = (SingleBandedImage)((Object)this.field);
        }
        return firstBand;
    }
}

