/***************************************************************************
 $RCSfile$
                             -------------------
    cvs         : $Id: handledupe.h 174 2005-03-29 20:52:45Z aquamaniac $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/

#ifndef AQBANKING_KDE_HANDLEDUPE_H
#define AQBANKING_KDE_HANDLEDUPE_H

class TransactionListView;
class Transaction;
class KBanking;

class HandleDupe;

#include "handledupe.ui.h"
#include "ktimport.h"


class HandleDupe: public HandleDupeUi {
  Q_OBJECT
public:
  HandleDupe(Account *a,
             RefPointer<Transaction> tnew,
             RefPointer<Transaction> told,
             const std::list<RefPointer<Transaction> > &dnl,
             const std::list<RefPointer<Transaction> > &dol,
             QWidget* parent=0,
             const char* name=0,
             bool modal=FALSE,
             WFlags fl=0);

  ~HandleDupe();

  TransactionImporter::DupeCheckResult getResult() const;

  static TransactionImporter::DupeCheckResult
    askUser(Account *a,
            RefPointer<Transaction> tnew,
            RefPointer<Transaction> told,
            const std::list<RefPointer<Transaction> > &dnl,
            const std::list<RefPointer<Transaction> > &dol,
            bool &askNoMore,
            QWidget* parent);

public slots:
  void accept();
  void reject();

  void slotHelp();
  void slotDiscardNew();
  void slotAddNew();
  void slotReplace();

private:
  KBanking *_app;
  Account *_account;
  RefPointer<Transaction> _tnew;
  RefPointer<Transaction> _told;
  const std::list<RefPointer<Transaction> > &_newList;
  const std::list<RefPointer<Transaction> > _oldList;
  TransactionListView *_transactionList;
  TransactionImporter::DupeCheckResult _result;
};




#endif // AQBANKING_KDE_HANDLEDUPE_H

