/***************************************************************************
 $RCSfile$
                             -------------------
    cvs         : $Id: transferview.cpp 330 2005-10-02 14:05:27Z cstim $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif


#include "transferview.h"
#include "edittransaction.h"
#include "editeutransaction.h"
#include "kbanking.h"


#ifdef WIN32
# define strcasecmp stricmp
#endif

#include <qevent.h>
#include <qpushbutton.h>
#include <qgroupbox.h>
#include <qmessagebox.h>
#include <qlayout.h>

#include <gwenhywfar/debug.h>



#define BUTTON_WIDTH 110


TransferView::TransferView(KBanking *app,
                           QWidget* parent,
                           const char* name,
                           WFlags fl)
:TransferViewUi(parent, name, fl), _app(app) {
  assert(app);

  // Manually create and add layout here because the .ui-generated
  // QGroupBox doesn't have one.
  transferBox->setColumnLayout(0, Qt::Vertical );
  QBoxLayout *transferBoxLayout = new QHBoxLayout( transferBox->layout() );
  transferBoxLayout->setAlignment( Qt::AlignTop );

  _xaList=new TransferListView(transferBox, name);
  transferBoxLayout->addWidget(_xaList);

  QObject::connect(app->flagStaff(),
                   SIGNAL(signalAccountsUpdated()),
                   this, SLOT(slotUpdated()));

  QObject::connect(app->flagStaff(),
                   SIGNAL(signalTransfersUpdated()),
                   this, SLOT(slotUpdated()));

  /*
  QObject::connect(app->flagStaff(),
                   SIGNAL(signalTransferFromTemplate(RefPointer<Transaction>,
                                                     QWidget*)),
                   this,
                   SLOT(slotTransferFromTemplate(RefPointer<Transaction>,
                                                 QWidget*)));
  QObject::connect(app->flagStaff(),
                   SIGNAL(signalEuTransferFromTemplate(RefPointer<Transaction>,
                                                       QWidget*)),
                   this,
                   SLOT(slotEuTransferFromTemplate(RefPointer<Transaction>,
                                                   QWidget*)));
  QObject::connect(app->flagStaff(),
                   SIGNAL(signalDebitNoteFromTemplate(RefPointer<Transaction>,
                                                      QWidget*)),
                   this,
                   SLOT(slotDebitNoteFromTemplate(RefPointer<Transaction>,
                                                  QWidget*)));
  */
  QObject::connect(detailsButton, SIGNAL(clicked()),
                   this, SLOT(slotDetails()));
  QObject::connect(newTransferButton, SIGNAL(clicked()),
                   this, SLOT(slotNewTransfer()));
  QObject::connect(newDebitNoteButton, SIGNAL(clicked()),
                   this, SLOT(slotNewDebitNote()));
  QObject::connect(newEuTransferButton, SIGNAL(clicked()),
                   this, SLOT(slotNewEuTransfer()));
  QObject::connect(repeatButton, SIGNAL(clicked()),
                   this, SLOT(slotRepeat()));
}



TransferView::~TransferView(){
}


bool TransferView::init(){
  GWEN_DB_NODE *db;
  std::string s;
  int i, j;

  db=_app->getAppData();
  if (db) {
    db=GWEN_DB_GetGroup(db, GWEN_PATH_FLAGS_NAMEMUSTEXIST,
                        "gui/views/transferview");
    if (db) {
      int w;
      int h;
      const char *p;

      /* found settings */
      p=GWEN_DB_GetCharValue(db, "sortOrder", 0, "ascending");
      if (p) {
        if (strcasecmp(p, "ascending")==0)
          _xaList->setSortOrder(Qt::Ascending);
        else
          if (strcasecmp(p, "descending")==0)
            _xaList->setSortOrder(Qt::Descending);
      }
      i=GWEN_DB_GetIntValue(db, "sortColumn", 0, -1);
      if (i!=-1)
        _xaList->setSortColumn(i);
      w=GWEN_DB_GetIntValue(db, "width", 0, 640);
      h=GWEN_DB_GetIntValue(db, "height", 0, 480);
      resize(w, h);
      for (i=0; i<_xaList->columns(); i++) {
        _xaList->setColumnWidthMode(i, QListView::Manual);
        j=GWEN_DB_GetIntValue(db, "columns", i, -1);
        if (j!=-1)
          _xaList->setColumnWidth(i, j);
      } /* for */
    } // if transaction view setting
  } // if application settings
  slotUpdated();

  return true;
}



bool TransferView::fini(){
  GWEN_DB_NODE *db;
  int i, j;
  std::string s;

  db=_app->getAppData();
  assert(db);
  db=GWEN_DB_GetGroup(db,
                      GWEN_DB_FLAGS_OVERWRITE_GROUPS,
                      "gui/views/transferview");
  assert(db);
  db=GWEN_DB_GetGroup(db, GWEN_DB_FLAGS_OVERWRITE_GROUPS,
                      s.c_str());
  assert(db);
  GWEN_DB_SetIntValue(db, GWEN_DB_FLAGS_DEFAULT,
                      "width", width());
  GWEN_DB_SetIntValue(db, GWEN_DB_FLAGS_DEFAULT,
                      "height", height());

  GWEN_DB_SetIntValue(db, GWEN_DB_FLAGS_DEFAULT,
                      "sortColumn", _xaList->sortColumn());
  switch(_xaList->sortOrder()) {
  case Qt::Ascending:
    GWEN_DB_SetCharValue(db, GWEN_DB_FLAGS_DEFAULT,
                         "sortOrder", "ascending");
    break;
  case Qt::Descending:
    GWEN_DB_SetCharValue(db, GWEN_DB_FLAGS_DEFAULT,
                         "sortOrder", "descending");
    break;
  default:
    break;
  }

  for (i=0; i<_xaList->columns(); i++) {
    j=_xaList->columnWidth(i);
    GWEN_DB_SetIntValue(db, GWEN_DB_FLAGS_DEFAULT,
                        "columns", j);
  } /* for */

  return true;
}



void TransferView::closeEvent(QCloseEvent *e){
  if (!fini()) {
    DBG_ERROR(0, "Could not deinit transaction view");
  }
  e->accept();
}



void TransferView::slotUpdated() {
  _xaList->clear();
  _xaList->addTransfers(_app->getTransfers());
}



void TransferView::slotDetails() {
}



void TransferView::slotRepeat(){
  RefPointer<Transfer> t;
  Transfer::TransferType tt;

  t=_xaList->getCurrentTransfer();
  if (!t.isValid()) {
    DBG_ERROR(0, "No current transfer");
    QMessageBox::critical(this,
			  tr("No Selection"),
			  tr("<qt>"
			     "Please select a transfer"
			     "</qt"),
			  tr("Dismiss"), QString::null, QString::null, 0, 0);
    return;
  }

  tt=t.ref().getTransferType();
  if (tt==Transfer::TransferType_Unknown) {
    switch(t.ref().getTextKey()) {
    case 4:
    case 5:
      tt=Transfer::TransferType_DebitNote;
      break;
    default:
      tt=Transfer::TransferType_Simple;
    }
  }

  switch(tt) {
  case Transfer::TransferType_Simple:
    _app->transferFromTemplate(t.cast<Transaction>(), this);
    break;
  case Transfer::TransferType_DebitNote:
    _app->debitNoteFromTemplate(t.cast<Transaction>(), this);
    break;
  case Transfer::TransferType_EuTransfer:
    _app->euTransferFromTemplate(t.cast<Transaction>(), this);
    break;
  default:
    DBG_ERROR(0, "Unknown transfer type %d", tt);
    QMessageBox::critical(this,
			  tr("Internal Error"),
			  tr("<qt>"
			     "Unknown Transfer Type"
			     "</qt"),
			  tr("Dismiss"), QString::null, QString::null, 0, 0);
    return;
  }
}



void TransferView::slotNewTransfer() {
  _app->transferFromTemplate(0, this);
}



void TransferView::slotNewDebitNote() {
  _app->debitNoteFromTemplate(0, this);
}



void TransferView::slotNewEuTransfer() {
  _app->euTransferFromTemplate(0, this);
}







