/*
*  Rubrica
*  file: dialoghi.h
*  
*  Copyright (C) 2000-2001 Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/


#ifndef _RUBRICA_DIALOGHI_H
#define _RUBRICA_DIALOGHI_H

#include "rubrica_type.h"


GtkWidget* rubrica_dialog_create(GtkWidget *parent, gchar *title, gchar *str,
				 gchar *pixmap);
GtkWidget* rubrica_dialog_with_href_create(GtkWidget *parent, gchar *title,
					   gchar *str, gchar *pixmap, 
					   gchar *uri, gchar *uri_str);

void rubrica_dialog_message(gchar *str, GtkMessageType message, 
			    GtkButtonsType button);
void rubrica_dialog_simple_message(gchar *str);

void rubrica_dialog_error(gchar *str);

GtkWidget *rubrica_dialog_query(gchar *str, GtkButtonsType buttons);

void rubrica_dialog_info (void);

void rubrica_dialog_notify_bugs (void);
void rubrica_dialog_will_do (void);
void rubrica_dialog_developing(void);
void rubrica_dialog_goto_homepage (void);
void rubrica_dialog_translation_rules (void);


void rubrica_dialog_error_loading_file(gchar *file, RubricaErrorType err);

void rubrica_dialog_error_in_preferences_key(gchar *str);
void rubrica_dialog_error_loading_preferences_keys(void);

#endif 
