/*
*  Rubrica
*  file: search.h
*  
*  Copyright (C) 2000-2003 Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <gtk/gtk.h>
#include "rubrica.h"

#ifndef __RUBRICA_SEARCH_H
#define __RUBRICA_SEARCH_H

enum 
  {
    SEARCH_RESULT_CARD,
    SEARCH_RESULT_FOUND,
    SEARCH_RESULT_PATH,
    SEARCH_RESULT_COLUMNS
  };


typedef struct _search_data RubricaSearchData;

struct _search_data 
{
  gchar *str;
  gint column;
  GtkTreeModel *model;
};

void rubrica_search_perform_search(GtkWidget *search_dialog);
void rubrica_search_find_data(GtkWidget *dialog, GtkWidget *data_view,
			      GtkWidget* search_view, RubricaSearchData *data);

gboolean rubrica_search_get_search_case_sensitive(GtkWidget *dialog);
gboolean rubrica_search_get_search_mode_incomplete(GtkWidget *dialog);
RubricaSearchType rubrica_search_get_search_type(void);

void rubrica_search_set_search_case_sensitive(gboolean bool);
void rubrica_search_set_search_mode_incomplete(gboolean bool);
void rubrica_search_set_search_type(RubricaSearchType type);

gboolean 
rubrica_search_case_sensitive_complete(GtkTreeModel *model, GtkTreePath *path,
				       GtkTreeIter *iter, gpointer data);
gboolean 
rubrica_search_case_insensitive_complete(GtkTreeModel *model,
					 GtkTreePath *path,
					 GtkTreeIter *iter, gpointer data);
gboolean 
rubrica_search_case_sensitive_incomplete(GtkTreeModel *model, 
					 GtkTreePath *path,
					 GtkTreeIter *iter, gpointer data);
gboolean 
rubrica_search_case_insensitive_incomplete(GtkTreeModel *model, 
					   GtkTreePath *path,
					   GtkTreeIter *iter, gpointer data);

#endif
