/* ====================================================================
 * Copyright (c) 2008-2009  Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _WCVIEWTREEITEMMODEL_TEST_H
#define _WCVIEWTREEITEMMODEL_TEST_H

// cppunit
#include <cppunit/TestFixture.h>
#include <cppunit/extensions/HelperMacros.h>

// sc
#include "subcommander/WcViewItem.h"
#include "util/String.h"
class WcViewTreeItemModel;

// qt
#include <QtCore/QObject>
#include <QtCore/QModelIndex>


struct DataChanged
{
  QModelIndex topLeft;
  QModelIndex botRight;
};

struct RowsInserted
{
  QModelIndex parent;
  int         start;
  int         end;
};

class WcViewTreeItemModelTest : public QObject, public CppUnit::TestCase 
{
  Q_OBJECT;

  CPPUNIT_TEST_SUITE( WcViewTreeItemModelTest );
  CPPUNIT_TEST( add );
  CPPUNIT_TEST_SUITE_END(); 

public:
  void setUp();
  void tearDown();

  // Tests
  void add();

public slots:
  void dataChanged( const QModelIndex&, const QModelIndex& );
  void rowsAboutToBeInserted( const QModelIndex&, int start, int end );
  void rowsInserted( const QModelIndex&, int start, int end );

private:
  WcViewTreeItemModel* _model;
  WcViewItems          _items[10];
  DataChanged          _dataChanged[10];
  RowsInserted         _rowsInserted[10];
};

#endif // _WCVIEWTREEITEMMODEL_TEST_H
