/*
 * chrome://tabmixplus/content/links/userInterface.js
 *
 * original code by Bradley Chapman
 * modified and developped by Hemiola SUN
 * modified again by Bradley Chapman
 *
 * modified again and again... by onemen
 *
 */

if (!("gTabmixPrefs" in window)) {
  __defineGetter__("gTabmixPrefs", function() {
    delete this.gTabmixPrefs;
    return this.gTabmixPrefs =  Components.classes["@mozilla.org/preferences-service;1"]
             .getService(Components.interfaces.nsIPrefService)
             .QueryInterface(Components.interfaces.nsIPrefBranch2);
  });
}

if (!("gWindowManager" in window)) {
  __defineGetter__("gWindowManager", function() {
    delete this.gWindowManager;
    return this.gWindowManager = Components.classes["@mozilla.org/appshell/window-mediator;1"].
                               getService(Components.interfaces.nsIWindowMediator);
  });
}

/**
 * @brief Catch call to tabmix options from EM
 *        we only use Tabmix options if we have browser window
 *
 * @param aURL       A valid options URL string.
 *
 * @return           true if the URL is for tabmix options
 *                   false if not.
 *
 */
function TMP_cmd_options(aURL) {
   if (aURL != "chrome://tabmixplus/content/pref/pref-tabmix.xul")
      return false;

   var browserWindow = gWindowManager.getMostRecentWindow("navigator:browser");

   if (!browserWindow) {
      var tabmixopt = gWindowManager.getMostRecentWindow("mozilla:tabmixopt");
      if (tabmixopt)
         tabmixopt.close();

      var promptService = Components.classes["@mozilla.org/embedcomp/prompt-service;1"]
                                    .getService(Components.interfaces.nsIPromptService);
      var stringBundle = Components.classes["@mozilla.org/intl/stringbundle;1"]
               .getService(Components.interfaces.nsIStringBundleService)
               .createBundle("chrome://tabmixplus/locale/tabmix.properties");
      var title = stringBundle.GetStringFromName("tabmixoption.error.title");
      var msg = stringBundle.GetStringFromName("tabmixoption.error.msg");
      promptService.alert(window, title, msg);
   }
   else
      browserWindow.TMP_openDialog(-1);

   return true;
}

function TMP_openDialog(panel) {
  var tabmixOptionsWin = gWindowManager.getMostRecentWindow("mozilla:tabmixopt");
  if (tabmixOptionsWin) {
    var appearanceWin = gWindowManager.getMostRecentWindow("mozilla:tabmixopt-appearance");
    var filetypeWin = gWindowManager.getMostRecentWindow("mozilla:tabmixopt-filetype");
    var promptWin = gWindowManager.getMostRecentWindow("mozilla:tabmixprompt");

    if (panel > -1 && !appearanceWin && !filetypeWin && !promptWin)
      tabmixOptionsWin.TM_selectTab(panel);

    tabmixOptionsWin.gIncompatiblePane.checkForIncompatible(false);

    (appearanceWin || filetypeWin || promptWin || tabmixOptionsWin).focus();
  }
  else {
    if(panel > -1)
      gTabmixPrefs.setIntPref('extensions.tabmix.selected_tab', panel);

    window.openDialog("chrome://tabmixplus/content/pref/pref-tabmix.xul", "Tab Mix Plus", "chrome,titlebar,toolbar,close,dialog=no");
  }
}

/**
 * @brief Load URLs from the Extension/Theme Managers, and item with text-link class
 *
 * This redefines chrome://mozapps/content/extensions/extensions.js:openURL()
 *
 * @param aURL       A valid URI string.
 * @param event      A valid event union. This can be null when
 *                   calling this function.
 * @return           true.
 *
 */
function TMP_openURL(aURL, event) {
   var linkTarget, loadInBackground;
   try {
            linkTarget = gTabmixPrefs.getIntPref("browser.link.open_newwindow");
   }
   catch (e) {
      linkTarget = 1;
   }

   if (aURL == null) aURL = "about:blank";

   // check for an existing window and focus it; it's not application modal
   var browserWindow = gWindowManager.getMostRecentWindow("navigator:browser");

   if (!browserWindow) {
      openDialog("chrome://browser/content/browser.xul", "_blank", "chrome,all,dialog=no", aURL, null, null, null);
      if (event && event instanceof Event) {
         event.preventDefault();
         event.stopPropagation();
      }
      return true;
   }

   var tabBrowser = browserWindow.gBrowser;
   var originCharset = tabBrowser.contentDocument.characterSet;

   // if the current tab is empty, then do not open a new tab
   if (tabBrowser.currentURI.spec == "about:blank") {
      // 1: CURRENT_TAB
      linkTarget = 1;
      originCharset = null;
   }

      switch (linkTarget) {
         case 1 :
            tabBrowser.loadURI(aURL, null, originCharset);
            break;
         case 2 :
            browserWindow.openNewWindowWith(aURL, null, null, false);
            break;
         case 3 :
            // added by request, for extensions with multiple homepages
            browserWindow.TMP_loadTabs(aURL.split("|"), false);
            break;
      }

   if (event && event instanceof Event) {
      event.preventDefault();
      event.stopPropagation();
   }
   return true;
}

function TMP_BrowserOpenTab(aTab, replaceLastTab) {
   var newTabContent = replaceLastTab ? tabxPrefs.getIntPref("replaceLastTabWith") :
                                         tabxPrefs.getIntPref("loadOnNewTab");
   var url;
   switch (newTabContent) {
      case 0 : // blank tab, by default
         url = "about:blank";
         break;
      case 1 :  // home page
         url = gHomeButton.getHomePage().split("|")[0];
         break;
      case 2 : // current URI
         var currentURI = gBrowser.currentURI;
         url = currentURI ? currentURI.spec : "about:blank";
         break;
      case 3 : // duplicate tab
         gBrowser.duplicateTab(gBrowser.mCurrentTab);
         return;
      case 4 : // user url
         try {
            var prefName = replaceLastTab ? "newTabUrl_afterLastTab" : "newTabUrl";
            url = tabxPrefs.getComplexValue(prefName, Components.interfaces.nsIPrefLocalizedString).data;
         } catch (ex) {  TMP_ASSERT(ex); }
         // use this if we can't find the pref
         if (!url)
            url = "about:blank";
         break;
      default:
         url = "about:blank";
   }
   var flags = nsIWebNavigation.LOAD_FLAGS_NONE;
   // if google.toolbar extension installed check google.toolbar.newtab pref
   if ("GTB_GoogleToolbarOverlay" in window) {
     try {
       if (gTabmixPrefs.getBoolPref("google.toolbar.newtab")) {
         url = "chrome://google-toolbar/content/new-tab.html";
         flags = nsIWebNavigation.LOAD_FLAGS_BYPASS_HISTORY
       }
     } catch (ex) {/* no pref - do noting */}
   }
   var loadBlank = url == "about:blank";
   var newTab = gBrowser.addTab("about:blank");
   // fix for a bug in Firefox when we replace last tab the stip remain visible even if the pref is to hide tabbar
   // when there is only one tab
   if (replaceLastTab && gTabmixPrefs.getBoolPref("browser.tabs.autoHide") && gBrowser.getStripVisibility())
     gBrowser.setStripVisibilityTo(false);

   if (!loadBlank) {
      try { // just in case.....
         newTab.linkedBrowser.stop();
         var originCharset = gBrowser.contentDocument.characterSet;
         gBrowser.getBrowserForTab(newTab).loadURIWithFlags(url, flags, null, originCharset);
         content.focus();
      }
      catch (ex) {}
   }
   if (aTab && aTab.localName == "tab")
      gBrowser.TMmoveTabTo(newTab, aTab._tPos + 1);
   else if (!replaceLastTab && tabxPrefs.getBoolPref("openNewTabNext")) {
      gBrowser.TMmoveTabTo(newTab, gBrowser.mCurrentTab._tPos + gBrowser.tabContainer.nextTab, 1);
      if (tabxPrefs.getBoolPref("openTabNextInverse"))
         gBrowser.tabContainer.nextTab++;
   }

   // always focus the address bar on new tab
   // always select new tab when replacing last tab
   var loadInBackground  = replaceLastTab ? false : tabxPrefs.getBoolPref("loadNewInBackground");
   gBrowser.TMP_selectNewForegroundTab(newTab, loadInBackground , "about:blank");
   if (!/www\.google/.test(url)) {
     // clean the the address bar as if the user laod about:blank tab
     gBrowser.tabmix_tab = newTab;
     gBrowser.tabmix_userTypedValue = url;
     gBrowser.userTypedValue = "";
   }
}

/* In TMP_BrowserOpenTab we empty and fucos the urlbar
 * if the user or onload from a page blur the urlbar befroe user typed new valur
 * we restore the current url
 */
function TMP_urlBarOnBlur() {
  if (!gBrowser.tabmix_tab)
    return;

  var isCurrentTab = gBrowser.tabmix_tab == gBrowser.mCurrentTab;
  var browser = gBrowser.getBrowserForTab(gBrowser.tabmix_tab);
  var url = gBrowser.tabmix_userTypedValue;
  if (url != "about:blank")
    browser.userTypedValue = url;
  if (isCurrentTab && gBrowser.mIsBusy) {
    browser.addEventListener("load", function(aEvent) {
      aEvent.currentTarget.removeEventListener("load", arguments.callee, true);
      TMP_updateUrlBarValue();
    }, true);
    return;
  }

  TMP_updateUrlBarValue()
}

function TMP_updateUrlBarValue() {
  var url = gBrowser.currentURI.spec;
  if (url != gURLBar.value && url != "about:blank") {
    gURLBar.value = gBrowser.userTypedValue = url;
  }
  delete gBrowser.tabmix_tab;
  delete gBrowser.tabmix_userTypedValue;
}

/**
 * @brief Load URLs from the URL bar.
 *
 * @param event         A valid event union.
 * @param aPostData     Additional opaque data used by __TMP_LoadBarURL().
 * @param altDisabled   parameter set by URL Suffix extension, to prevent ALT from opening new tab
 * @return              Nothing.
 *
 */
function TMP_BrowserLoadURL(theEvent, aPostData, altDisabled, aUrl) {
  var newTabPref = TMP_getBoolPref(tabxBranch, "opentabfor.urlbar", false);
  var theBGPref  = TMP_getBoolPref(tabxBranch, "loadUrlInBackground", false);
  var theURI = aUrl || gURLBar.value;
  if ("gIeTab" in window)
     theURI = gIeTab.getHandledURL(theURI, gURLBar.isModeIE);

  var middleClick = theEvent instanceof MouseEvent && (theEvent.button == 1 || theEvent.ctrlKey || theEvent.metaKey);
  if (aUrl || middleClick) { // aUrl is not null when we call this function from PopupAutoCompleteRichResult.onPopupClick
    var where = whereToOpenLink(theEvent);
    if (where == "tabshifted") {
      theBGPref  = !theBGPref;
      newTabPref = true;
    }
    else {
      openUILinkIn(theURI, where, true /* allow third party fixup */, aPostData);
      return;
    }
  }
  var isAltKey = !altDisabled && (theEvent instanceof Event && ('altKey' in theEvent && theEvent.altKey));
  newTabPref = TMP_whereToOpen(newTabPref, isAltKey).inNew;

  __TMP_LoadBarURL(theURI, theEvent, newTabPref, theBGPref, aPostData, true);
}

/**
 * @brief Load URLs from the URL bar, search bar and search dialog.
 *
 * This function is used directly by Tab Mix Plus.
 *
 * @param aURI                    The URI to be opened.
 * @param aEvent                  A valid event union
 * @param aNewTabPref             A Boolean preference - if true, the URL will be
 *                                opened in a new tab; if false, it will load in
 *                                the current tab.
 * @param aLoadInBackground       A Boolean preference - if false, the newly created tab will be focused;
 *                                if true, the newly created tab will be unfocused.
 * @param aPostData               Additional opaque data used by tabbrowser methods
 * @param aAllowThirdPartyFixup   Allow third-party services to fixup this URL
 * @returns                       Nothing.
 *
 */
function __TMP_LoadBarURL(aURI, aEvent, aNewTabPref, aLoadInBackground, aPostData, aAllowThirdPartyFixup) {
  var originCharset = null;

  if (gBrowser.localName != "tabbrowser") {
    loadURI(aURI, null, aPostData, aAllowThirdPartyFixup);
    content.focus();
    return;
  }
  else {
    var currentURI = gBrowser.currentURI;
    var url = currentURI ? currentURI.spec : "about:blank";
    originCharset = url != "about:blank" ? gBrowser.contentDocument.characterSet : null;
  }

  if (aNewTabPref) {
    if (gIsFirefox35) {
      if (gURLBar)
        gURLBar.handleRevert();
    }
    else
      handleURLBarRevert();
    content.focus();
    try {
      // open new tab in 2 step, this prevent focus problem with forms field
      var newTab = gBrowser.addTab("about:blank");
      newTab.linkedBrowser.stop();
      var flags = nsIWebNavigation.LOAD_FLAGS_NONE;
      if (aAllowThirdPartyFixup) {
        flags = nsIWebNavigation.LOAD_FLAGS_ALLOW_THIRD_PARTY_FIXUP;
      }
      var browser = gBrowser.getBrowserForTab(newTab);
      browser.userTypedValue = aURI;
      browser.loadURIWithFlags(aURI, flags, null, originCharset, aPostData);
    } catch (e) {  }
    gBrowser.TMP_selectNewForegroundTab(newTab, aLoadInBackground);
  }
  // not opening in a new tab at all
  else
    loadURI(aURI, null, aPostData, aAllowThirdPartyFixup);

  if (gIsFirefox36)
    gBrowser.selectedBrowser.focus();
  else
    focusElement(content);

  if (aEvent instanceof Event) {
    aEvent.preventDefault();
    aEvent.stopPropagation();
  }
  return;
}

// openUILink handles clicks on UI elements that cause URLs to load.
function TMP_openUILink( url, e, ignoreButton, ignoreAlt, allowKeywordFixup, postData, referrerUrl) {
  var where = whereToOpenLink(e, ignoreButton, ignoreAlt);
  var win = getTopWin();
  if (win) {
    // don't open blanke tab when we are about to add new livemark
    var _addLivemark = /^feed:/.test(url) && gTabmixPrefs.getCharPref("browser.feeds.handler") == "bookmarks";
    if (where == "current" && !_addLivemark)
      where = win.TMP_checkCurrent(url);
  }
  try {
    openUILinkIn(url, where, allowKeywordFixup, postData, referrerUrl);
  }
  catch (ex) {   }
}

function TMP_checkCurrent(url) {
  if (gBrowser.mCurrentTab.hasAttribute("locked")) {
    var isBlankTab = gBrowser.isBlankNotBusyTab(gBrowser.mCurrentTab);
    if (!isBlankTab)
       return "tab";
  }
  else if (gTabmixPrefs.getIntPref("extensions.tabmix.speLink") == 2 ) {
    // Get current page url
    var curpage = gBrowser.currentURI.spec;
    var domain = checkDomain(curpage, url);
    if (domain.current && domain.target && domain.target != domain.current)
      return "tab";
  }
  return "current";
}
