#! /bin/sh
# Run this to generate all the initial makefiles, etc.
# Set CONFIG_ARGS to the argument list you wish to pass to configure

set -e

# Run in most basic of locales to avoid performance overhead (and risk of bugs)
# involved in localization, encoding issues etc.  We only do ASCII here.
export LC_ALL=C

ver=""
for amv in "1.6" "1.7" "1.8" "1.9" ; do
	if which "automake-$amv" >/dev/null 2>&1; then
		ver="-$amv"
	fi
done

autoheader

libtoolize --force --automake --copy
aclocal${ver} -I .
automake${ver} --verbose --add-missing --copy
autoconf

conf_flags="--enable-maintainer-mode $CONFIG_ARGS"
if test -z "$NOCONFIGURE" ; then
	echo Running $srcdir/configure $conf_flags "$@" ...
	./configure $conf_flags "$@" \
	&& echo Now type \`make\' to compile $PKG_NAME || exit 1
else
	echo Skipping configure process.
fi
