#ifndef EVENT_FUNCTORS_H
#define EVENT_FUNCTORS_H

// Copyright (c) 2003 Clifton Labs, Inc.  All rights reserved.

// CLIFTON LABS MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE
// SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT
// NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  CLIFTON LABS SHALL NOT BE
// LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, RESULT
// OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.

// Authors: Dale E. Martin              dmartin@cliftonlabs.com
#include <functional>
#include "Event.h"

/**
   Functor.  Compares two events to see if one has a receive time less than
   the other.
*/
struct receiveTimeLessThan : public std::binary_function<const Event *, 
	    const Event *, bool > {
  bool operator()( const Event *a, const Event *b ){
    return a->getReceiveTime() < b->getReceiveTime();
  }
};

/**
   Functor.  Compares two events to see if one has a receive time greater
   than or equal to the other.
*/
class receiveTimeGreaterThanEqual : 
  public std::unary_function<const Event *, bool > {
public:
  receiveTimeGreaterThanEqual( const VTime &initCompareTime ) : 
    compareTime( initCompareTime ){}
  bool operator()( const Event *a ){
    return a->getReceiveTime() >= compareTime;
  }
private:
  const VTime &compareTime;
};

/**
   Functor.  Compares two events to see if one has a send time greater
   than or equal to the other.
*/
class sendTimeGreaterThanEqual : 
  public std::unary_function<const Event *, bool > {
public:
  sendTimeGreaterThanEqual( const VTime &initCompareTime ) : 
    compareTime( initCompareTime ){}
  bool operator()( const Event *a ){
    return a->getSendTime() >= compareTime;
  }
private:
  const VTime &compareTime;
};

/**
   Functor.  Compares two events to see if one has a send time less
   than or equal to the other.
*/
class sendTimeLessThanEqual : 
  public std::unary_function<const Event *, bool > {
public:
  sendTimeLessThanEqual( const VTime &initCompareTime ) : 
    compareTime( initCompareTime ){}
  bool operator()( const Event *a ){
    return a->getSendTime() <= compareTime;
  }
private:
  const VTime &compareTime;
};


/**
   Functor.  Compares two events to see if one has a receive time less than
   or equal to the other.
*/
class receiveTimeLessThanEqual : 
  public std::unary_function<const Event *, bool > {
public:
  receiveTimeLessThanEqual( const VTime &initCompareTime ) : 
    compareTime( initCompareTime ){}
  bool operator()( const Event *a ){
    return a->getReceiveTime() <= compareTime;
  }
private:
  const VTime &compareTime;
};


#endif
