#ifndef SIMULATION_STREAM_H
#define SIMULATION_STREAM_H

// Copyright (c) The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.

// Authors: Malolan Chetlur             mal@ececs.uc.edu
//          Jorgen Dahl                 dahlj@ececs.uc.edu
//          Dale E. Martin              dmartin@cliftonlabs.com
//          Radharamanan Radhakrishnan  ramanan@ececs.uc.edu
//          Dhananjai Madhava Rao       dmadhava@ececs.uc.edu
//          Philip A. Wilsey            phil.wilsey@uc.edu

#include "warped.h"
#include <iostream>
#include <fstream>

using std::fstream;

class SimulationStream : public fstream {
public:

   /**@name Public Class Methods of SimulationStream. */
   //@{

   /// Default destructor
   virtual ~SimulationStream(){}

   /// virtual method that does the actual job of "endl".
   virtual void flush() = 0;
   
   //@} // End of Public Class Methods of SimulationStream.

protected:
   
   /**@name Public Class Methods of SimulationStream. */
   //@{

   SimulationStream(){}
   
   //@} // End of Public Class Methods of SimulationStream.
};

extern ostream& nl(ostream& os);

#endif
