#ifndef VISUALIZATION_CLIENT_H
#define VISUALIZATION_CLIENT_H


// Copyright (c) The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.

// Authors: 
//          
//          Philip A. Wilsey            phil.wilsey@uc.edu

#include <iostream>
#include <cstdlib>
#include <pthread.h>
#include <string>
#include <warped/Socket.h>

using std::cout;
using std::cerr;
using std::endl;

/** The VisualizationClient class.

    This class connects to the Visualization Server which runs a 
    a specified host and a specified port.

*/
class VisualizationClient {
 public:

  /**@name Public Class Methods of VisualizationClient. */
  //@{

  /** Default constructor.

      @param hostname
      @param port
   */
  VisualizationClient(const char *hostname, int port);

  /**
   * Destructor
   */
  ~VisualizationClient();

  /** Connects this client to a server
  */
  int clientConnect(void);

  /** Close connection
   */
  int clientClose(void);


protected:


private:
  const char *hostname;
  int port;
  //  Socket visSocket;
  //void* readIn(void*);

};

void* readIn(void*);
void* writeOut(void*);

#endif






