/*
 * EventOut.cpp
 *
 * Copyright (C) 1999 Stephen F. White
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include "stdafx.h"

#include "EventOut.h"
#include "Scene.h"
#include "FieldValue.h"
#include "DuneApp.h"

EventOut::EventOut(int type, const MyString &name, int flags,
                   ExposedField *exposedField)
{
    _type = type;
    _name = name;
    _flags = flags;
    _exposedField = exposedField;
}

EventOut::~EventOut()
{
}

int EventOut::write(int f, int indent) const
{
    if (_exposedField) return(0);

    RET_ONERROR( indentf(f, indent) )
    RET_ONERROR( mywritestr(f, "eventOut ") )
    RET_ONERROR( mywritestr(f, typeEnumToString(_type)) )
    RET_ONERROR( mywritestr(f, " ") )
    RET_ONERROR( mywritestr(f, (const char *) _name) )
    RET_ONERROR( mywritestr(f, "\n") )
    TheApp->incSelectionLinenumber();
    return(0);
}
