/*
 * NodeElevationGrid.h
 *
 * Copyright (C) 1999 Stephen F. White
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#ifndef _NODE_ELEVATIONGRID_H
#define _NODE_ELEVATIONGRID_H

#ifndef _MESH_BASED_NODE_H
#include "MeshBasedNode.h"
#endif
#ifndef _PROTO_MACROS_H
#include "ProtoMacros.h"
#endif
#ifndef _PROTO_H
#include "Proto.h"
#endif

#include "SFMFTypes.h"

class ProtoElevationGrid : public Proto {
public:
		    ProtoElevationGrid(Scene *scene);
    virtual Node   *create(Scene *scene);

    FieldIndex color;
    FieldIndex normal;
    FieldIndex texCoord;
    FieldIndex height;
    FieldIndex ccw;
    FieldIndex colorPerVertex;
    FieldIndex creaseAngle;
    FieldIndex normalPerVertex;
    FieldIndex solid;
    FieldIndex xDimension;
    FieldIndex xSpacing;
    FieldIndex zDimension;
    FieldIndex zSpacing;
};

class Mesh;

class NodeElevationGrid : public MeshBasedNode {
public:
		    NodeElevationGrid(Scene *scene, Proto *proto);

protected:
    virtual	   ~NodeElevationGrid();

public:
    virtual int	    getType() const { return NODE_ELEVATION_GRID; }
    virtual Node   *copy() const { return new NodeElevationGrid(*this); }
    virtual int	    getNodeClass() const { return GEOMETRY_NODE; }

    virtual void    setField(int index, FieldValue *value);

    virtual Vec3f   getHandle(int handle, int *constraint, int *field);
    virtual void    setHandle(int handle, const Vec3f &v);

    virtual void    drawHandles();

    fieldMacros(SFNode,  color,           ProtoElevationGrid)
    fieldMacros(SFNode,  normal,          ProtoElevationGrid)
    fieldMacros(SFNode,  texCoord,        ProtoElevationGrid)
    fieldMacros(MFFloat, height,          ProtoElevationGrid)
    fieldMacros(SFBool,  ccw,             ProtoElevationGrid)
    fieldMacros(SFBool,  colorPerVertex,  ProtoElevationGrid)
    fieldMacros(SFFloat, creaseAngle,     ProtoElevationGrid)
    fieldMacros(SFBool,  normalPerVertex, ProtoElevationGrid)
    fieldMacros(SFBool,  solid,           ProtoElevationGrid)
    fieldMacros(SFInt32, xDimension,      ProtoElevationGrid)
    fieldMacros(SFFloat, xSpacing,        ProtoElevationGrid)
    fieldMacros(SFInt32, zDimension,      ProtoElevationGrid)
    fieldMacros(SFFloat, zSpacing,        ProtoElevationGrid)

protected:
    void	    createMesh();
};

#endif // _NODE_ELEVATIONGRID_H
