/*
 * NodeLOD.h
 *
 * Copyright (C) 1999 Stephen F. White
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#ifndef _NODE_LOD_H
#define _NODE_LOD_H

#ifndef _NODE_H
#include "Node.h"
#endif
#ifndef _PROTO_MACROS_H
#include "ProtoMacros.h"
#endif
#ifndef _PROTO_H
#include "Proto.h"
#endif

#include "SFMFTypes.h"

class ProtoLOD : public Proto {
public:
		    ProtoLOD(Scene *scene);
    virtual Node   *create(Scene *scene);

    FieldIndex level;
    FieldIndex center;
    FieldIndex range;
};

class NodeLOD : public Node {
public:
		    NodeLOD(Scene *scene, Proto *proto);

    virtual int	    getType() const { return NODE_LOD; }
    virtual Node   *copy() const { return new NodeLOD(*this); }

    virtual int     countPolygons(void);
    virtual int     countPrimitives(void);

    virtual void    flip(int index);

    virtual void    preDraw();
    virtual void    draw();

    void accountNodeToDrawIndex();

    fieldMacros(MFNode,  level,  ProtoLOD)
    fieldMacros(SFVec3f, center, ProtoLOD)
    fieldMacros(MFFloat, range,  ProtoLOD)

protected:
    int _nodeToDrawIndex;
};

#endif // _NODE_LOD_H
