/*
 * NodeNurbsCurve2D.h
 *
 * Copyright (C) 2003 Th. Rothermel
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#ifndef _NODE_NURBS_CURVE_2D_H
#define _NODE_NURBS_CURVE_2D_H

#ifndef _NODE_H
#include "Node.h"
#endif
#ifndef _PROTO_MACROS_H
#include "ProtoMacros.h"
#endif
#ifndef _PROTO_H
#include "Proto.h"
#endif
#ifndef _VEC2F_H
#include "Vec2f.h"
#endif
#ifndef _SFMFTYPES_H
#include "SFMFTypes.h"
#endif

#define MFDouble MFFloat
#define MFDOUBLE MFFLOAT

class ProtoNurbsCurve2D : public Proto {
public:
		    ProtoNurbsCurve2D(Scene *scene);
    virtual Node   *create(Scene *scene);

    FieldIndex controlPoint;
    FieldIndex tessellation;
    FieldIndex weight;
    FieldIndex knot;
    FieldIndex order;
};

class NodeNurbsCurve2D : public Node {
public:
		    NodeNurbsCurve2D(Scene *scene, Proto *proto);

    virtual int	    getType() const { return NODE_NURBS_CURVE_2D; }
    virtual Node   *copy() const { return new NodeNurbsCurve2D(*this); }
    virtual int	    getNodeClass() const { return NURBS_CONTROL_CURVE_NODE; }

    virtual void    setField(int index, FieldValue *value);

    bool    	    writeEXTERNPROTO(int filedes);
    int		    write(int filedes, int indent);

    virtual void    flip(int index);

    void            update(void) { _chainDirty = true; }
    void            reInit(void) { _chain.resize(0); _chainDirty = true; }

    fieldMacros(MFVec2f,   controlPoint,  ProtoNurbsCurve2D)
    fieldMacros(SFInt32,   tessellation,  ProtoNurbsCurve2D)
    fieldMacros(MFDouble,  weight,        ProtoNurbsCurve2D)
    fieldMacros(MFDouble,  knot,          ProtoNurbsCurve2D)
    fieldMacros(SFInt32,   order,         ProtoNurbsCurve2D)

private:
    int             _dimension;
    Array<Vec2f>    _chain;
    bool	    _chainDirty;
};





#endif // _NODE_NURBS_CURVE_H
