/*
 * NodePixelTexture.cpp
 *
 * Copyright (C) 1999 Stephen F. White
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include "stdafx.h"

#include "NodePixelTexture.h"
#include "Proto.h"
#include "FieldValue.h"
#include "SFImage.h"
#include "SFBool.h"


ProtoPixelTexture::ProtoPixelTexture(Scene *scene)
  : Proto(scene, "PixelTexture")
{
    image.set(
          addExposedField(SFIMAGE, "image", new SFImage(0, 0, 0, NULL)));
    repeatS.set(
          addField(SFBOOL, "repeatS", new SFBool(true)));
    repeatT.set(
          addField(SFBOOL, "repeatT", new SFBool(true)));
}

Node *
ProtoPixelTexture::create(Scene *scene)
{ 
    return new NodePixelTexture(scene, this); 
}

NodePixelTexture::NodePixelTexture(Scene *scene, Proto *def)
  : Node(scene, def)
{
}

