/*
 * SFBool.cpp
 *
 * Copyright (C) 1999 Stephen F. White
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include "stdafx.h"
#include "DuneApp.h"

#include "SFBool.h"

SFBool::SFBool(bool value)
{
    _value = value;
}

bool
SFBool::equals(const FieldValue *value) const
{
    return value->getType() == SFBOOL 
        && ((SFBool *) value)->getValue() == _value;
}

int SFBool::write(int f, int /* indent */) const
{
    RET_ONERROR( mywritestr(f, _value ? "TRUE\n" : "FALSE\n") );
    TheApp->incSelectionLinenumber();
    return 0;
}

/* not implemented yet
int SFBool::writeCC(int f, char* variableName) const
{
    RET_ONERROR( mywritestr(f, "bool sfBool_") );
    RET_ONERROR( mywritestr(f, variableName) );
    RET_ONERROR( mywritestr(f, " = ") );
    RET_ONERROR( mywritestr(f, _value ? "true" : "false") );
    RET_ONERROR( mywritestr(f, ";\n") );
    RET_ONERROR( mywritestr(f, "SFBool sfBool_") );
    RET_ONERROR( mywritestr(f, variableName) );
    RET_ONERROR( mywritestr(f, " = new SFBool(sfBool_") );
    RET_ONERROR( mywritestr(f, variableName) );
    RET_ONERROR( mywritestr(f, ");\n") ); 
    return 0;
}
*/

MyString
SFBool::getEcmaScriptComment(MyString name, int flags) const
{    
    const char *indent = ((FieldValue *)this)->getEcmaScriptIndent(flags);
    MyString ret;
    ret = "";
    if (TheApp->GetEcmaScriptAddAllowedValues()) {
        ret += indent;
        ret += "// allowed values:\n";

        ret += indent;
        ret += "   // true false\n";
    }
    if (TheApp->GetEcmaScriptAddExampleUsage()) {
        ret += indent;
        ret += "// example usage:\n";
        if (flags != EL_EVENT_IN) {
            ret += indent;
            ret += "   // ";
            ret += name;
            ret += " = true;\n";
        }
        if (flags != EL_EVENT_OUT) {
            ret += indent;
            ret += "   // if (";
            ret += name;
            ret += ")\n";

            ret += indent;
            ret += "   //    {\n";

            ret += indent;
            ret += "   //    }\n";
        }
        if (flags == EL_FIELD_DEF) {
             ret += indent;
             ret += "   // ";
             ret += name;
             ret += " = !";
             ret += name;
             ret += "; // logical NOT operation\n";
        } 
    }
    return ret;
}
