/*
 * SFVec2f.h
 *
 * Copyright (C) 1999 Stephen F. White
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#ifndef _SFVEC2F_H
#define _SFVEC2F_H

#ifndef _FIELDVALUE_H
#include "FieldValue.h"
#endif

class SFVec2f : public FieldValue {
public:
			SFVec2f(float x, float y);
			SFVec2f(const float *values);
			SFVec2f(void); // silly default

    virtual int         getType() const { return SFVEC2F; }
    virtual const char *getTypeName() const { return "SFVec2f"; }
    virtual int	        write(int filedes, int indent) const;
//    virtual int		writeCC(int filedes, char* variableName) const;
    virtual bool	equals(const FieldValue *value) const;
    virtual FieldValue *copy() { return new SFVec2f(*this); }

    float		getValue(int index) const { return _value[index]; }
    const float	       *getValue() const { return _value; }
    void		setValue(int pos, float value)
			{ _value[pos] = value; }
    void		setValue(float v1, float v2);

    MyString	        getEcmaScriptComment(MyString name, int flags) const;

    // VRML 200x PositionInterpolator2D not implemented yet
    bool                isAnimateable() const { return false; }
    bool                hasAnimationSupport() { return false; }

private:
    float		_value[2];
};

#endif // _SFVEC2F_H
