/***************************************************************************
                          mplayer.h    description
                             
    begin                : Wed Jan 28 2004
    copyright            : (C) 2004 by Rajendra R Patil
    email                : rajendra_p123@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MPLAYER_H
#define MPLAYER_H
#include <config.h>
#include "playerinterface.h"
#include <qmessagebox.h>
#include <kmessagebox.h>
#include <qprocess.h>
#include <qtimer.h>

#ifdef HAVE_MPLAYER

class MPlayer : public PlayerInterface  {

 public: 
  MPlayer(bool noscreen = false, bool noborder = false);
  ~MPlayer();
  virtual void startPlayer();
  virtual void exitPlayer();

  virtual void previous();
  virtual void play();
  virtual void play(int);
  virtual void pause();
  virtual void stop();
  virtual void next();
  virtual void playvcd();
  virtual void playdvd();

  virtual void setVolume(int);
  virtual void setCurrentTime(int); 
  virtual void toggleRepeat() {}
  virtual void toggleShuffle(){}
  
  virtual int getVolume();
  virtual int getCurrentTime();
  virtual int getTrackTime();
  virtual QString getTitle();
  virtual bool getRepeat();
  virtual bool getShuffle();
  
  virtual bool isPlaying();

  virtual bool isPlayerRunning();

  virtual void openFileSelector();
  virtual void playlistClear();
  virtual void playlistAdd(QString);
  virtual void playlistAdd(QStringList);
  virtual QStringList playlistIs();
  
  virtual Player is() { return MPLAYER; }
  virtual void playerFullscreen();
  virtual void playerfwd() { sendCommand("seek +5"); }
  virtual void playerrwd() { sendCommand("seek -5"); }
  
  void setPara(bool,bool);
  int currPtrP();

private slots:
  void over();

private:
  void sendCommand(QString);
  
  QString filename;
  QProcess *mp;
  QTimer *tim;
  QWidget *screen;

  int currvol;
  int currtime;
  int currPtr;

  bool running;
  bool noborder;
  bool noscreen;
  bool isfullscreen;

  QStringList playlist;
};

#else

class MPlayer : public PlayerInterface {

 public:
  MPlayer() {}
  ~MPlayer() {}
};

#endif

#endif
