dnl -------------------------------------------------------------------------
dnl Try to find a file (or one of more files in a list of dirs).
dnl -------------------------------------------------------------------------

AC_DEFUN(MY_FIND_FILE,
    [
    $3=NO
    for i in $2;
    do
        for j in $1;
        do
	        if test -r "$i/$j"; then
		        $3=$i
                break 2
            fi
        done
    done
    ]
)

dnl -------------------------------------------------------------------------
dnl Check whether compiler has a working ``bool'' type.
dnl -------------------------------------------------------------------------

AC_DEFUN(MY_CHECK_BOOL,
[
    AC_MSG_CHECKING([for bool])
    AC_CACHE_VAL(my_cv_have_bool,
    [
        AC_TRY_COMPILE(
            [],
            [bool aBool = true;],
            [my_cv_have_bool=yes],
            [my_cv_have_bool=no]
        )
    ])
    AC_MSG_RESULT($my_cv_have_bool)
    if test "$my_cv_have_bool" = yes; then
        AC_DEFINE(XSID_HAVE_BOOL)
    fi 
])

dnl -------------------------------------------------------------------------
dnl Check whether C++ library has member ios::bin instead of ios::binary.
dnl Will define XSID_HAVE_IOS_BIN if ios::binary is not available.
dnl -------------------------------------------------------------------------

AC_DEFUN(MY_CHECK_IOS_BIN,
[
    AC_MSG_CHECKING(whether standard member ios::binary is available)
    AC_CACHE_VAL(my_cv_have_ios_binary,
    [
        AC_TRY_COMPILE(
            [#include <fstream.h>],
		    [ifstream myTest(ios::in|ios::binary)],
		    [my_cv_have_ios_binary=yes],
		    [my_cv_have_ios_binary=no]
	    )
    ])
    AC_MSG_RESULT($my_cv_have_ios_binary)
    if test "$my_cv_have_ios_binary" = no; then
        AC_DEFINE(XSID_HAVE_IOS_BIN)
    fi
])

dnl -------------------------------------------------------------------------
dnl Check whether C++ compiler supports exception-handling
dnl and in particular the "nothrow allocator".
dnl Will define XSID_HAVE_NOTHROW if test code compiles.
dnl -------------------------------------------------------------------------

AC_DEFUN(MY_CHECK_NOTHROW,
[
    AC_MSG_CHECKING(whether nothrow allocator is available)
    AC_CACHE_VAL(my_cv_have_nothrow,
    [
        AC_TRY_COMPILE(
            [#include <new>],
		    [char* buf = new(nothrow) char[1024];],
		    [my_cv_have_nothrow=yes],
		    [my_cv_have_nothrow=no]
	    )
    ])
    AC_MSG_RESULT($my_cv_have_nothrow)
    if test "$my_cv_have_nothrow" = yes; then
        AC_DEFINE(XSID_HAVE_NOTHROW)
    fi
])

dnl -------------------------------------------------------------------------
dnl Pass C++ compiler options to libtool which supports C only.
dnl -------------------------------------------------------------------------

AC_DEFUN(MY_PROG_LIBTOOL,
[
    my_save_cc=$CC
    my_save_cflags=$CFLAGS
    CC=$CXX
    CFLAGS=$CXXFLAGS
    AM_PROG_LIBTOOL
    CC=$my_save_cc
    CFLAGS=$my_save_cflags
])

dnl -------------------------------------------------------------------------
dnl Try to find SIDPLAY includes and library.
dnl $my_have_sidplay will be "yes" or "no"
dnl $(sidplay_libdir) will be path to libsidplay.*
dnl $(sidplay_incdir) will be path to sidplay/*.h
dnl @SIDPLAY_LDFLAGS@ will be substituted with -L$sidplay_libdir
dnl @SIDPLAY_INCLUDES@ will be substituted with -I$sidplay_incdir
dnl -------------------------------------------------------------------------

AC_DEFUN(MY_PATH_LIBSIDPLAY,
[
    AC_MSG_CHECKING([for working SIDPLAY library and headers])
    
    dnl Be pessimistic.
    my_sidplay_library=NO
    my_sidplay_includes=NO
    sidplay_libdir=""
    sidplay_incdir=""

    AC_ARG_WITH(sidplay-includes,
        [  --with-sidplay-includes=DIR
                          where the sidplay includes are located],
        [my_sidplay_includes="$withval"]
    )

    AC_ARG_WITH(sidplay-library,
        [  --with-sidplay-library=DIR
                          where the sidplay library is installed],
        [my_sidplay_library="$withval"]
    )

    # Test compilation with library and headers in standard path.
    my_sidplay_libadd=""
    my_sidplay_incadd=""

    # Use library path given by user (if any).
    if test "$my_sidplay_library" != NO; then
        my_sidplay_libadd="-L$my_sidplay_library"
    fi

    # Use include path given by user (if any).
    if test "$my_sidplay_includes" != NO; then
        my_sidplay_incadd="-I$my_sidplay_includes"
    fi

    # Run test compilation.
    AC_CACHE_VAL(my_cv_libsidplay_works,
    [
        MY_TRY_LIBSIDPLAY
        my_cv_libsidplay_works=$my_libsidplay_works
    ])

    if test "$my_cv_libsidplay_works" = no; then
    
        # Test compilation failed.
        # Need to search for library and headers.
        AC_CACHE_VAL(my_cv_have_sidplay,
        [
            # Search common locations where header files might be stored.
            sidplay_incdirs="$my_sidplay_includes /usr/include /usr/local/include /usr/lib/sidplay/include /usr/local/lib/sidplay/include"
            MY_FIND_FILE(sidplay/sidtune.h,$sidplay_incdirs,sidplay_foundincdir)
            my_sidplay_includes=$sidplay_foundincdir

            # Search common locations where library might be stored.
            sidplay_libdirs="$my_sidplay_library /usr/lib /usr/local/lib /usr/lib/sidplay /usr/local/lib/sidplay"
            MY_FIND_FILE(libsidplay.so libsidplay.so.1 libsidplay.so.1.36 libsidplay.so.1.37,$sidplay_libdirs,sidplay_foundlibdir)
            my_sidplay_library=$sidplay_foundlibdir

            if test "$my_sidplay_includes" = NO || test "$my_sidplay_library" = NO; then
                my_cv_have_sidplay="my_have_sidplay=no"
            else
                my_cv_have_sidplay="my_have_sidplay=yes"
            fi
        ])
        
        eval "$my_cv_have_sidplay"
        if test "$my_have_sidplay" = yes; then
            sidplay_libadd="-L$my_sidplay_library"
            sidplay_incadd="-I$my_sidplay_includes"
            
            # Test compilation with found paths.
            AC_CACHE_VAL(my_cv_found_libsidplay_works,
            [
                MY_TRY_LIBSIDPLAY
                my_cv_found_libsidplay_works=$my_libsidplay_works
            ])
            my_have_sidplay=$my_cv_found_libsidplay_works
            
            if test "$my_have_sidplay" = no; then
                # Found library does not link without errors.
                my_have_sidplay=no
                AC_MSG_RESULT([$my_have_sidplay]);
            else
                AC_MSG_RESULT([library $my_sidplay_library, headers $my_sidplay_includes])
            fi
        else
            # Either library or headers not found.
            AC_MSG_RESULT([$my_have_sidplay]);
        fi
    else
        # Simply print 'yes' without printing the standard path.
        my_have_sidplay=yes
        AC_MSG_RESULT([$my_have_sidplay]);
    fi

    AC_SUBST(sidplay_libdir)
    AC_SUBST(sidplay_incdir)

    SIDPLAY_LDFLAGS="$my_sidplay_libadd"
    SIDPLAY_INCLUDES="$my_sidplay_incadd"

    AC_SUBST(SIDPLAY_LDFLAGS)
    AC_SUBST(SIDPLAY_INCLUDES)
])

dnl Function used by MY_PATH_LIBSIDPLAY.

AC_DEFUN(MY_TRY_LIBSIDPLAY,
[
    my_cxxflags_save=$CXXFLAGS
    my_ldflags_save=$LDFLAGS
    my_libs_save=$LIBS

    CXXFLAGS="$CXXFLAGS $my_sidplay_incadd"
    LDFLAGS="$LDFLAGS $my_sidplay_libadd"
    LIBS="-lsidplay"

    AC_TRY_LINK(
        [#include <sidplay/sidtune.h>],
        [sidTune* myTest;],
        [my_libsidplay_works=yes],
        [my_libsidplay_works=no]
    )

    CXXFLAGS="$my_cxxflags_save"
    LDFLAGS="$my_ldflags_save"
    LIBS="$my_libs_save"
])

dnl -------------------------------------------------------------------------
dnl Try to find the X includes and libraries.
dnl -------------------------------------------------------------------------

AC_DEFUN(MY_PATH_X,
[
AC_MSG_CHECKING(for X)
AC_CACHE_VAL(ac_cv_have_x,
[# One or both of the vars are not set, and there is no cached value.
ac_x_includes=NO ac_x_libraries=NO
AC_PATH_X_DIRECT
AC_PATH_X_XMKMF
if test "$ac_x_includes" = NO || test "$ac_x_libraries" = NO; then
  AC_MSG_ERROR([Can't find X includes. Please check your installation and add the correct paths!])
else
  # Record where we found X for the cache.
  ac_cv_have_x="have_x=yes \
                ac_x_includes=$ac_x_includes ac_x_libraries=$ac_x_libraries"
fi])dnl
eval "$ac_cv_have_x"
 
if test "$have_x" != yes; then
  AC_MSG_RESULT($have_x)
  no_x=yes
else
  # If each of the values was on the command line, it overrides each guess.
  test "x$x_includes" = xNONE && x_includes=$ac_x_includes
  test "x$x_libraries" = xNONE && x_libraries=$ac_x_libraries
  # Update the cache value to reflect the command line values.
  ac_cv_have_x="have_x=yes \
                ac_x_includes=$x_includes ac_x_libraries=$x_libraries"
  AC_MSG_RESULT([libraries $x_libraries, headers $x_includes])
fi

if test -z "$x_includes" || test "x$x_includes" = xNONE; then
  X_INCLUDES=""
  x_includes="."; dnl better than nothing :-
 else
  X_INCLUDES="-I$x_includes"
fi

if test -z "$x_libraries" || test "$x_libraries" = xNONE; then
  X_LDFLAGS=""
  x_libraries="/usr/lib"; dnl better than nothing :-
  all_libraries=""
 else
  X_LDFLAGS="-L$x_libraries"
  all_libraries=$X_LDFLAGS
fi

AC_SUBST(X_INCLUDES)
AC_SUBST(X_LDFLAGS)
all_includes=$X_INCLUDES
])

dnl ------------------------------------------------------------------------
dnl Try to find the Qt headers and libraries.
dnl $(QT_LDFLAGS) will be -Lqtliblocation (if needed)
dnl and $(QT_INCLUDES) will be -Iqthdrlocation (if needed)
dnl ------------------------------------------------------------------------

AC_DEFUN(AC_PATH_QT,
[
AC_REQUIRE([MY_PATH_X])

AC_MSG_CHECKING([for Qt])
ac_qt_includes=NO
ac_qt_libraries=NO
qt_includes=""
qt_libraries=""
AC_ARG_WITH(qt-dir,
    [  --with-qt-dir           where the root of qt is installed],
    [  ac_qt_includes="$withval"/include
       ac_qt_libraries="$withval"/lib
    ])

AC_ARG_WITH(qt-includes,
    [  --with-qt-includes      where the qt includes are],
    [  
       ac_qt_includes="$withval"
    ])
    
AC_ARG_WITH(qt-libraries,
    [  --with-qt-libraries     where the qt library is installed],
    [  ac_qt_libraries="$withval"
    ])

if test "$ac_qt_includes" = NO || test "$ac_qt_libraries" = NO; then

AC_CACHE_VAL(ac_cv_have_qt,
[#try to guess qt locations

qt_incdirs="$ac_qt_includes /usr/lib/qt/include /usr/local/qt/include /usr/include/qt /usr/include /usr/X11R6/include/X11/qt $x_includes $QTINC"
test -n "$QTDIR" && qt_incdirs="$QTDIR/include $QTDIR $qt_incdirs"
MY_FIND_FILE(qmovie.h, $qt_incdirs, qt_incdir)
ac_qt_includes=$qt_incdir

qt_libdirs="$ac_qt_libraries /usr/lib/qt/lib /usr/local/qt/lib /usr/lib/qt /usr/lib $x_libraries $QTLIB"
test -n "$QTDIR" && qt_libdirs="$QTDIR/lib $QTDIR $qt_libdirs"
MY_FIND_FILE(libqt.so libqt.so.2 libqt.so.2.2 libqt.a libqt.sl, $qt_libdirs, qt_libdir)
ac_qt_libraries=$qt_libdir

dnl No compile test.

dnl ac_cxxflags_safe=$CXXFLAGS
dnl ac_ldflags_safe=$LDFLAGS
dnl ac_libs_safe=$LIBS

dnl CXXFLAGS="$CXXFLAGS -I$qt_incdir"
dnl LDFLAGS="-L$qt_libdir $X_LDFLAGS"
dnl LIBS="$LIBS -lqt -lXext -lX11 $LIBSOCKET"

dnl

dnl if AC_TRY_EVAL(ac_link) && test -s conftest; then
dnl rm -f conftest*
dnl else
dnl   echo "configure: failed program was:" >&AC_FD_CC
dnl   cat conftest.$ac_ext >&AC_FD_CC
dnl   ac_qt_libraries=NO
dnl fi
dnl rm -f conftest*
dnl CXXFLAGS=$ac_cxxflags_safe
dnl LDFLAGS=$ac_ldflags_safe
dnl LIBS=$ac_libs_safe

if test "$ac_qt_includes" = NO || test "$ac_qt_libraries" = NO; then
  ac_cv_have_qt="have_qt=no"
  ac_qt_notfound=""
  if test "$ac_qt_includes" = NO; then
    if test "$ac_qt_libraries" = NO; then
      ac_qt_notfound="(headers and libraries)";
    else
      ac_qt_notfound="(headers)";
    fi
  else
    ac_qt_notfound="(libraries)";
  fi

  AC_MSG_ERROR([Qt $ac_qt_notfound not found. Please check your installation!]);
else
  have_qt=yes
fi
])
else
  have_qt=yes
fi

eval "$ac_cv_have_qt"

if test "$have_qt" != yes; then
  AC_MSG_RESULT([$have_qt]);
else
  ac_cv_have_qt="have_qt=yes \
    ac_qt_includes=$ac_qt_includes ac_qt_libraries=$ac_qt_libraries"
  AC_MSG_RESULT([libraries $ac_qt_libraries, headers $ac_qt_includes])
  
  qt_libraries=$ac_qt_libraries
  qt_includes=$ac_qt_includes
fi

AC_SUBST(qt_libraries)
AC_SUBST(qt_includes)

if test "$qt_includes" = "$x_includes" || test -z "$qt_includes"; then
 QT_INCLUDES="";
else
 QT_INCLUDES="-I$qt_includes"
 all_includes="$QT_INCLUDES $all_includes"
fi

if test "$qt_libraries" = "$x_libraries" || test -z "$qt_libraries"; then
 QT_LDFLAGS=""
else
 QT_LDFLAGS="-L$qt_libraries"
 all_libraries="$QT_LDFLAGS $all_libraries"
fi

AC_SUBST(QT_INCLUDES)
AC_SUBST(QT_LDFLAGS)
])

dnl -------------------------------------------------------------------------
dnl Find the Qt meta object compiler.
dnl -------------------------------------------------------------------------

AC_DEFUN(AC_PATH_QT_MOC,
[
AC_PATH_PROG(MOC,moc,/usr/bin/moc,
             $PATH:/usr/bin:/usr/X11R6/bin:$QTDIR/bin:/usr/lib/qt/bin:/usr/local/qt/bin)
])

