/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef PLAYLISTDIALOG_H
#define PLAYLISTDIALOG_H

class Playlist;

#include "PlaylistItem.h"
#include "PlaylistDialogData.h"
#include "WidgetOffset.h"

class PlaylistDialog : public PlaylistDialogData
{ 
    Q_OBJECT

public:
    PlaylistDialog( QWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0 );
    ~PlaylistDialog();

    // Provide a pointer to a playlist.
    // This function -- and most of the other member functions that are
    // called thereafter -- may modify the playlist being pointed to.
    void takeList(Playlist*);
    
    void add(PlaylistItem*);
    
protected:
    Playlist* playlist;
    PlaylistItem curPlaylistItem;  // temp, e.g used for sending signals

    // Currently displays time, fadeout, etc, at the right border.
    // This may become obsolete if QListView is used to show a
    // multi-column box.
    void showPlaylistItem(const PlaylistItem*, int);
    
    void resizeEvent(QResizeEvent*);

protected slots:
    void startButtonClicked();
    void nextButtonClicked();
    void prevButtonClicked();
//    void deleteButtonClicked();
    void playlistItemSelected(int);
    void playlistItemHighlighted(int);
    void clear();
    
    // The following get invoked when external components modify the
    // current playlist. That way the listbox can be kept uptodate.
    void newListPos(uint);
    void deleteListPos(uint);
    void updateListPos(uint);

 signals:
    void playlistPlayRequest(const PlaylistItem&);
    void playlistPlayNewPosRequest(int);

 private:
    struct
    {
        WidgetOffset listPosLabel,
            prevButton, startButton,
            nextButton, playListBox,
            subtuneLabel, playtimeLabel, fadeoutLabel;
    } widgetOffs;
};

#endif  /* PLAYLISTDIALOG_H */
