/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef LEDBUTTON_H
#define LEDBUTTON_H

class QPainter;
class QPixmap;

#include <qbutton.h>
#include <qcolor.h>

class LEDButton : public QButton
{
    Q_OBJECT
    
 public:

    enum LEDColour
    {
        green, red,
        none  // no LED
    };
    
    LEDButton(QWidget* parent=0, const char* name=0);
    ~LEDButton();

    void setColour(LEDColour);
    void setText(const char*);
    void setChecked(bool);
    bool isChecked() const;
    void setEnabled(bool);
    bool isEnabled() const;
    void toggle();
    
 private:

    void createPixmaps();
    void drawButton(QPainter*);
    
    QPixmap* onPixmap;
    QPixmap* offPixmap;
    QPixmap* disabledPixmap;

    QColor backgCol;
    LEDColour colour;
    
    bool bChecked, bEnabled;
};

#endif  /* LEDBUTTON_H */
