##############################################################################
#
# Copyright (c) 2002 Ingeniweb SARL
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.0 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE
#
##############################################################################

"""
ZAttachmentAttribute product

Configuration file.
You can edit this file.
"""

import sys
import App.Common
import os
import string
import os.path

from Products.ZAttachmentAttribute.Log import *


# Converter program
PACKAGE_HOME = App.Common.package_home(globals())
WVWARE_PROGRAM = None
if sys.platform == 'win32':
    # Windows platform
    WVWARE_PROGRAM = '"' + os.path.join(PACKAGE_HOME, "win32", "bin", "wvware.exe", ) + '"' 
    Log(LOG_DEBUG, "Using '%s'." % (WVWARE_PROGRAM,))
    try:
        f = open(WVWARE_PROGRAM[1:-1], "r")
    except:
        WVWARE_PROGRAM = None
        Log(LOG_WARNING, "Converter program '%s' not found ! Please check your installation" % (WVWARE_PROGRAM,))
    f.close()

else:
    # Unix platform
    import commands
    program = commands.getoutput("which wvWare")
    if not program:
        Log(LOG_WARNING, "MSWordAttachment: wvWare not found ! Indexing won't work.")
    else:
        WVWARE_PROGRAM = string.strip(program)
        Log(LOG_NOTICE, "MSWordAttachment: Using '%s' for indexing." % (WVWARE_PROGRAM, ))
