#ifdef WIN32

#include <Windows.h>
#include <FL/Fl.H>
#include "FL/fl_ask.H"
#include "FL/x.H"
#include "FL/fl_draw.H"
#include "src/Fl_Font.H"
#include <stdarg.h>
#include <string.h>
#include <direct.h>
#include <stdlib.h>
#include <stdio.h>
#ifndef NO_PDF
#include <pdflib.h>
#endif

/* included functions */
void MG_fl_draw(const char *txt, int x, int y);
void *MG_PrepareCopy(int w, int h);
void MG_CompleteCopy(void *oldflgc);
extern "C" {
	void my_bell(void);
	int mysystem(const char *command);
	char *get_prog_dir(void);
}
char **getutf8args(int *pargc);
void draw_rotated_string(const char *strDraw, int x, int y, float degrees /*clockwise*/);

/* extern vars & functions */
extern char *wchartoutf8(const wchar_t *in);

void MG_fl_draw(const char *txt, int x, int y)
/* it is reprogrammed because in FLTK 1.3 text is output one char at a time
 and this is not convenient when doing copy/paste
 */
{
	if(txt == NULL) return;
	int n = strlen(txt);
	COLORREF oldColor = SetTextColor(fl_gc, fl_RGB());
	if (fl_fontsize) SelectObject(fl_gc, fl_fontsize->fid);
	WCHAR *wout = new WCHAR[n+5];
	int newl = MultiByteToWideChar(CP_UTF8, 0, txt, n, wout, n + 5);
	TextOutW(fl_gc, x, y, wout, newl);
	delete wout;
	SetTextColor(fl_gc, oldColor);
}


void *MG_PrepareCopy(int w, int h)
/* returns NULL iff error
 */
{
	HDC oldflgc = fl_gc;
	int factor = 32; // empirically set
	RECT rect; rect.left = 0; rect.top = 0; rect.right=w*factor; rect.bottom=h*factor;
	fl_gc = CreateEnhMetaFile (NULL, NULL, &rect, NULL);
	if (fl_gc != NULL) {
		SetTextAlign(fl_gc, TA_BASELINE|TA_LEFT);
		SetBkMode(fl_gc, TRANSPARENT);
		return oldflgc ? oldflgc : fl_gc;
    } 
	else {
		fl_gc = oldflgc;
		return NULL;
	}
}


void MG_CompleteCopy(void *oldflgc)
{
	if(oldflgc == fl_gc) oldflgc = NULL;
	HENHMETAFILE hmf = CloseEnhMetaFile (fl_gc);
	if ( hmf != NULL ) {
		if ( OpenClipboard (NULL) ){
			EmptyClipboard ();
			SetClipboardData (CF_ENHMETAFILE, hmf);
			CloseClipboard ();
		}
		DeleteEnhMetaFile(hmf);
	}
	DeleteDC(fl_gc);
	fl_gc = (HDC)oldflgc;
}


int mysystem(const char *command)
/*
 command contains "cmd.exe /c prog.exe args"  or  "prog.exe args"
 the first form is compulsory if args contain "> outfile"
 prog is searched in dir where calling program was launched, current dir,
 windows system dir, windows dir, dirs in PATH.
 returns 0 iff OK
 */
{
	static char buf[100];
	STARTUPINFO info;
	PROCESS_INFORMATION pi;
	int retval;
	
	GetStartupInfo(&info);
	retval = CreateProcess(NULL, (char *)command,0,0,0,0,0,_getcwd(buf,sizeof(buf)),&info,&pi);
	if(retval == 0) return 1;
	do	{
		Fl::check();
		retval = WaitForSingleObject(pi.hProcess, 500);
	}
	while(retval == WAIT_TIMEOUT);
	return 0;
}

char *get_prog_dir(void)
/* returns path of dir where calling program was launched */
{
	static char *dir = NULL;
	char *line, *p;
	int l;
	
	if(dir == NULL) {
		line = wchartoutf8(GetCommandLineW());
		//fprintf(OUT,"retour GetCommandLine line=%s\n",line);fflush(OUT);
		/* extract 1st word of line or first group delimited by " " */
		if(*line == '"') { line++; p = strchr(line, '"'); }
		else p = strchr(line, ' '); 
		if(p == NULL) p = line + strlen(line);
		l = p - line;
		while( l > 0 && line[l - 1] != '\\' ) l--;
		if(l > 0) {
			dir = (char *)malloc(l + 1);
			memcpy(dir, line, l); dir[l] = 0;
		}
	}
	return dir;
}


void my_bell(void)
{
	Beep(0,0);
} 


char **getutf8args(int *pargc)
{
	int argc;
	wchar_t **wargv = CommandLineToArgvW(GetCommandLineW(), &argc);
	char **argv = (char **)malloc(argc * sizeof(char *));
	for (int count = 0; count < argc; count++) {
		argv[count] = strdup(wchartoutf8(wargv[count]));
	}
	*pargc = argc;
	return argv;
}


void draw_rotated_string(const char *strDraw, int x, int y, float degrees /*clockwise*/)
{
	int n = strlen(strDraw);
	WCHAR *wout = new WCHAR[n+5];
	int newl = MultiByteToWideChar(CP_UTF8, 0, strDraw, n, wout, n + 5);
	LOGFONT lf;
	memset(&lf, 0, sizeof(LOGFONT));
	int rank = fl_font() / 4;
	SelectObject(fl_gc, fl_fontsize->fid);//necessary to put selected fltk's font in fl_gc
	GetTextFace(fl_gc, sizeof(lf.lfFaceName), lf.lfFaceName);

	if(fl_font() < 12) {//only the first 12 fonts have bold/italic
		rank = fl_font() % 4;
		lf.lfWeight = (rank == 1 || rank == 3) ? FW_BOLD : FW_NORMAL;
		lf.lfItalic = (rank == 2 || rank == 3) ? 1 : 0;
	}
	lf.lfHeight = - fl_size();

	// Specify the angle to draw line
	lf.lfEscapement = - (LONG)(degrees*10);
	lf.lfOrientation = lf.lfEscapement;
	// Select the new font created
	HFONT hFont = (HFONT) CreateFontIndirect(&lf);
	HFONT hPrevFont = (HFONT) SelectObject(fl_gc, hFont);

	// Draw text to GC with color
	SetTextColor(fl_gc, fl_RGB());
	TextOutW(fl_gc, x, y, wout, newl);
	SelectObject(fl_gc, hPrevFont);
	DeleteObject(hFont);
	delete wout;
}

extern LPCWSTR utf8towchar(const char *in);
static FILE *pdf_output = NULL;

static size_t pdf_write_proc(PDF *p, void *data, size_t size)
{
  return fwrite(data, 1, size, pdf_output);
}

// because PDF_begin_document fails on WIN32 if non ascii filename
int win32_PDF_begin_document(PDF *p, const char *filename, int len, const char *optlist)
{
  pdf_output = _wfopen(utf8towchar(filename), L"wb"); // binary mode compulsory
  if(pdf_output == NULL) return -1;
  PDF_begin_document_callback(p, pdf_write_proc, optlist);
  return 1;
}

void win32_PDF_end_document(PDF *p, const char *optlist)
{
  PDF_end_document(p, optlist);
  fclose(pdf_output);
  pdf_output = NULL;
}

/*
 void add_to_path(char *dir)
 /* ajoute a la variable PATH la directory dir
 teste si deja dedans ou si vide *
 {
 char *buffer;
 int l;
 
 if(dir == NULL || strlen(dir) == 0) return;
 buffer = (char *)malloc(10000);
 l = GetEnvironmentVariable("PATH", buffer, 10000);
 if(l == 0) *buffer = 0;
 if(strstr(buffer, dir) != NULL) return;
 if(*buffer != 0) strcat(buffer, ";");
 strcat(buffer, dir);
 SetEnvironmentVariable("PATH", buffer);
 free(buffer);
 }
 
 
 char **split_args(char *all, int *pargc)
 {
 char *p, *q, **argv;
 int l, argc = 0;
 
 // compter les arguments
 p = all;
 while(*p != 0) {
 argc++;
 if(*p == '"') p = strchr(p+1, '"');
 else p = strchr(p, ' ');
 if(p == NULL) break;
 p++;
 while(*p == ' ') p++;
 }
 argv = (char **)malloc(argc * sizeof(char *));
 *pargc = argc;
 // separer les arguments, enlever les "" encadrantes si presentes
 p = all; argc = 0;
 while(*p != 0) {
 if(*p == '"') { p++; q = strchr(p, '"'); }
 else q = strchr(p, ' ');
 if(q == NULL) q = p + strlen(p);
 l = q - p; 
 argv[argc] = (char *)malloc(l + 1);
 memcpy(argv[argc], p, l); argv[argc][l] = 0;
 if(*q == 0) break;
 p = q + 1;
 while(*p == ' ') p++;
 argc++;
 }
 return argv;
 }
 */

#endif // WIN32
