<?php
/*************************************************************************************
 * thinbasic.php
 * ------
 * Author: Eros Olmi (eros.olmi@thinbasic.com)
 * Copyright: (c) 2006 Eros Olmi (http://www.thinbasic.com), Nigel McNie (http://qbnz.com/highlighter)
 * Release Version: 1.0.7.19
 * Date Started: 2006/05/12
 *
 * thinBasic language file for GeSHi.
 *
 * CHANGES
 * -------
 * 2006/05/12 (1.0.0)
 *  -  First Release
 *
 * TODO (updated 2006/05/12)
 * -------------------------
 *
 *************************************************************************************
 *
 *     This file is part of GeSHi.
 *
 *   GeSHi is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   GeSHi is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with GeSHi; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 ************************************************************************************/
 $language_data = array (
       'LANG_NAME' => 'thinBasic',
       'COMMENT_SINGLE' => array(1 => "'"),
       'COMMENT_MULTI' => array(),
       'CASE_KEYWORDS' => GESHI_CAPS_NO_CHANGE,
       'QUOTEMARKS' => array('"'),
       'ESCAPE_CHAR' => '',
       'KEYWORDS' => array(
               1 => array(
                        '#DEF','#DEFAULT','#ELSE','#ELSEIF','#ENDIF','#IF','#MINVERSION','%DEF',
                        'ABS','ADD','ADO_CONNECTION_CLOSE','ADO_CONNECTION_EXECUTE','ADO_CONNECTION_GETCONNECTIONSTRING','ADO_CONNECTION_OPEN','ADO_CONNECTION_SETCONNECTIONSTRING','ADO_CREATEOBJECT',
                        'ADO_RECORDSET_CLOSE','ADO_RECORDSET_EOF','ADO_RECORDSET_GETCOLLECTN','ADO_RECORDSET_GETCOLLECTS','ADO_RECORDSET_MOVEFIRST','ADO_RECORDSET_MOVELAST','ADO_RECORDSET_MOVENEXT','ADO_RECORDSET_MOVEPREVIOUS',
                        'ADO_RECORDSET_OPEN','ADO_RECORDSET_PUTREFACTIVECONNECTION','ADO_RECORDSET_SETCURSORLOCATION','ADO_RECORDSET_SETCURSORTYPE','ADO_RECORDSET_SETLOCKTYPE','ADO_RECORDSET_SETSOURCE','ADO_RELEASE','ADO_RESULT',
                        'ALERT','ALIAS','AND','ANIMATE_OPEN','ANIMATE_PLAY','ANIMATE_STOP','ANY','APPEND',
                        'APP_COUNTER','APP_INCLUDEPATH','APP_LISTEQUATES','APP_LISTFUNCTIONS','APP_LISTKEYWORDS','APP_LISTVARIABLES','APP_NAME','APP_PATH',
                        'APP_SOURCEFULLNAME','APP_SOURCENAME','APP_SOURCEPATH','APP_TIMER','ARCCOS','ARCCOSH','ARCCOT','ARCCOTH',
                        'ARCCSC','ARCCSCH','ARCSEC','ARCSECH','ARCSIN','ARCSINH','ARCTANH','ARRAY',
                        'AS','ASC','ASCEND','ASCENDING','ASCII2UNICODE','ASCIIZ','ASCIZ','ASSIGN',
                        'AT','ATN','ATTACH','BAR','BEEP','BIFF_CLOSEFILE','BIFF_CREATEFILE','BIFF_SETBUFFER',
                        'BIFF_SETCOLWIDTH','BIFF_SETROWHEIGHT','BIFF_WRITEDATE','BIFF_WRITENUMBER','BIFF_WRITETEXT','BIN$','BOUNDCHECK','BUTTON',
                        'BYCMD','BYREF','BYTE','BYVAL','CALL','CASE','CEIL','CGI_ADDQUOTE',
                        'CGI_ADDSPECIALCHARSPREFIX','CGI_CFGGETOPTION','CGI_CFGSETOPTION','CGI_ENVIRON','CGI_GETCURRENTGUID','CGI_GETCURRENTSESSION','CGI_GETQUERYVALUE','CGI_GETREQUESTMETHOD',
                        'CGI_GETSESSIONVARIABLE','CGI_HEADER','CGI_LOADCONFIGFILE','CGI_READ','CGI_REMOVEQUOTE','CGI_REMOVESPECIALCHARSPREFIX','CGI_RESETDEFAULTSETTINGS','CGI_SETSESSIONVARIABLE',
                        'CGI_STARTSESSION','CGI_UPLOADFILESIZE','CGI_UPLOADFILESNUMBER','CGI_UPLOADFILESTIME','CGI_URLDECODESTRING','CGI_WRITE','CGI_WRITELOGFILE','CHECK',
                        'CHECK3STATE','CHECKBOX','CHOOSE$','CHR$','CLEARMESSAGES','CLIENT','CLIPBOARD_GETTEXT','CLIPBOARD_SETTEXT',
                        'COLOR','COMBINATIONS','COMBOBOX','COM_BUILDVARIANT','COM_CLSIDFROMPROGID','COM_CLSIDFROMSTRING','COM_CREATEOBJECT','COM_DISPLAYERROR',
                        'COM_EXECUTE','COM_GETENGINEGUID','COM_GETOBJECT','COM_ISEQUALCLSID','COM_ISEQUALGUID','COM_ISEQUALIID','COM_PROGIDFROMCLSID','COM_QUERYINTERFACE',
                        'COM_RELEASE','COM_STRINGFROMCLSID','COM_SUCCEEDED','COM_VARIANTCLEAR','COM_VARIANTCOPY','COM_VARIANTINIT','CONSOLE_ALLOC','CONSOLE_AREFILEAPISANSI',
                        'CONSOLE_ATTACH','CONSOLE_BACKGROUNDRGB','CONSOLE_BOX','CONSOLE_CLS','CONSOLE_CREATESCREENBUFFER','CONSOLE_DISABLECTRLC','CONSOLE_ENABLECTRLC','CONSOLE_FOREGROUNDRGB',
                        'CONSOLE_FREE','CONSOLE_FULLSCREEN','CONSOLE_GENERATECTRLEVENT','CONSOLE_GETCP','CONSOLE_GETCURRENTFONTINDEX','CONSOLE_GETCURSORSIZE','CONSOLE_GETCURSORX','CONSOLE_GETCURSORY',
                        'CONSOLE_GETINPUTMODE','CONSOLE_GETNUMBEROFMOUSEBUTTONS','CONSOLE_GETOUTPUTCP','CONSOLE_GETOUTPUTMODE','CONSOLE_GETPROGRESSBARCHAR','CONSOLE_GETSIZEX','CONSOLE_GETSIZEY','CONSOLE_GETSTDHANDLE',
                        'CONSOLE_GETTEXTATTRIBUTE','CONSOLE_GETTITLE','CONSOLE_HIDECURSOR','CONSOLE_INKEY','CONSOLE_INKEYB','CONSOLE_NORMALSCREEN','CONSOLE_PRINT','CONSOLE_PRINTAT',
                        'CONSOLE_PRINTLINE','CONSOLE_PROGRESSBAR','CONSOLE_READ','CONSOLE_READLINE','CONSOLE_RESTORESCREEN','CONSOLE_SAVESCREEN','CONSOLE_SCROLLBUFFER','CONSOLE_SCROLLBUFFERONEROW',
                        'CONSOLE_SCROLLWINDOW','CONSOLE_SETACTIVESCREENBUFFER','CONSOLE_SETCP','CONSOLE_SETCURSORPOSITION','CONSOLE_SETCURSORSIZE','CONSOLE_SETFILEAPISTOANSI','CONSOLE_SETFILEAPISTOOEM','CONSOLE_SETINPUTMODE',
                        'CONSOLE_SETOUTPUTCP','CONSOLE_SETOUTPUTMODE','CONSOLE_SETPROGRESSBARCHAR','CONSOLE_SETSCREENBUFFERSIZE','CONSOLE_SETSTDHANDLE','CONSOLE_SETTEXTATTRIBUTE','CONSOLE_SETTITLE','CONSOLE_SHOWCURSOR',
                        'CONSOLE_SHOWWINDOW','CONSOLE_WAITKEY','CONSOLE_WRITE','CONSOLE_WRITELINE','CONTROL','CONTROL_GETNUMBER','CONTROL_GETTEXT','COS',
                        'COSH','COTAN','COTH','CREATEFONT','CRYPTO_DECRYPT','CRYPTO_ENCRYPT','CRYPTO_ENUMPROVIDERS','CRYPTO_ENUMPROVIDERTYPES',
                        'CRYPTO_GENRANDOMSTRING','CRYPTO_GETDEFAULTPROVIDER','CRYPTO_GETPROVIDERSCOUNT','CRYPTO_GETPROVIDERTYPESCOUNT','CSC','CSCH','CSET$','CUR',
                        'CURRENCY','CVBYT','CVCUR','CVCUX','CVD','CVDWD','CVE','CVI',
                        'CVL','CVQ','CVS','CVWRD','DATE$','DECLARE','DECR','DEGTORAD',
                        'DELETE','DELETEOBJECT','DESCEND','DESCENDING','DESKTOP','DIALOG','DIALOG_BROWSEFORFOLDER','DIALOG_CHOOSECOLOR',
                        'DIALOG_OPENFILE','DIALOG_SAVEFILE','DIM','DIR_CHANGE','DIR_CHANGEDRIVE','DIR_EXISTS','DIR_GETCURRENT','DIR_ISDIR',
                        'DIR_ISEMPTY','DIR_LIST','DIR_MAKE','DIR_MAKEALL','DIR_REMOVE','DISABLE','DO','DOEVENTS',
                        'DOUBLE','DRAW','DT_COOKIEDATE','DT_DATEADDDAYS','DT_DATEDIFF','DT_DATEFORMAT','DT_DATESUBDAYS','DT_DATETIMEADDSECONDS',
                        'DT_DATETIMESUBSECONDS','DT_DATETOSEC','DT_DAY','DT_GETDATECENTURY','DT_GETDATESEPARATOR','DT_GETMONTHNAME','DT_GETTIMESEPARATOR','DT_GETTIMESTAMP',
                        'DT_GETWEEKDAY','DT_GETWEEKDAYNAME','DT_HOUR','DT_ISLEAPYEAR','DT_ISVALIDDATE','DT_LASTDAYOFMONTH','DT_MINUTE','DT_MONTH',
                        'DT_SECOND','DT_SECTODATE','DT_SECTOTIME','DT_SETDATECENTURY','DT_SETDATESEPARATOR','DT_SETTIMESEPARATOR','DT_TIMEADDSECONDS','DT_TIMEFORMAT',
                        'DT_TIMESUBSECONDS','DT_TIMETOSEC','DT_YEAR','DWORD','ECHO','ELSE','ELSEIF','ENABLE',
                        'END','ENDIF','ENGINE_GETCURRENTTOKEN','ERR','ERRCLEAR','EXIT','EXP','EXP10',
                        'EXP2','EXPORT','EXT','EXTRACT$','FACTORIAL','FILE_CHANGED','FILE_CLOSE','FILE_COPY',
                        'FILE_EOF','FILE_EXISTS','FILE_GET','FILE_GETDATE','FILE_GETDATETIME','FILE_GETDATETIMESTAMP','FILE_GETTIME','FILE_GETVERSION',
                        'FILE_GETVERSIONSTRING','FILE_KILL','FILE_LOAD','FILE_LOF','FILE_OPEN','FILE_PATHSPLIT','FILE_PUT','FILE_RENAME',
                        'FILE_SAVE','FILE_SEEK','FILE_SETDATETIME','FILE_SIZE','FIX','FLUSH','FOCUS','FONT',
                        'FONT_CREATE','FONT_LIST','FOR','FORMAT$','FRAC','FRAME','FTP_COMMAND','FTP_CONNECT',
                        'FTP_DELFILE','FTP_EXTRACT','FTP_FINISHED','FTP_GETERRORNUMBER','FTP_GETERRORSTRING','FTP_GETFILE','FTP_GETLIST','FTP_GETLOCALDIR',
                        'FTP_GETNUMBER','FTP_GETSERVERDIR','FTP_GETSTRING','FTP_PUTFILE','FTP_QUIT','FTP_SETLOCALDIR','FTP_SETLOGFILE','FTP_SETMODE',
                        'FTP_SETNUMBER','FTP_SETSERVERDIR','FTP_SETSTRING','FUNCTION','FUNCTION_CPARAMS','FUNCTION_EXISTS','FUNCTION_NAME','FUNCTION_NPARAMS',
                        'GET','GETASYNCKEYSTATE','GETMESSAGE','GETS','GETTICKCOUNT','GLOBAL','GRAPHIC','GUID$',
                        'GUIDTXT$','HANDLE','HASH','HEX$','HIINT','HIWRD','HOSTIP_TONAME','HOSTNAME_TOIP',
                        'HOST_ADDR','ICRYPTO_ASCII2BIN','ICRYPTO_ASCII2STRING','ICRYPTO_BIN2ASCII','ICRYPTO_BYTEXOR','ICRYPTO_CRC16','ICRYPTO_CRC32','ICRYPTO_DECRYPTRC4',
                        'ICRYPTO_DECRYPTRIJNDAEL','ICRYPTO_ENCRYPTRC4','ICRYPTO_ENCRYPTRIJNDAEL','ICRYPTO_MD5','ICRYPTO_SHA1','ICRYPTO_STRING2ASCII','ICRYPTO_TESTCRC16','ICRYPTO_TESTCRC32',
                        'ICRYPTO_TESTMD5','ICRYPTO_TESTSHA1','IF','IIF','IIF$','IMAGE','IN','INCR',
                        'INET_GETCONNECTIONMODE','INET_GETIP','INET_GETSTATE','INET_OPENDIALUPDIALOG','INET_URLDOWNLOAD','INI_GETKEY','INI_GETSECTIONKEYLIST','INI_GETSECTIONSLIST',
                        'INI_SETKEY','INPUTBOX$','INSTR','INT','INTEGER','IP_ADDR','IP_TOSTRING','ISEVEN',
                        'ISFALSE','ISODD','ISTRUE','ISUNICODE','ISWINDOW','ITERATE','JOIN$','KILL',
                        'LABEL','LBOUND','LCASE$','LEFT','LEFT$','LEN','LIB','LIBRARY_EXISTS',
                        'LINE','LISTBOX','LL_ADD','LL_COUNT','LL_DATA','LL_DATABYNAME','LL_DELETE','LL_DELETEBYNAME',
                        'LL_DELETELIKE','LL_FINDBYDATA','LL_FINDBYNAME','LL_FINDLAST','LL_FREE','LL_FROMFILE','LL_GETBYNUMBER','LL_GETITEM',
                        'LL_NAME','LL_TOFILE','LL_TOSTRING','LL_UPDATE','LL_UPDATEBYNAME','LOC','LOCAL','LOG',
                        'LOG10','LOG2','LOGB','LOG_WRITE','LOINT','LONG','LOOP','LOWRD',
                        'LSET$','LTRIM$','MAKDWR','MAKINT','MAKLNG','MAKWRD','MAX','MAX$',
                        'MCASE$','MENU','MID$','MIN','MIN$','MKBYT$','MKCUR$','MKCUX$',
                        'MKD$','MKDWD$','MKE$','MKI$','MKL$','MKQ$','MKS$','MKWRD$',
                        'MOD','MODAL','MODELESS','MODULE','MOUSEPTR','MSGBOX','NEW','NEXT',
                        'NOT','NUMBER','OFF','ON','ONCE','OPT','OPTION','OPTIONAL',
                        'OR','OS_CALLDLL','OS_ENVIRON','OS_FATALAPPEXIT','OS_FLASHWINDOW','OS_GETCOMMAND','OS_GETCOMMANDS','OS_GETCOMPUTERNAME',
                        'OS_GETCURRENTPROCESSID','OS_GETCURRENTTHREADID','OS_GETLASTCALLDLLERROR','OS_GETLASTCALLDLLSTATUS','OS_GETSPECIALFOLDER','OS_GETSYSTEMDIR','OS_GETTEMPDIR','OS_GETUSERNAME',
                        'OS_GETWINDOWSDIR','OS_IEVERSION','OS_MESSAGEBEEP','OS_SETLASTCALLDLLERROR','OS_SHELL','OS_SHELLEXECUTE','OS_WINVERSIONTEXT','PARAMETERS',
                        'PARSE','PARSE$','PARSECOUNT','PCT','PC_DECODECDERROR','PC_EJECTCD','PC_EMPTYBIN','PC_GETCAPSLOCKKEYSTATE',
                        'PC_GETCARETBLINKTIME','PC_GETNUMLOCKKEYSTATE','PC_GETSCROLLLOCKKEYSTATE','PC_GETSTATEONOFF','PC_HIDECARET','PC_INSERTCD','PC_LOCK','PC_PREVENTSHUTDOWN',
                        'PC_RESTARTDIALOG','PC_SETCARETBLINKTIME','PC_SHOWCARET','PC_SHUTDOWN','PC_SUSPENDSTATE','PC_SYSTEMUPFROM','PEEK$','PEEKMESSAGE',
                        'PERMUTATIONS','PI','PIXELS','POKE$','POPUP','POST','PRESERVE','PTR',
                        'QUAD','QUERYPERFORMANCECOUNTER','QUERYPERFORMANCEFREQUENCY','RADTODEG','RANDOMIZE','RAS_BEGINDIAL','RAS_GETENTRY','RAS_HANGUP',
                        'RAS_HANGUPALL','RAS_LOADENTRIES','RAS_OPENDIALUPDIALOG','RAS_SETPARAMS','REDIM','REDRAW','REF','REFERENCE',
                        'REGISTRY_DELKEY','REGISTRY_DELVALUE','REGISTRY_GETALLKEYS','REGISTRY_GETDWORD','REGISTRY_GETTXTBOOL','REGISTRY_GETTXTNUM','REGISTRY_GETVALUE','REGISTRY_SETDWORD',
                        'REGISTRY_SETTXTBOOL','REGISTRY_SETTXTNUM','REGISTRY_SETVALUE','REM','REMOVE$','REPEAT$','REPLACE$','RESOURCE',
                        'RGB','RIGHT','RIGHT$','RND','RNDF','ROUND','RSET$','RTF_APPENDTEXT',
                        'RTF_GETCLASS','RTF_GETEFFECT','RTF_GETFONTNAME','RTF_GETFONTSIZE','RTF_GETTEXT','RTF_LOADFROMFILE','RTF_SAVETOFILE','RTF_SETALIGN',
                        'RTF_SETBGCOLOR','RTF_SETEFFECT','RTF_SETFGCOLOR','RTF_SETFONTNAME','RTF_SETFONTSIZE','RTF_SETTEXT','RTRIM$','SAPI_GETRATE',
                        'SAPI_GETVOLUME','SAPI_MODULELOADED','SAPI_SETRATE','SAPI_SETVOLUME','SAPI_SPEAK','SCAN','SEC','SECH',
                        'SELECT','SELECTESPRESSION','SELECTEXPRESSION','SEND','SENDKEYS','SENDKEYSBULK','SENDMESSAGE','SET',
                        'SGN','SHIFT','SHOW','SIGNED','SIN','SINGLE','SINH','SIZE',
                        'SIZEOF','SLEEP','SMTP_CLOSE','SMTP_CONNECT','SMTP_DEBUG','SMTP_FINISHED','SMTP_GETERROR','SMTP_SENDEMAIL',
                        'SMTP_SENDHTML','SMTP_SETLOGFILE','SMTP_SETOPTION','SMTP_STATISTICS','SORT','SPLIT','SQR','STATE',
                        'STATIC','STAT_CHISQUARE','STAT_CLONEARRAY','STAT_COPYARRAY','STAT_COUNT','STAT_FILLARRAY','STAT_HISTOGRAM','STAT_INVERSESUM',
                        'STAT_MAX','STAT_MEANARITHMETIC','STAT_MEANGEOMETRIC','STAT_MEANHARMONIC','STAT_MEDIAN','STAT_MIN','STAT_PRODUCT','STAT_RANDOM',
                        'STAT_STDDEVIATION','STAT_STDERROR','STAT_SUM','STDIN','STDOUT','STEP','STOP','STR$',
                        'STRDELETE$','STRING','STRING$','STRINSERT$','STRPTR','STRREVERSE$','STRUNZIP$','STRZIP$',
                        'SUB','SWAP','TABCTRL_GETCURSEL','TABCTRL_INSERTITEM','TABCTRL_ONNOTIFY','TALLY','TAN','TANGENT',
                        'TANH','TBGL_BACKCOLOR','TBGL_BEGINPOLY','TBGL_BINDTEXTURE','TBGL_BLENDFUNC','TBGL_BOX','TBGL_BUILDFONT','TBGL_CALLLIST',
                        'TBGL_CAMERA','TBGL_CLEARFRAME','TBGL_COLOR','TBGL_COLORALPHA','TBGL_CREATEWINDOW','TBGL_CYLINDER','TBGL_DELETELIST','TBGL_DESTROYWINDOW',
                        'TBGL_DRAWFRAME','TBGL_ENDLIST','TBGL_ENDPOLY','TBGL_ERRORMESSAGES','TBGL_GETFRAMERATE','TBGL_GETLASTGLERROR','TBGL_GETTEXTURELIST','TBGL_GETTEXTURENAME',
                        'TBGL_KILLFONT','TBGL_LINESTIPPLE','TBGL_LINEWIDTH','TBGL_LOADBMPFONT','TBGL_LOADFONT','TBGL_LOADTEXTURE','TBGL_M15ADDBONETREEITEM','TBGL_M15APPLYBONES',
                        'TBGL_M15CLEARMODEL','TBGL_M15DEFBONEBOX','TBGL_M15DRAWMODEL','TBGL_M15GETMODELVERTEXCOUNT','TBGL_M15GETVERTEXPARAM','TBGL_M15INITMODELBUFFERS','TBGL_M15LOADMODEL','TBGL_M15RECALCNORMALS',
                        'TBGL_M15RESETBONES','TBGL_M15ROTBONE','TBGL_M15SETMODELVERTEXCOUNT','TBGL_M15SETVERTEXPARAM','TBGL_M15SETVERTEXRGB','TBGL_M15SETVERTEXXYZ','TBGL_NEWLIST','TBGL_NORMAL',
                        'TBGL_POINTSIZE','TBGL_POLYGONLOOK','TBGL_POPMATRIX','TBGL_PRINT','TBGL_PRINTBMP','TBGL_PRINTFONT','TBGL_PUSHMATRIX','TBGL_RENDERTOTEXTURE',
                        'TBGL_RESETMATRIX','TBGL_ROTATE','TBGL_ROTATEXYZ','TBGL_SAVESCREENSHOT','TBGL_SCALE','TBGL_SETDRAWDISTANCE','TBGL_SETPRIMITIVEQUALITY','TBGL_SETUPCLIPPLANE',
                        'TBGL_SETUPFOG','TBGL_SETUPLIGHTSOURCE','TBGL_SHOWWINDOW','TBGL_SPHERE','TBGL_TEXCOORD2D','TBGL_TORUS','TBGL_TRANSLATE','TBGL_USEBLEND',
                        'TBGL_USEBLENDFLAG','TBGL_USECLIPPLANE','TBGL_USECLIPPLANEFLAG','TBGL_USEDEPTH','TBGL_USEDEPTHFLAG','TBGL_USEDEPTHMASK','TBGL_USEFOG','TBGL_USEFOGFLAG',
                        'TBGL_USELIGHTING','TBGL_USELIGHTINGFLAG','TBGL_USELIGHTSOURCE','TBGL_USELIGHTSOURCEFLAG','TBGL_USELINESTIPPLE','TBGL_USELINESTIPPLEFLAG','TBGL_USETEXTURE','TBGL_USETEXTUREFLAG',
                        'TBGL_VERTEX','TBGL_VIEWPORT','TCP_CLOSE','TCP_FREEFILE','TCP_LINEINPUT','TCP_OPEN','TCP_PRINT','TCP_RECV',
                        'TCP_SEND','TEXT','TEXTBOX','THEN','TIME$','TIMER','TO','TOKENIZER_GETNEXTTOKEN',
                        'TOKENIZER_MOVETOEOL','TOOLTIP','TRIM$','TRIMFULL$','TYPE','UBOUND','UCASE$','UDP_CLOSE',
                        'UDP_FREEFILE','UDP_OPEN','UDP_OPENSERVER','UDP_RECV','UDP_SEND','UNICODE2ASCII','UNION','UNITS',
                        'UNTIL','USER','USES','USING','USING$','VAL','VALUE','VARIABLE_EXIST',
                        'VARIABLE_EXISTS','VARIABLE_GETINFO','VARIANT','VARIANTVT','VARIANTVT$','VARPTR','VERIFY','WEND',
                        'WHILE','WIN_FINDBYCLASS','WIN_FINDBYTITLE','WIN_FLASH','WIN_GETACTIVE','WIN_GETCLASS','WIN_GETFOREGROUND','WIN_GETTITLE',
                        'WIN_ISICONIC','WIN_ISVISIBLE','WIN_ISZOOMED','WIN_SETFOREGROUND','WIN_SETTITLE','WIN_SHOW','WITH','WORD',
                        'XML_ATTRIBCOUNT','XML_ATTRIBNAME','XML_ATTRIBVALUE','XML_CHILD','XML_CHILDDATA','XML_DECODEPARAM','XML_FINDNODE','XML_FREE',
                        'XML_GETTAG','XML_LASTERROR','XML_NEXTSIBLING','XML_NODETOSTRING','XML_NODETYPE','XML_PARENT','XML_PARSE','XML_PARSEFILE',
                        'XML_TREETOSTRING','XOR','ODBCADDRECORD','ODBCALLOCCONNECT','ODBCALLOCDBC','ODBCALLOCDESC','ODBCALLOCENV','ODBCALLOCHANDLE',
                        'ODBCALLOCSTMT','ODBCBINDCOL','ODBCBINDCOLTOBINARY','ODBCBINDCOLTOBIT','ODBCBINDCOLTOBYTE','ODBCBINDCOLTOCURRENCY','ODBCBINDCOLTODATE','ODBCBINDCOLTODECIMAL',
                        'ODBCBINDCOLTODOUBLE','ODBCBINDCOLTODWORD','ODBCBINDCOLTOINTEGER','ODBCBINDCOLTOLONG','ODBCBINDCOLTONUMERIC','ODBCBINDCOLTOQUAD','ODBCBINDCOLTOSINGLE','ODBCBINDCOLTOSTRING',
                        'ODBCBINDCOLTOTIME','ODBCBINDCOLTOTIMESTAMP','ODBCBINDCOLTOWORD','ODBCBINDPARAMETER','ODBCBROWSECONNECT','ODBCBULKOPERATIONS','ODBCCANCEL','ODBCCLEARRESULT',
                        'ODBCCLOSECONNECTION','ODBCCLOSECURSOR','ODBCCLOSESTMT','ODBCCLOSESTMTCURSOR','ODBCCOLATTRIBUTE','ODBCCOLAUTOUNIQUEVALUE','ODBCCOLBASECOLUMNNAME','ODBCCOLBASETABLENAME',
                        'ODBCCOLCASESENSITIVE','ODBCCOLCATALOGNAME','ODBCCOLCONCISETYPE','ODBCCOLCOUNT','ODBCCOLDISPLAYSIZE','ODBCCOLFIXEDPRECSCALE','ODBCCOLISNULL','ODBCCOLLABEL',
                        'ODBCCOLLENGTH','ODBCCOLLITERALPREFIX','ODBCCOLLITERALSUFFIX','ODBCCOLLOCALTYPENAME','ODBCCOLNAME','ODBCCOLNULLABLE','ODBCCOLNUMPRECRADIX','ODBCCOLOCTETLENGTH',
                        'ODBCCOLPRECISION','ODBCCOLSCALE','ODBCCOLSCHEMANAME','ODBCCOLSEARCHABLE','ODBCCOLTABLENAME','ODBCCOLTYPE','ODBCCOLTYPENAME','ODBCCOLUMN',
                        'ODBCCOLUMNPRIVILEGES','ODBCCOLUMNPRIVILEGESCOUNT','ODBCCOLUMNS','ODBCCOLUMNSCOUNT','ODBCCOLUNNAMED','ODBCCOLUNSIGNED','ODBCCOLUPDATABLE','ODBCCOMMITDBCTRAN',
                        'ODBCCOMMITENVTRAN','ODBCCOMMITTRAN','ODBCCONFIGDATASOURCE','ODBCCONFIGDRIVER','ODBCCONNECT','ODBCCONNECTIONISALIVE','ODBCCONNECTIONISDEAD','ODBCCOPYDESC',
                        'ODBCCREATEDATASOURCE','ODBCDATASOURCES','ODBCDELETEBYBOOKMARK','ODBCDELETERECORD','ODBCDESCRIBECOL','ODBCDESCRIBEPARAM','ODBCDISCONNECT','ODBCDRIVERCONNECT',
                        'ODBCDRIVERS','ODBCDRIVERSCOUNT','ODBCENDTRAN','ODBCEOF','ODBCERROR','ODBCEXECDIRECT','ODBCEXECUTE','ODBCEXTENDEDFETCH',
                        'ODBCFETCH','ODBCFETCHBYBOOKMARK','ODBCFETCHSCROLL','ODBCFOREIGNKEYS','ODBCFOREIGNKEYSCOUNT','ODBCFREECONNECT','ODBCFREEDBC','ODBCFREEDESC',
                        'ODBCFREEENV','ODBCFREEHANDLE','ODBCFREESTMT','ODBCGETACCESSIBLEPROCEDURES','ODBCGETACCESSIBLETABLES','ODBCGETACCESSMODE','ODBCGETACTIVEENVIRONMENTS','ODBCGETAGGREGATEFUNCTIONS',
                        'ODBCGETALTERDOMAIN','ODBCGETALTERTABLE','ODBCGETASYNCENABLE','ODBCGETASYNCMODE','ODBCGETAUTOCOMMIT','ODBCGETAUTOIPD','ODBCGETBATCHROWCOUNT','ODBCGETBATCHSUPPORT',
                        'ODBCGETBOOKMARKPERSISTENCE','ODBCGETCATALOGLOCATION','ODBCGETCATALOGNAME','ODBCGETCATALOGNAMESEPARATOR','ODBCGETCATALOGTERM','ODBCGETCATALOGUSAGE','ODBCGETCOLLATIONSEQ','ODBCGETCOLUMNALIAS',
                        'ODBCGETCONCATNULLBEHAVIOR','ODBCGETCONFIGMODE','ODBCGETCONNECTATTR','ODBCGETCONNECTIONDEAD','ODBCGETCONNECTIONERRORINFO','ODBCGETCONNECTIONSQLSTATE','ODBCGETCONNECTIONTIMEOUT','ODBCGETCONVERTBIGINT',
                        'ODBCGETCONVERTBINARY','ODBCGETCONVERTBIT','ODBCGETCONVERTCHAR','ODBCGETCONVERTDATE','ODBCGETCONVERTDECIMAL','ODBCGETCONVERTDOUBLE','ODBCGETCONVERTFLOAT','ODBCGETCONVERTFUNCTIONS',
                        'ODBCGETCONVERTINTEGER','ODBCGETCONVERTINTERVALDAYTIME','ODBCGETCONVERTINTERVALYEARMONTH','ODBCGETCONVERTLONGVARBINARY','ODBCGETCONVERTLONGVARCHAR','ODBCGETCONVERTNUMERIC','ODBCGETCONVERTREAL','ODBCGETCONVERTSMALLINT',
                        'ODBCGETCONVERTTIME','ODBCGETCONVERTTIMESTAMP','ODBCGETCONVERTTINYINT','ODBCGETCONVERTVARBINARY','ODBCGETCONVERTVARCHAR','ODBCGETCORRELATIONNAME','ODBCGETCREATEASSERTION','ODBCGETCREATECHARACTERSET',
                        'ODBCGETCREATECOLLATION','ODBCGETCREATEDOMAIN','ODBCGETCREATESCHEMA','ODBCGETCREATETABLE','ODBCGETCREATETRANSLATION','ODBCGETCREATEVIEW','ODBCGETCURRENTCATALOG','ODBCGETCURSORCOMMITBEHAVIOR',
                        'ODBCGETCURSORCONCURRENCY','ODBCGETCURSORKEYSETSIZE','ODBCGETCURSORLOCKTYPE','ODBCGETCURSORNAME','ODBCGETCURSORROLLBACKBEHAVIOR','ODBCGETCURSORSCROLLABILITY','ODBCGETCURSORSENSITIVITY','ODBCGETCURSORSENSITIVITYSUPPORT',
                        'ODBCGETCURSORTYPE','ODBCGETDATA','ODBCGETDATABASENAME','ODBCGETDATAEXTENSIONS','ODBCGETDATASOURCENAME','ODBCGETDATASOURCEREADONLY','ODBCGETDATASTRING','ODBCGETDATASTRINGBYCOLNAME',
                        'ODBCGETDATETIMELITERALS','ODBCGETDBCERRORINFO','ODBCGETDBCSQLSTATE','ODBCGETDBMSNAME','ODBCGETDBMSVER','ODBCGETDDLINDEX','ODBCGETDEFAULTTXNISOLATION','ODBCGETDESCERRORINFO',
                        'ODBCGETDESCFIELD','ODBCGETDESCREC','ODBCGETDESCRIBEPARAMETER','ODBCGETDESCRIPTORERRORINFO','ODBCGETDESCRIPTORSQLSTATE','ODBCGETDESCSQLSTATE','ODBCGETDIAGFIELD','ODBCGETDIAGREC',
                        'ODBCGETDMVER','ODBCGETDMVERMAJOR','ODBCGETDMVERMINOR','ODBCGETDRIVERHDBC','ODBCGETDRIVERHENV','ODBCGETDRIVERHLIB','ODBCGETDRIVERMANAGERINSTALLPATH','ODBCGETDRIVERNAME',
                        'ODBCGETDRIVERODBCVER','ODBCGETDRIVERVER','ODBCGETDROPASSERTION','ODBCGETDROPCHARACTERSET','ODBCGETDROPCOLLATION','ODBCGETDROPDOMAIN','ODBCGETDROPSCHEMA','ODBCGETDROPTABLE',
                        'ODBCGETDROPTRANSLATION','ODBCGETDROPVIEW','ODBCGETDYNAMICCURSORATTRIBUTES1','ODBCGETDYNAMICCURSORATTRIBUTES2','ODBCGETENVATTR','ODBCGETENVCONNECTIONPOOLING','ODBCGETENVCPMATCH','ODBCGETENVERRORINFO',
                        'ODBCGETENVIRONMENTERRORINFO','ODBCGETENVIRONMENTSQLSTATE','ODBCGETENVODBCVERSION','ODBCGETENVOUTPUTNTS','ODBCGETENVSQLSTATE','ODBCGETERRORINFO','ODBCGETEXPRESSIONSINORDERBY','ODBCGETFILEUSAGE',
                        'ODBCGETFORWARDONLYCURSORATTRIBUTES1','ODBCGETFORWARDONLYCURSORATTRIBUTES2','ODBCGETFUNCTIONS','ODBCGETGROUPBY','ODBCGETIDENTIFIERCASE','ODBCGETIDENTIFIERQUOTECHAR','ODBCGETIMPPARAMDESCFIELD','ODBCGETIMPPARAMDESCFIELDNAME',
                        'ODBCGETIMPPARAMDESCFIELDNULLABLE','ODBCGETIMPPARAMDESCFIELDOCTETLENGTH','ODBCGETIMPPARAMDESCFIELDPRECISION','ODBCGETIMPPARAMDESCFIELDSCALE','ODBCGETIMPPARAMDESCFIELDTYPE','ODBCGETIMPPARAMDESCREC','ODBCGETIMPROWDESCFIELD','ODBCGETIMPROWDESCFIELDNAME',
                        'ODBCGETIMPROWDESCFIELDNULLABLE','ODBCGETIMPROWDESCFIELDOCTETLENGTH','ODBCGETIMPROWDESCFIELDPRECISION','ODBCGETIMPROWDESCFIELDSCALE','ODBCGETIMPROWDESCFIELDTYPE','ODBCGETIMPROWDESCREC','ODBCGETINDEXKEYWORDS','ODBCGETINFO',
                        'ODBCGETINFOINT','ODBCGETINFOLONG','ODBCGETINFOSCHEMAVIEWS','ODBCGETINFOSTR','ODBCGETINSERTSTATEMENT','ODBCGETINSTALLEDDRIVERS','ODBCGETINSTALLERERRORCODE','ODBCGETINSTALLERERRORMESSAGE',
                        'ODBCGETINTEGRITY','ODBCGETKEYSETCURSORATTRIBUTES1','ODBCGETKEYSETCURSORATTRIBUTES2','ODBCGETKEYWORDS','ODBCGETLIKEESCAPECLAUSE','ODBCGETLOGINTIMEOUT','ODBCGETLONGVARCHARDATA','ODBCGETLONGVARCHARDATABYCOLNAME',
                        'ODBCGETMAXASYNCCONCURRENTSTATEMENTS','ODBCGETMAXBINARYLITERALLEN','ODBCGETMAXCATALOGNAMELEN','ODBCGETMAXCHARLITERALLEN','ODBCGETMAXCOLUMNNAMELEN','ODBCGETMAXCOLUMNSINGROUPBY','ODBCGETMAXCOLUMNSININDEX','ODBCGETMAXCOLUMNSINORDERBY',
                        'ODBCGETMAXCOLUMNSINSELECT','ODBCGETMAXCOLUMNSINTABLE','ODBCGETMAXCONCURRENTACTIVITIES','ODBCGETMAXCURSORNAMELEN','ODBCGETMAXDRIVERCONNECTIONS','ODBCGETMAXIDENTIFIERLEN','ODBCGETMAXINDEXSIZE','ODBCGETMAXPROCEDURENAMELEN',
                        'ODBCGETMAXROWSIZE','ODBCGETMAXROWSIZEINCLUDESLONG','ODBCGETMAXSCHEMANAMELEN','ODBCGETMAXSTATEMENTLEN','ODBCGETMAXTABLENAMELEN','ODBCGETMAXTABLESINSELECT','ODBCGETMAXUSERNAMELEN','ODBCGETMETADATAID',
                        'ODBCGETMULTIPLEACTIVETXN','ODBCGETMULTRESULTSETS','ODBCGETNEEDLONGDATALEN','ODBCGETNONNULLABLECOLUMNS','ODBCGETNULLCOLLATION','ODBCGETNUMERICFUNCTIONS','ODBCGETODBCCURSORS','ODBCGETODBCINTERFACECONFORMANCE',
                        'ODBCGETODBCVER','ODBCGETOJCAPABILITIES','ODBCGETORDERBYCOLUMNSINSELECT','ODBCGETOUTERJOINS','ODBCGETPACKETMODE','ODBCGETPARAMARRAYROWCOUNTS','ODBCGETPARAMARRAYSELECTS','ODBCGETPOSOPERATIONS',
                        'ODBCGETPRIVATEPROFILESTRING','ODBCGETPROCEDURESSUPPORT','ODBCGETPROCEDURETERM','ODBCGETQUIETMODE','ODBCGETROWUPDATES','ODBCGETSCHEMATERM','ODBCGETSCHEMAUSAGE','ODBCGETSCROLLOPTIONS',
                        'ODBCGETSEARCHPATTERNESCAPE','ODBCGETSERVERNAME','ODBCGETSPECIALCHARACTERS','ODBCGETSQL92DATETIMEFUNCTIONS','ODBCGETSQL92FOREIGNKEYDELETERULE','ODBCGETSQL92FOREIGNKEYUPDATERULE','ODBCGETSQL92GRANT','ODBCGETSQL92NUMERICVALUEFUNCTIONS',
                        'ODBCGETSQL92PREDICATES','ODBCGETSQL92RELATIONALJOINOPERATORS','ODBCGETSQL92REVOKE','ODBCGETSQL92ROWVALUECONSTRUCTOR','ODBCGETSQL92STRINGFUNCTIONS','ODBCGETSQL92VALUEEXPRESSIONS','ODBCGETSQLCONFORMANCE','ODBCGETSQLSTATE',
                        'ODBCGETSTANDARDCLICONFORMANCE','ODBCGETSTATEMENTERRORINFO','ODBCGETSTATEMENTSQLSTATE','ODBCGETSTATICCURSORATTRIBUTES1','ODBCGETSTATICCURSORATTRIBUTES2','ODBCGETSTMTAPPPARAMDESC','ODBCGETSTMTAPPROWDESC','ODBCGETSTMTASYNCENABLE',
                        'ODBCGETSTMTATTR','ODBCGETSTMTCONCURRENCY','ODBCGETSTMTCURSORSCROLLABLE','ODBCGETSTMTCURSORSENSITIVITY','ODBCGETSTMTCURSORTYPE','ODBCGETSTMTENABLEAUTOIPD','ODBCGETSTMTERRORINFO','ODBCGETSTMTFETCHBOOKMARKPTR',
                        'ODBCGETSTMTIMPPARAMDESC','ODBCGETSTMTIMPROWDESC','ODBCGETSTMTKEYSETSIZE','ODBCGETSTMTMAXLENGTH','ODBCGETSTMTMAXROWS','ODBCGETSTMTMETADATAID','ODBCGETSTMTNOSCAN','ODBCGETSTMTPARAMBINDOFFSETPTR',
                        'ODBCGETSTMTPARAMBINDTYPE','ODBCGETSTMTPARAMOPERATIONPTR','ODBCGETSTMTPARAMSETSIZE','ODBCGETSTMTPARAMSPROCESSEDPTR','ODBCGETSTMTPARAMSTATUSPTR','ODBCGETSTMTQUERYTIMEOUT','ODBCGETSTMTRETRIEVEDATA','ODBCGETSTMTROWARRAYSIZE',
                        'ODBCGETSTMTROWBINDOFFSETPTR','ODBCGETSTMTROWBINDTYPE','ODBCGETSTMTROWNUMBER','ODBCGETSTMTROWOPERATIONPTR','ODBCGETSTMTROWSFETCHEDPTR','ODBCGETSTMTROWSTATUSPTR','ODBCGETSTMTSIMULATECURSOR','ODBCGETSTMTSQLSTATE',
                        'ODBCGETSTMTUSEBOOKMARKS','ODBCGETSTRINGFUNCTIONS','ODBCGETSUBQUERIES','ODBCGETSYSTEMFUNCTIONS','ODBCGETTABLETERM','ODBCGETTIMEDATEADDINTERVALS','ODBCGETTIMEDATEDIFFINTERVALS','ODBCGETTIMEDATEFUNCTIONS',
                        'ODBCGETTRACE','ODBCGETTRACEFILE','ODBCGETTRANSLATELIB','ODBCGETTRANSLATOR','ODBCGETTXNCAPABLE','ODBCGETTXNISOLATION','ODBCGETTXNISOLATIONOPTION','ODBCGETTYPEINFO',
                        'ODBCGETTYPEINFOCOUNT','ODBCGETUNION','ODBCGETUSERNAME','ODBCGETXOPENCLIYEAR','ODBCINSTALLDRIVEREX','ODBCINSTALLDRIVERMANAGER','ODBCINSTALLERERROR','ODBCINSTALLTRANSLATOREX',
                        'ODBCLOCKRECORD','ODBCMANAGEDATASOURCES','ODBCMORERESULTS','ODBCMOVE','ODBCMOVEFIRST','ODBCMOVELAST','ODBCMOVENEXT','ODBCMOVEPREVIOUS',
                        'ODBCNATIVESQL','ODBCNUMPARAMS','ODBCNUMRESULTCOLS','ODBCOPENCONNECTION','ODBCOPENSTMT','ODBCPARAMDATA','ODBCPOSTINSTALLERERROR','ODBCPREPARE',
                        'ODBCPRIMARYKEYS','ODBCPRIMARYKEYSCOUNT','ODBCPROCEDURECOLUMNS','ODBCPROCEDURECOLUMNSCOUNT','ODBCPROCEDURES','ODBCPROCEDURESCOUNT','ODBCPUTDATA','ODBCQUOTEDIDENTIFIERCASE',
                        'ODBCREADFILEDSN','ODBCRECORDCOUNT','ODBCREFRESHRECORD','ODBCREMOVEDRIVER','ODBCREMOVEDRIVERMANAGER','ODBCREMOVEDSNFROMINI','ODBCREMOVETRANSLATOR','ODBCRESETPARAMS',
                        'ODBCRESULT','ODBCROLLBACKDBCTRAN','ODBCROLLBACKENVTRAN','ODBCROLLBACKTRAN','ODBCROWCOUNT','ODBCSETABSOLUTEPOSITION','ODBCSETACCESSMODE','ODBCSETASYNCENABLE',
                        'ODBCSETAUTOCOMMIT','ODBCSETAUTOCOMMITOFF','ODBCSETAUTOCOMMITON','ODBCSETCONCURVALUESCONCURRENCY','ODBCSETCONFIGMODE','ODBCSETCONNECTATTR','ODBCSETCONNECTIONTIMEOUT','ODBCSETCURRENTCATALOG',
                        'ODBCSETCURSORCONCURRENCY','ODBCSETCURSORKEYSETSIZE','ODBCSETCURSORLOCKTYPE','ODBCSETCURSORNAME','ODBCSETCURSORSCROLLABILITY','ODBCSETCURSORSENSITIVITY','ODBCSETCURSORTYPE','ODBCSETDESCFIELD',
                        'ODBCSETDESCREC','ODBCSETDYNAMICCURSOR','ODBCSETENVATTR','ODBCSETENVCONNECTIONPOOLING','ODBCSETENVCPMATCH','ODBCSETENVODBCVERSION','ODBCSETENVOUTPUTNTS','ODBCSETFORWARDONLYCURSOR',
                        'ODBCSETKEYSETDRIVENCURSOR','ODBCSETLOCKCONCURRENCY','ODBCSETLOGINTIMEOUT','ODBCSETMETADATAID','ODBCSETMULTIUSERKEYSETCURSOR','ODBCSETODBCCURSORS','ODBCSETOPTIMISTICCONCURRENCY','ODBCSETPACKETMODE',
                        'ODBCSETPOS','ODBCSETPOSITION','ODBCSETQUIETMODE','ODBCSETREADONLYCONCURRENCY','ODBCSETRELATIVEPOSITION','ODBCSETRESULT','ODBCSETROWVERCONCURRENCY','ODBCSETSTATICCURSOR',
                        'ODBCSETSTMTAPPPARAMDESC','ODBCSETSTMTAPPROWDESC','ODBCSETSTMTASYNCENABLE','ODBCSETSTMTATTR','ODBCSETSTMTCONCURRENCY','ODBCSETSTMTCURSORSCROLLABLE','ODBCSETSTMTCURSORSENSITIVITY','ODBCSETSTMTCURSORTYPE',
                        'ODBCSETSTMTENABLEAUTOIPD','ODBCSETSTMTFETCHBOOKMARKPTR','ODBCSETSTMTKEYSETSIZE','ODBCSETSTMTMAXLENGTH','ODBCSETSTMTMAXROWS','ODBCSETSTMTMETADATAID','ODBCSETSTMTNOSCAN','ODBCSETSTMTPARAMBINDOFFSETPTR',
                        'ODBCSETSTMTPARAMBINDTYPE','ODBCSETSTMTPARAMOPERATIONPTR','ODBCSETSTMTPARAMSETSIZE','ODBCSETSTMTPARAMSPROCESSEDPTR','ODBCSETSTMTPARAMSTATUSPTR','ODBCSETSTMTQUERYTIMEOUT','ODBCSETSTMTRETRIEVEDATA','ODBCSETSTMTROWARRAYSIZE',
                        'ODBCSETSTMTROWBINDOFFSETPTR','ODBCSETSTMTROWBINDTYPE','ODBCSETSTMTROWOPERATIONPTR','ODBCSETSTMTROWSFETCHEDPTR','ODBCSETSTMTROWSTATUSPTR','ODBCSETSTMTSIMULATECURSOR','ODBCSETSTMTUSEBOOKMARKS','ODBCSETTRACE',
                        'ODBCSETTRACEFILE','ODBCSETTRANSLATELIB','ODBCSETTXNISOLATION','ODBCSPECIALCOLUMNS','ODBCSPECIALCOLUMNSCOUNT','ODBCSTATINDEXALLOWDUPLICATES','ODBCSTATINDEXCARDINALITY','ODBCSTATINDEXCATALOGNAME',
                        'ODBCSTATINDEXCOLUMNNAME','ODBCSTATINDEXCOLUMNORDINALPOSITION','ODBCSTATINDEXFILTERCONDITION','ODBCSTATINDEXPAGES','ODBCSTATINDEXQUALIFIER','ODBCSTATINDEXSCHEMANAME','ODBCSTATINDEXSORTSEQUENCE','ODBCSTATISTICS',
                        'ODBCSTATISTICSCOUNT','ODBCSTATTABLECARDINALITY','ODBCSTATTABLECATALOGNAME','ODBCSTATTABLEPAGES','ODBCSTATTABLESCHEMANAME','ODBCSUPPORTS','ODBCTABLEPRIVILEGES','ODBCTABLEPRIVILEGESCOUNT',
                        'ODBCTABLES','ODBCTABLESCOUNT','ODBCUNBINDCOL','ODBCUNBINDCOLUMNS','ODBCUNLOCKRECORD','ODBCUPDATEBYBOOKMARK','ODBCUPDATERECORD','ODBCVALIDDSN',
                        'ODBCWRITEDSNTOINI','ODBCWRITEFILEDSN','ODBCWRITEPRIVATEPROFILESTRING','ODBCWRONGDRIVER','SQLALLOCCONNECT','SQLALLOCENV','SQLALLOCHANDLE','SQLALLOCSTMT',
                        'SQLBINDCOL','SQLBINDPARAM','SQLBINDPARAMETER','SQLBROWSECONNECT','SQLBULKOPERATIONS','SQLCANCEL','SQLCLOSECURSOR','SQLCOLATTRIBUTE',
                        'SQLCOLATTRIBUTES','SQLCOLUMNPRIVILEGES','SQLCOLUMNS','SQLCONFIGDATASOURCE','SQLCONFIGDRIVER','SQLCONNECT','SQLCOPYDESC','SQLCREATEDATASOURCE',
                        'SQLDATASOURCES','SQLDESCRIBECOL','SQLDESCRIBEPARAM','SQLDISCONNECT','SQLDRIVERCONNECT','SQLDRIVERS','SQLENDTRAN','SQLERROR',
                        'SQLEXECDIRECT','SQLEXECUTE','SQLEXTENDEDFETCH','SQLFETCH','SQLFETCHSCROLL','SQLFOREIGNKEYS','SQLFREECONNECT','SQLFREEENV',
                        'SQLFREEHANDLE','SQLFREESTMT','SQLGETCONFIGMODE','SQLGETCONNECTATTR','SQLGETCONNECTOPTION','SQLGETCURSORNAME','SQLGETDATA','SQLGETDESCFIELD',
                        'SQLGETDESCREC','SQLGETDIAGFIELD','SQLGETDIAGREC','SQLGETENVATTR','SQLGETFUNCTIONS','SQLGETINFO','SQLGETINSTALLEDDRIVERS','SQLGETPRIVATEPROFILESTRING',
                        'SQLGETSTMTATTR','SQLGETSTMTOPTION','SQLGETTRANSLATOR','SQLGETTYPEINFO','SQLINSTALLDRIVEREX','SQLINSTALLDRIVERMANAGER','SQLINSTALLERERROR','SQLINSTALLTRANSLATOREX',
                        'SQLMANAGEDATASOURCES','SQLMORERESULTS','SQLNATIVESQL','SQLNUMPARAMS','SQLNUMRESULTCOLS','SQLPARAMDATA','SQLPARAMOPTIONS','SQLPOSTINSTALLERERROR',
                        'SQLPREPARE','SQLPRIMARYKEYS','SQLPROCEDURECOLUMNS','SQLPROCEDURES','SQLPUTDATA','SQLREADFILEDSN','SQLREMOVEDRIVER','SQLREMOVEDRIVERMANAGER',
                        'SQLREMOVEDSNFROMINI','SQLREMOVETRANSLATOR','SQLROWCOUNT','SQLSETCONFIGMODE','SQLSETCONNECTATTR','SQLSETCONNECTOPTION','SQLSETCURSORNAME','SQLSETDESCFIELD',
                        'SQLSETDESCREC','SQLSETENVATTR','SQLSETPARAM','SQLSETPOS','SQLSETSCROLLOPTIONS','SQLSETSTMTATTR','SQLSETSTMTOPTION','SQLSPECIALCOLUMNS',
                        'SQLSTATISTICS','SQLTABLEPRIVILEGES','SQLTABLES','SQLTRANSACT','SQLVALIDDSN','SQLWRITEDSNTOINI','SQLWRITEFILEDSN','SQLWRITEPRIVATEPROFILESTRING'
                        ),
                2 => array(
                        '$BEL','$BS','$CR','$CRLF','$DQ','$DT_DATE_SEPARATOR','$DT_LANGUAGE','$DT_TIME_SEPARATOR',
                        '$ESC','$FF','$LF','$NUL','$PC_SD_MY_PC','$SPC','$SQL_OPT_TRACE_FILE_DEFAULT','$SQL_SPEC_STRING',
                        '$TAB','$VT','%ACM_OPEN','%ACM_OPENW','%ACM_PLAY','%ACM_STOP','%ACN_START','%ACN_STOP',
                        '%ACS_AUTOPLAY','%ACS_CENTER','%ACS_TIMER','%ACS_TRANSPARENT','%ADCMDFILE','%ADCMDSTOREDPROC','%ADCMDTABLE','%ADCMDTABLEDIRECT',
                        '%ADCMDTEXT','%ADCMDUNKNOWN','%ADCMDUNSPECIFIED','%ADLOCKBATCHOPTIMISTIC','%ADLOCKOPTIMISTIC','%ADLOCKPESSIMISTIC','%ADLOCKREADONLY','%ADLOCKUNSPECIFIED',
                        '%ADOPENDYNAMIC','%ADOPENFORWARDONLY','%ADOPENKEYSET','%ADOPENSTATIC','%ADOPENUNSPECIFIED','%APP_COUNTER_FUNLOOKUP','%APP_COUNTER_KEYLOOKUP','%APP_COUNTER_LOOKUP',
                        '%APP_COUNTER_TESTALPHA','%APP_COUNTER_UDTLOOKUP','%APP_COUNTER_VARLOOKUP','%APP_TIMER_EXECTOTAL','%APP_TIMER_INIT','%APP_TIMER_LOAD','%APP_TIMER_PREPROCESSOR','%AW_ACTIVATE',
                        '%AW_BLEND','%AW_CENTER','%AW_HIDE','%AW_HOR_NEGATIVE','%AW_HOR_POSITIVE','%AW_SLIDE','%AW_VER_NEGATIVE','%AW_VER_POSITIVE',
                        '%BCM_FIRST','%BLACK','%BLUE','%BM_GETCHECK','%BM_SETCHECK','%BST_CHECKED','%BST_UNCHECKED','%BS_AUTOCHECKBOX',
                        '%BS_BOTTOM','%BS_CENTER','%BS_DEFAULT','%BS_DEFPUSHBUTTON','%BS_FLAT','%BS_LEFT','%BS_LEFTTEXT','%BS_MULTILINE',
                        '%BS_NOTIFY','%BS_PUSHLIKE','%BS_RIGHT','%BS_TOP','%BS_VCENTER','%CBM_FIRST','%CBN_SELENDOK','%CBS_AUTOHSCROLL',
                        '%CBS_DISABLENOSCROLL','%CBS_DROPDOWN','%CBS_DROPDOWNLIST','%CBS_HASSTRINGS','%CBS_LOWERCASE','%CBS_NOINTEGRALHEIGHT','%CBS_SIMPLE','%CBS_SORT',
                        '%CBS_UPPERCASE','%CB_SELECTSTRING','%CCM_FIRST','%CC_ANYCOLOR','%CC_ENABLEHOOK','%CC_ENABLETEMPLATE','%CC_ENABLETEMPLATEHANDLE','%CC_FULLOPEN',
                        '%CC_PREVENTFULLOPEN','%CC_RGBINIT','%CC_SHOWHELP','%CC_SOLIDCOLOR','%CFE_BOLD','%CFE_ITALIC','%CFE_LINK','%CFE_PROTECTED',
                        '%CFE_STRIKEOUT','%CFE_UNDERLINE','%CFM_ANIMATION','%CFM_BACKCOLOR','%CFM_BOLD','%CFM_CHARSET','%CFM_COLOR','%CFM_FACE',
                        '%CFM_ITALIC','%CFM_KERNING','%CFM_LCID','%CFM_LINK','%CFM_OFFSET','%CFM_PROTECTED','%CFM_REVAUTHOR','%CFM_SIZE',
                        '%CFM_SPACING','%CFM_STRIKEOUT','%CFM_STYLE','%CFM_UNDERLINE','%CFM_UNDERLINETYPE','%CFM_WEIGHT','%CGI_ACCEPT_FILE_UPLOAD','%CGI_AUTO_ADD_SPECIAL_CHARS_PREFIX',
                        '%CGI_AUTO_CREATE_VARS','%CGI_BUFFERIZE_OUTPUT','%CGI_DOUBLE_QUOTE','%CGI_FILE_UPLOAD_BASEPATH','%CGI_FORCE_SESSION_VALIDATION','%CGI_MAX_BYTE_FROM_STD_IN','%CGI_REQUEST_METHOD_GET','%CGI_REQUEST_METHOD_POST',
                        '%CGI_SESSION_FILE_BASEPATH','%CGI_SINGLE_QUOTE','%CGI_SPECIAL_CHARS_PREFIX','%CGI_TEMPORARY_UPLOAD_PATH','%CGI_UPLOAD_CAN_OVERWRITE','%CGI_WRITE_LOG_FILE','%CGI_WRITE_VARS_INTO_LOG_FILE','%CONOLE_ATTACH_PARENT_PROCESS',
                        '%CONSOLE_BACKGROUND_BLUE','%CONSOLE_BACKGROUND_GREEN','%CONSOLE_BACKGROUND_INTENSITY','%CONSOLE_BACKGROUND_RED','%CONSOLE_BOX_FLAG_3DOFF','%CONSOLE_BOX_FLAG_3DON','%CONSOLE_BOX_FLAG_SHADOW','%CONSOLE_COMMON_LVB_GRID_HORIZONTAL',
                        '%CONSOLE_COMMON_LVB_GRID_LVERTICAL','%CONSOLE_COMMON_LVB_GRID_RVERTICAL','%CONSOLE_COMMON_LVB_LEADING_BYTE','%CONSOLE_COMMON_LVB_REVERSE_VIDEO','%CONSOLE_COMMON_LVB_TRAILING_BYTE','%CONSOLE_COMMON_LVB_UNDERSCORE','%CONSOLE_CTRL_BREAK_EVENT','%CONSOLE_CTRL_C_EVENT',
                        '%CONSOLE_DOUBLE_CLICK','%CONSOLE_ENABLE_AUTO_POSITION','%CONSOLE_ENABLE_ECHO_INPUT','%CONSOLE_ENABLE_EXTENDED_FLAGS','%CONSOLE_ENABLE_INSERT_MODE','%CONSOLE_ENABLE_LINE_INPUT','%CONSOLE_ENABLE_MOUSE_INPUT','%CONSOLE_ENABLE_PROCESSED_INPUT',
                        '%CONSOLE_ENABLE_PROCESSED_OUTPUT','%CONSOLE_ENABLE_QUICK_EDIT_MODE','%CONSOLE_ENABLE_WINDOW_INPUT','%CONSOLE_ENABLE_WRAP_AT_EOL_OUTPUT','%CONSOLE_FOREGROUND_BLUE','%CONSOLE_FOREGROUND_GREEN','%CONSOLE_FOREGROUND_INTENSITY','%CONSOLE_FOREGROUND_RED',
                        '%CONSOLE_LBUTTON','%CONSOLE_MBUTTON','%CONSOLE_MOUSE_MOVED','%CONSOLE_MOUSE_WHEELED','%CONSOLE_RBUTTON','%CONSOLE_SCROLLBUF_DOWN','%CONSOLE_SCROLLBUF_UP','%CONSOLE_SCROLLWND_ABSOLUTE',
                        '%CONSOLE_SCROLLWND_RELATIVE','%CONSOLE_STD_ERROR_HANDLE','%CONSOLE_STD_INPUT_HANDLE','%CONSOLE_STD_OUTPUT_HANDLE','%CONSOLE_SW_FORCEMINIMIZE','%CONSOLE_SW_HIDE','%CONSOLE_SW_MAXIMIZE','%CONSOLE_SW_MINIMIZE',
                        '%CONSOLE_SW_RESTORE','%CONSOLE_SW_SHOW','%CONSOLE_SW_SHOWDEFAULT','%CONSOLE_SW_SHOWMAXIMIZED','%CONSOLE_SW_SHOWMINIMIZED','%CONSOLE_SW_SHOWMINNOACTIVE','%CONSOLE_SW_SHOWNA','%CONSOLE_SW_SHOWNOACTIVATE',
                        '%CONSOLE_SW_SHOWNORMAL','%CONSOLE_UNAVAILABLE','%CRYPTO_CALG_DES','%CRYPTO_CALG_RC2','%CRYPTO_CALG_RC4','%CRYPTO_PROV_DH_SCHANNEL','%CRYPTO_PROV_DSS','%CRYPTO_PROV_DSS_DH',
                        '%CRYPTO_PROV_FORTEZZA','%CRYPTO_PROV_MS_EXCHANGE','%CRYPTO_PROV_RSA_FULL','%CRYPTO_PROV_RSA_SCHANNEL','%CRYPTO_PROV_RSA_SIG','%CRYPTO_PROV_SSL','%CSIDL_ADMINTOOLS','%CSIDL_ALTSTARTUP',
                        '%CSIDL_APPDATA','%CSIDL_BITBUCKET','%CSIDL_CDBURN_AREA','%CSIDL_COMMON_ADMINTOOLS','%CSIDL_COMMON_ALTSTARTUP','%CSIDL_COMMON_APPDATA','%CSIDL_COMMON_DESKTOPDIRECTORY','%CSIDL_COMMON_DOCUMENTS',
                        '%CSIDL_COMMON_FAVORITES','%CSIDL_COMMON_MUSIC','%CSIDL_COMMON_PICTURES','%CSIDL_COMMON_PROGRAMS','%CSIDL_COMMON_STARTMENU','%CSIDL_COMMON_STARTUP','%CSIDL_COMMON_TEMPLATES','%CSIDL_COMMON_VIDEO',
                        '%CSIDL_CONTROLS','%CSIDL_COOKIES','%CSIDL_DESKTOP','%CSIDL_DESKTOPDIRECTORY','%CSIDL_DRIVES','%CSIDL_FAVORITES','%CSIDL_FLAG_CREATE','%CSIDL_FONTS',
                        '%CSIDL_HISTORY','%CSIDL_INTERNET','%CSIDL_INTERNET_CACHE','%CSIDL_LOCAL_APPDATA','%CSIDL_MYDOCUMENTS','%CSIDL_MYMUSIC','%CSIDL_MYPICTURES','%CSIDL_MYVIDEO',
                        '%CSIDL_NETHOOD','%CSIDL_NETWORK','%CSIDL_PERSONAL','%CSIDL_PRINTERS','%CSIDL_PRINTHOOD','%CSIDL_PROFILE','%CSIDL_PROGRAMS','%CSIDL_PROGRAM_FILES',
                        '%CSIDL_PROGRAM_FILES_COMMON','%CSIDL_RECENT','%CSIDL_SENDTO','%CSIDL_STARTMENU','%CSIDL_STARTUP','%CSIDL_SYSTEM','%CSIDL_TEMPLATES','%CSIDL_WINDOWS',
                        '%CW_USEDEFAULT','%CYAN','%DATE_TIME_FILE_CREATION','%DATE_TIME_LAST_FILE_ACCESS','%DATE_TIME_LAST_FILE_WRITE','%DS_3DLOOK','%DS_ABSALIGN','%DS_CENTER',
                        '%DS_CENTERMOUSE','%DS_CONTEXTHELP','%DS_CONTROL','%DS_MODALFRAME','%DS_NOFAILCREATE','%DS_SETFONT','%DS_SETFOREGROUND','%DS_SYSMODAL',
                        '%DTM_FIRST','%DTM_GETMCCOLOR','%DTM_GETMCFONT','%DTM_GETMONTHCAL','%DTM_GETRANGE','%DTM_GETSYSTEMTIME','%DTM_SETFORMAT','%DTM_SETFORMATW',
                        '%DTM_SETMCCOLOR','%DTM_SETMCFONT','%DTM_SETRANGE','%DTM_SETSYSTEMTIME','%DTN_CLOSEUP','%DTN_DATETIMECHANGE','%DTN_DROPDOWN','%DTN_FORMAT',
                        '%DTN_FORMATQUERY','%DTN_FORMATQUERYW','%DTN_FORMATW','%DTN_USERSTRING','%DTN_USERSTRINGW','%DTN_WMKEYDOWN','%DTN_WMKEYDOWNW','%DTS_APPCANPARSE',
                        '%DTS_LONGDATEFORMAT','%DTS_RIGHTALIGN','%DTS_SHORTDATECENTURYFORMAT','%DTS_SHORTDATEFORMAT','%DTS_SHOWNONE','%DTS_TIMEFORMAT','%DTS_UPDOWN','%DT_DATE_CENTURY',
                        '%DT_DATE_OK','%DT_DAY_IN_YEAR','%DT_DIFF_IN_DAYS','%DT_DIFF_IN_HOURS','%DT_DIFF_IN_MINUTES','%DT_DIFF_IN_SECONDS','%DT_HOURS_IN_DAY','%DT_MINUTES_IN_HOUR',
                        '%DT_SECONDS_IN_DAY','%DT_SECONDS_IN_HOUR','%DT_SECONDS_IN_MINUTE','%DT_SECONDS_IN_YEAR','%DT_USE_LONG_FORM','%DT_USE_SHORT_FORM','%DT_WRONG_DATE','%DT_WRONG_DAY',
                        '%DT_WRONG_MONTH','%ECM_FIRST','%ECOOP_AND','%ECOOP_OR','%ECOOP_SET','%ECOOP_XOR','%ECO_AUTOHSCROLL','%ECO_AUTOVSCROLL',
                        '%ECO_AUTOWORDSELECTION','%ECO_NOHIDESEL','%ECO_READONLY','%ECO_SELECTIONBAR','%ECO_WANTRETURN','%EM_CANPASTE','%EM_CANREDO','%EM_CANUNDO',
                        '%EM_CHARFROMPOS','%EM_DISPLAYBAND','%EM_EMPTYUNDOBUFFER','%EM_EXGETSEL','%EM_EXLIMITTEXT','%EM_EXLINEFROMCHAR','%EM_EXSETSEL','%EM_FINDTEXT',
                        '%EM_FINDTEXTEX','%EM_FINDWORDBREAK','%EM_FMTLINES','%EM_FORMATRANGE','%EM_GETCHARFORMAT','%EM_GETEDITSTYLE','%EM_GETEVENTMASK','%EM_GETFIRSTVISIBLELINE',
                        '%EM_GETHANDLE','%EM_GETIMESTATUS','%EM_GETLIMITTEXT','%EM_GETLINE','%EM_GETLINECOUNT','%EM_GETMARGINS','%EM_GETMODIFY','%EM_GETOLEINTERFACE',
                        '%EM_GETOPTIONS','%EM_GETPARAFORMAT','%EM_GETPASSWORDCHAR','%EM_GETRECT','%EM_GETREDONAME','%EM_GETSCROLLPOS','%EM_GETSEL','%EM_GETSELTEXT',
                        '%EM_GETTEXTMODE','%EM_GETTEXTRANGE','%EM_GETTHUMB','%EM_GETUNDONAME','%EM_GETWORDBREAKPROC','%EM_GETWORDBREAKPROCEX','%EM_HIDESELECTION','%EM_LIMITTEXT',
                        '%EM_LINEFROMCHAR','%EM_LINEINDEX','%EM_LINELENGTH','%EM_LINESCROLL','%EM_PASTESPECIAL','%EM_POSFROMCHAR','%EM_REDO','%EM_REPLACESEL',
                        '%EM_REQUESTRESIZE','%EM_SCROLL','%EM_SCROLLCARET','%EM_SELECTIONTYPE','%EM_SETBKGNDCOLOR','%EM_SETCHARFORMAT','%EM_SETEDITSTYLE','%EM_SETEVENTMASK',
                        '%EM_SETHANDLE','%EM_SETIMESTATUS','%EM_SETLIMITTEXT','%EM_SETMARGINS','%EM_SETMODIFY','%EM_SETOLECALLBACK','%EM_SETOPTIONS','%EM_SETPARAFORMAT',
                        '%EM_SETPASSWORDCHAR','%EM_SETREADONLY','%EM_SETRECT','%EM_SETRECTNP','%EM_SETSCROLLPOS','%EM_SETSEL','%EM_SETTABSTOPS','%EM_SETTARGETDEVICE',
                        '%EM_SETTEXTMODE','%EM_SETUNDOLIMIT','%EM_SETWORDBREAKPROC','%EM_SETWORDBREAKPROCEX','%EM_SETWORDWRAPMODE','%EM_SETZOOM','%EM_STOPGROUPTYPING','%EM_STREAMIN',
                        '%EM_STREAMOUT','%EM_UNDO','%ENM_CHANGE','%ENM_CORRECTTEXT','%ENM_DRAGDROPDONE','%ENM_DROPFILES','%ENM_KEYEVENTS','%ENM_MOUSEEVENTS',
                        '%ENM_NONE','%ENM_PARAGRAPHEXPANDED','%ENM_PROTECTED','%ENM_REQUESTRESIZE','%ENM_SCROLL','%ENM_SCROLLEVENTS','%ENM_SELCHANGE','%ENM_UPDATE',
                        '%EN_CHANGE','%EN_MSGFILTER','%EN_SELCHANGE','%EN_UPDATE','%ES_AUTOHSCROLL','%ES_AUTOVSCROLL','%ES_CENTER','%ES_DISABLENOSCROLL',
                        '%ES_EX_NOCALLOLEINIT','%ES_LEFT','%ES_LOWERCASE','%ES_MULTILINE','%ES_NOHIDESEL','%ES_NOOLEDRAGDROP','%ES_NUMBER','%ES_OEMCONVERT',
                        '%ES_PASSWORD','%ES_READONLY','%ES_RIGHT','%ES_SAVESEL','%ES_SELECTIONBAR','%ES_SUNKEN','%ES_UPPERCASE','%ES_WANTRETURN',
                        '%FALSE','%FILE_ADDPATH','%FILE_ARCHIVE','%FILE_BUILDVERSION','%FILE_HIDDEN','%FILE_MAJORVERSION','%FILE_MINORVERSION','%FILE_NORMAL',
                        '%FILE_READONLY','%FILE_REVISIONVERSION','%FILE_SUBDIR','%FILE_SYSTEM','%FILE_VLABEL','%FTP_GET_CONNECT_STATUS','%FTP_GET_FILE_BYTES_RCVD','%FTP_GET_FILE_BYTES_SENT',
                        '%FTP_GET_LAST_RESPONSE','%FTP_GET_LOCAL_IP','%FTP_GET_SERVER_IP','%FTP_GET_TOTAL_BYTES_RCVD','%FTP_GET_TOTAL_BYTES_SENT','%FTP_LIST_FULLLIST','%FTP_LIST_FULLLISTDIR','%FTP_LIST_FULLLISTFILE',
                        '%FTP_SET_ASYNC','%FTP_SET_CONNECT_WAIT','%FTP_SET_MAX_LISTEN_WAIT','%FTP_SET_MAX_RESPONSE_WAIT','%FTP_SET_PASSIVE','%FTP_SET_SYNC','%FW_BLACK','%FW_BOLD',
                        '%FW_DEMIBOLD','%FW_DONTCARE','%FW_EXTRABOLD','%FW_EXTRALIGHT','%FW_HEAVY','%FW_LIGHT','%FW_MEDIUM','%FW_NORMAL',
                        '%FW_REGULAR','%FW_SEMIBOLD','%FW_THIN','%FW_ULTRABOLD','%FW_ULTRALIGHT','%GDTR_MAX','%GDTR_MIN','%GL_CLIP_PLANE0',
                        '%GL_CLIP_PLANE1','%GL_CLIP_PLANE2','%GL_CLIP_PLANE3','%GL_CLIP_PLANE4','%GL_CLIP_PLANE5','%GL_DST_ALPHA','%GL_DST_COLOR','%GL_FILL',
                        '%GL_LIGHT0','%GL_LIGHT1','%GL_LIGHT2','%GL_LIGHT3','%GL_LIGHT4','%GL_LIGHT5','%GL_LIGHT6','%GL_LIGHT7',
                        '%GL_LINE','%GL_LINES','%GL_LINE_LOOP','%GL_LINE_STRIP','%GL_ONE','%GL_ONE_MINUS_DST_ALPHA','%GL_ONE_MINUS_DST_COLOR','%GL_ONE_MINUS_SRC_ALPHA',
                        '%GL_ONE_MINUS_SRC_COLOR','%GL_POINT','%GL_POINTS','%GL_POLYGON','%GL_QUADS','%GL_QUAD_STRIP','%GL_SRC_ALPHA','%GL_SRC_ALPHA_SATURATE',
                        '%GL_SRC_COLOR','%GL_TRIANGLES','%GL_TRIANGLE_FAN','%GL_TRIANGLE_STRIP','%GL_ZERO','%GRAY','%GREEN','%GWLP_HINSTANCE',
                        '%GWLP_HWNDPARENT','%GWLP_ID','%GWLP_USERDATA','%GWLP_WNDPROC','%GWL_EXSTYLE','%GWL_HINSTANCE','%GWL_HWNDPARENT','%GWL_ID',
                        '%GWL_STYLE','%GWL_USERDATA','%GWL_WNDPROC','%HDM_FIRST','%ICRYPTO_XOR_DECREASE','%ICRYPTO_XOR_INCREASE','%ICRYPTO_XOR_NORMAL','%IDABORT',
                        '%IDCANCEL','%IDCONTINUE','%IDIGNORE','%IDNO','%IDOK','%IDRETRY','%IDTIMEOUT','%IDTRYAGAIN',
                        '%IDYES','%INTERNET_CONNECTION_CONFIGURED','%INTERNET_CONNECTION_LAN','%INTERNET_CONNECTION_MODEM','%INTERNET_CONNECTION_MODEM_BUSY','%INTERNET_CONNECTION_OFFLINE','%INTERNET_CONNECTION_PROXY','%INTERNET_RAS_INSTALLED',
                        '%LBN_DBLCLK','%LBN_KILLFOCUS','%LBN_SELCANCEL','%LBN_SELCHANGE','%LBN_SETFOCUS','%LBS_DISABLENOSCROLL','%LBS_EXTENDEDSEL','%LBS_MULTICOLUMN',
                        '%LBS_MULTIPLESEL','%LBS_NOINTEGRALHEIGHT','%LBS_NOSEL','%LBS_NOTIFY','%LBS_SORT','%LBS_STANDARD','%LBS_USETABSTOPS','%LB_ADDFILE',
                        '%LB_ADDSTRING','%LB_DELETESTRING','%LB_DIR','%LB_FINDSTRING','%LB_FINDSTRINGEXACT','%LB_GETANCHORINDEX','%LB_GETCARETINDEX','%LB_GETCOUNT',
                        '%LB_GETCURSEL','%LB_GETHORIZONTALEXTENT','%LB_GETITEMDATA','%LB_GETITEMHEIGHT','%LB_GETITEMRECT','%LB_GETLISTBOXINFO','%LB_GETLOCALE','%LB_GETSEL',
                        '%LB_GETSELCOUNT','%LB_GETSELITEMS','%LB_GETTEXT','%LB_GETTEXTLEN','%LB_GETTOPINDEX','%LB_INITSTORAGE','%LB_INSERTSTRING','%LB_ITEMFROMPOINT',
                        '%LB_MULTIPLEADDSTRING','%LB_RESETCONTENT','%LB_SELECTSTRING','%LB_SELITEMRANGE','%LB_SELITEMRANGEEX','%LB_SETANCHORINDEX','%LB_SETCARETINDEX','%LB_SETCOLUMNWIDTH',
                        '%LB_SETCOUNT','%LB_SETCURSEL','%LB_SETHORIZONTALEXTENT','%LB_SETITEMDATA','%LB_SETITEMHEIGHT','%LB_SETLOCALE','%LB_SETSEL','%LB_SETTABSTOPS',
                        '%LB_SETTOPINDEX','%LF_FACESIZE','%LTGRAY','%LVM_FIRST','%MAGENTA','%MAXBYTE','%MAXCHAR','%MAXDWORD',
                        '%MAXSHORT','%MAXWORD','%MAX_PATH','%MB_ABORTRETRYIGNORE','%MB_APPLMODAL','%MB_CANCELTRYCONTINUE','%MB_DEFBUTTON1','%MB_DEFBUTTON2',
                        '%MB_DEFBUTTON3','%MB_HELP','%MB_ICONASTERISK','%MB_ICONERROR','%MB_ICONEXCLAMATION','%MB_ICONHAND','%MB_ICONINFORMATION','%MB_ICONQUESTION',
                        '%MB_ICONSTOP','%MB_ICONWARNING','%MB_OK','%MB_OKCANCEL','%MB_RETRYCANCEL','%MB_SIMPLE','%MB_SYSTEMMODAL','%MB_TOPMOST',
                        '%MB_YESNO','%MB_YESNOCANCEL','%MF_CHECKED','%MF_DISABLED','%MF_ENABLED','%MF_GRAYED','%MF_SEPARATOR','%MF_UNCHECKED',
                        '%MINCHAR','%MINLONG','%MINSHORT','%NULL','%ODBC352_INC','%ODBCVER','%ODBC_ADD_DSN','%ODBC_ADD_SYS_DSN',
                        '%ODBC_BOTH_DSN','%ODBC_CONFIG_DRIVER','%ODBC_CONFIG_DRIVER_MAX','%ODBC_CONFIG_DSN','%ODBC_CONFIG_SYS_DSN','%ODBC_DRIVER_VERSION','%ODBC_ERROR_COMPONENT_NOT_FOUND','%ODBC_ERROR_CREATE_DSN_FAILED',
                        '%ODBC_ERROR_GENERAL_ERR','%ODBC_ERROR_INVALID_BUFF_LEN','%ODBC_ERROR_INVALID_DSN','%ODBC_ERROR_INVALID_HWND','%ODBC_ERROR_INVALID_INF','%ODBC_ERROR_INVALID_KEYWORD_VALUE','%ODBC_ERROR_INVALID_LOG_FILE','%ODBC_ERROR_INVALID_NAME',
                        '%ODBC_ERROR_INVALID_PARAM_SEQUENCE','%ODBC_ERROR_INVALID_PATH','%ODBC_ERROR_INVALID_REQUEST_TYPE','%ODBC_ERROR_INVALID_STR','%ODBC_ERROR_LOAD_LIB_FAILED','%ODBC_ERROR_OUTPUT_STRING_TRUNCATED','%ODBC_ERROR_OUT_OF_MEM','%ODBC_ERROR_REMOVE_DSN_FAILED',
                        '%ODBC_ERROR_REQUEST_FAILED','%ODBC_ERROR_USAGE_UPDATE_FAILED','%ODBC_ERROR_USER_CANCELED','%ODBC_ERROR_WRITING_SYSINFO_FAILED','%ODBC_INSTALL_COMPLETE','%ODBC_INSTALL_DRIVER','%ODBC_INSTALL_INQUIRY','%ODBC_REMOVE_DEFAULT_DSN',
                        '%ODBC_REMOVE_DRIVER','%ODBC_REMOVE_DSN','%ODBC_REMOVE_SYS_DSN','%ODBC_SYSTEM_DSN','%ODBC_USER_DSN','%OFN_ALLOWMULTISELECT','%OFN_CREATEPROMPT','%OFN_ENABLEHOOK',
                        '%OFN_ENABLEINCLUDENOTIFY','%OFN_ENABLESIZING','%OFN_ENABLETEMPLATE','%OFN_ENABLETEMPLATEHANDLE','%OFN_EXPLORER','%OFN_EXTENSIONDIFFERENT','%OFN_FILEMUSTEXIST','%OFN_HIDEREADONLY',
                        '%OFN_LONGNAMES','%OFN_NOCHANGEDIR','%OFN_NODEREFERENCELINKS','%OFN_NOLONGNAMES','%OFN_NONETWORKBUTTON','%OFN_NOREADONLYRETURN','%OFN_NOTESTFILECREATE','%OFN_NOVALIDATE',
                        '%OFN_OVERWRITEPROMPT','%OFN_PATHMUSTEXIST','%OFN_READONLY','%OFN_SHAREAWARE','%OFN_SHOWHELP','%OS_ERROR_CALLFUNCTION','%OS_ERROR_EMPTYSTRING','%OS_ERROR_LOADLIBRARY',
                        '%OS_ERROR_SUCCESS','%OS_ERROR_WRONGPARAMETER','%OS_SHELL_ASYNC','%OS_SHELL_SYNC','%OS_WNDSTYLE_HIDE','%OS_WNDSTYLE_MAXIMIZED','%OS_WNDSTYLE_MINIMIZED','%OS_WNDSTYLE_MINIMIZEDNOFOCUS',
                        '%OS_WNDSTYLE_NORMAL','%OS_WNDSTYLE_NORMALNOFOCUS','%PATH_EXT','%PATH_FILE','%PATH_FILEEXT','%PATH_ROOT','%PATH_ROOTPATH','%PATH_ROOTPATHPROG',
                        '%PATH_ROOTPATHPROGEXT','%PBM_DELTAPOS','%PBM_GETPOS','%PBM_GETRANGE','%PBM_SETBARCOLOR','%PBM_SETBKCOLOR','%PBM_SETPOS','%PBM_SETRANGE',
                        '%PBM_SETRANGE32','%PBM_SETSTEP','%PBM_STEPIT','%PBS_SMOOTH','%PBS_VERTICAL','%PC_DISABLEWAKEEVENT_OFF','%PC_DISABLEWAKEEVENT_ON','%PC_EB_NOCONFIRMATION',
                        '%PC_EB_NOPROGRESSUI','%PC_EB_NORMAL','%PC_EB_NOSOUND','%PC_FORCECRITICAL_OFF','%PC_FORCECRITICAL_ON','%PC_HIBERNATE_OFF','%PC_HIBERNATE_ON','%PC_RD_FORCE',
                        '%PC_RD_FORCEIFHUNG','%PC_RD_LOGOFF','%PC_RD_POWEROFF','%PC_RD_REBOOT','%PC_RD_SHUTDOWN','%PC_SD_DONOT_FORCE','%PC_SD_DONOT_REBOOT','%PC_SD_FORCE',
                        '%PC_SD_REBOOT','%PFA_CENTER','%PFA_LEFT','%PFA_RIGHT','%PGM_FIRST','%RED','%RTF_UBB','%SAPI_SVSFDEFAULT',
                        '%SAPI_SVSFISFILENAME','%SAPI_SVSFISNOTXML','%SAPI_SVSFISXML','%SAPI_SVSFLAGSASYNC','%SAPI_SVSFNLPMASK','%SAPI_SVSFNLPSPEAKPUNC','%SAPI_SVSFPERSISTXML','%SAPI_SVSFPURGEBEFORESPEAK',
                        '%SAPI_SVSFUNUSEDFLAGS','%SAPI_SVSFVOICEMASK','%SBS_SIZEGRIP','%SB_BOTTOM','%SB_ENDSCROLL','%SB_LEFT','%SB_LINEDOWN','%SB_LINELEFT',
                        '%SB_LINERIGHT','%SB_LINEUP','%SB_PAGEDOWN','%SB_PAGELEFT','%SB_PAGERIGHT','%SB_PAGEUP','%SB_RIGHT','%SB_THUMBPOSITION',
                        '%SB_THUMBTRACK','%SB_TOP','%SCF_ALL','%SCF_ASSOCIATEFONT','%SCF_DEFAULT','%SCF_NOKBUPDATE','%SCF_SELECTION','%SCF_USEUIRULES',
                        '%SCF_WORD','%SC_CLOSE','%SC_CONTEXTHELP','%SC_HOTKEY','%SC_HSCROLL','%SC_KEYMENU','%SC_MAXIMIZE','%SC_MINIMIZE',
                        '%SC_MONITORPOWER','%SC_MOUSEMENU','%SC_MOVE','%SC_NEXTWINDOW','%SC_PREVWINDOW','%SC_RESTORE','%SC_SCREENSAVE','%SC_SIZE',
                        '%SC_TASKLIST','%SC_VSCROLL','%SES_ALLOWBEEPS','%SES_BEEPONMAXTEXT','%SES_BIDI','%SES_EMULATE10','%SES_EMULATESYSEDIT','%SES_EXTENDBACKCOLOR',
                        '%SES_LOWERCASE','%SES_MAPCPS','%SES_NOIME','%SES_NOINPUTSEQUENCECHK','%SES_SCROLLONKILLFOCUS','%SES_UPPERCASE','%SES_USEAIMM','%SES_USECRLF',
                        '%SES_XLTCRCRLFTOCR','%SF_RTF','%SF_TEXT','%SMTP_ADDRESS_DELIMITER','%SMTP_ADD_HEADER','%SMTP_ALLOW_8BITS','%SMTP_ASYNC','%SMTP_ATTACH_BASE_NUMBER',
                        '%SMTP_ATTACH_DELIMITER','%SMTP_AUTHENTICATE_CRAM','%SMTP_AUTHENTICATE_LOGIN','%SMTP_AUTHENTICATE_PLAIN','%SMTP_AUTHENTICATE_PROTOCOL','%SMTP_AUTO_CALL_DRIVER','%SMTP_BLOCKING_MODE','%SMTP_CHARSET_8859',
                        '%SMTP_CHARSET_BLANK','%SMTP_CHARSET_ISO_8859_1','%SMTP_CHARSET_ISO_8859_8','%SMTP_CHARSET_US_ASCII','%SMTP_CHARSET_WIN_1252','%SMTP_CHARSET_WIN_1255','%SMTP_CONNECT_WAIT','%SMTP_COPY_BUFFER',
                        '%SMTP_DECODE_UNNAMED','%SMTP_DISABLE_MIME','%SMTP_ENABLE_APOP','%SMTP_ENABLE_ESMTP','%SMTP_ENABLE_IMAGE','%SMTP_ENABLE_XMAILER','%SMTP_FILE_PREFIX','%SMTP_FORCE_INLINE',
                        '%SMTP_GET_ATTACH_BYTES_READ','%SMTP_GET_ATTACH_BYTES_SENT','%SMTP_GET_ATTACH_COUNT','%SMTP_GET_ATTACH_NAMES','%SMTP_GET_BUFFER_COUNT','%SMTP_GET_BUILD','%SMTP_GET_CONNECT_STATUS','%SMTP_GET_COUNTER',
                        '%SMTP_GET_LAST_RECIPIENT','%SMTP_GET_LAST_RESPONSE','%SMTP_GET_LOCAL_IP','%SMTP_GET_MESSAGE_BYTES_READ','%SMTP_GET_MESSAGE_BYTES_SENT','%SMTP_GET_MSG_COUNT','%SMTP_GET_MSG_SIZE','%SMTP_GET_REGISTRATION',
                        '%SMTP_GET_RESPONSE','%SMTP_GET_SERVER_IP','%SMTP_GET_SOCKET','%SMTP_GET_SOCK_ERROR','%SMTP_GET_TOTAL_BYTES_READ','%SMTP_GET_TOTAL_BYTES_SENT','%SMTP_GET_VERIFY_STATUS','%SMTP_GET_VERSION',
                        '%SMTP_HIDE_HEADERS','%SMTP_HIDE_SAVED_MSG','%SMTP_HIDE_TO_ADDR','%SMTP_HTML_CHARSET','%SMTP_IGNORE_REJECTED','%SMTP_INLINE_TEXT_ATTACHMENT','%SMTP_INLINE_TEXT_INLINE','%SMTP_INLINE_TEXT_OFF',
                        '%SMTP_LOG_FILE','%SMTP_MAX_LINE_LENGTH','%SMTP_MAX_RESPONSE_WAIT','%SMTP_MIN_RESPONSE_WAIT','%SMTP_PATH_DELIMITER','%SMTP_POP3_PORT','%SMTP_QUOTED_8859','%SMTP_QUOTED_HTML',
                        '%SMTP_QUOTED_ISO_8859_1','%SMTP_QUOTED_ISO_8859_8','%SMTP_QUOTED_OFF','%SMTP_QUOTED_PLAIN','%SMTP_QUOTED_PRINTABLE','%SMTP_QUOTED_RICH','%SMTP_QUOTED_USER','%SMTP_QUOTED_WIN_1252',
                        '%SMTP_QUOTED_WIN_1255','%SMTP_RAW_MODE','%SMTP_SET_ATTACH_CONTENT_TYPE','%SMTP_SET_CONTENT_TYPE','%SMTP_SET_CONTENT_TYPE_PREFIX','%SMTP_SET_FILE_PREFIX','%SMTP_SET_FROM','%SMTP_SET_HEADER',
                        '%SMTP_SET_REPLY','%SMTP_SET_SECRET','%SMTP_SET_TEXT_MESSAGE','%SMTP_SET_TRANSFER_ENCODING','%SMTP_SET_USER','%SMTP_SLEEP_TIME','%SMTP_SMTP_PORT','%SMTP_SYNC',
                        '%SMTP_WRITE_BUFFER','%SMTP_WRITE_CONTENT_TYPE','%SMTP_WRITE_TO_LOG','%SMTP_WSACLEANUP','%SQL_AA_FALSE','%SQL_AA_TRUE','%SQL_ACCESSIBLE_PROCEDURES','%SQL_ACCESSIBLE_TABLES',
                        '%SQL_ACCESS_MODE','%SQL_ACTIVE_CONNECTIONS','%SQL_ACTIVE_ENVIRONMENTS','%SQL_ACTIVE_STATEMENTS','%SQL_ADD','%SQL_AD_ADD_CONSTRAINT_DEFERRABLE','%SQL_AD_ADD_CONSTRAINT_INITIALLY_DEFERRED','%SQL_AD_ADD_CONSTRAINT_INITIALLY_IMMEDIATE',
                        '%SQL_AD_ADD_CONSTRAINT_NON_DEFERRABLE','%SQL_AD_ADD_DOMAIN_CONSTRAINT','%SQL_AD_ADD_DOMAIN_DEFAULT','%SQL_AD_CONSTRAINT_NAME_DEFINITION','%SQL_AD_DROP_DOMAIN_CONSTRAINT','%SQL_AD_DROP_DOMAIN_DEFAULT','%SQL_AF_ALL','%SQL_AF_AVG',
                        '%SQL_AF_COUNT','%SQL_AF_DISTINCT','%SQL_AF_MAX','%SQL_AF_MIN','%SQL_AF_SUM','%SQL_AGGREGATE_FUNCTIONS','%SQL_ALL_EXCEPT_LIKE','%SQL_ALL_TYPES',
                        '%SQL_ALTER_DOMAIN','%SQL_ALTER_TABLE','%SQL_AM_CONNECTION','%SQL_AM_NONE','%SQL_AM_STATEMENT','%SQL_API_ALL_FUNCTIONS','%SQL_API_LOADBYORDINAL','%SQL_API_ODBC3_ALL_FUNCTIONS',
                        '%SQL_API_ODBC3_ALL_FUNCTIONS_SIZE','%SQL_API_SQLALLOCCONNECT','%SQL_API_SQLALLOCENV','%SQL_API_SQLALLOCHANDLE','%SQL_API_SQLALLOCHANDLESTD','%SQL_API_SQLALLOCSTMT','%SQL_API_SQLBINDCOL','%SQL_API_SQLBINDPARAM',
                        '%SQL_API_SQLBINDPARAMETER','%SQL_API_SQLBROWSECONNECT','%SQL_API_SQLBULKOPERATIONS','%SQL_API_SQLCANCEL','%SQL_API_SQLCLOSECURSOR','%SQL_API_SQLCOLATTRIBUTE','%SQL_API_SQLCOLATTRIBUTES','%SQL_API_SQLCOLUMNPRIVILEGES',
                        '%SQL_API_SQLCOLUMNS','%SQL_API_SQLCONNECT','%SQL_API_SQLCOPYDESC','%SQL_API_SQLDATASOURCES','%SQL_API_SQLDESCRIBECOL','%SQL_API_SQLDESCRIBEPARAM','%SQL_API_SQLDISCONNECT','%SQL_API_SQLDRIVERCONNECT',
                        '%SQL_API_SQLDRIVERS','%SQL_API_SQLENDTRAN','%SQL_API_SQLERROR','%SQL_API_SQLEXECDIRECT','%SQL_API_SQLEXECUTE','%SQL_API_SQLEXTENDEDFETCH','%SQL_API_SQLFETCH','%SQL_API_SQLFETCHSCROLL',
                        '%SQL_API_SQLFOREIGNKEYS','%SQL_API_SQLFREECONNECT','%SQL_API_SQLFREEENV','%SQL_API_SQLFREEHANDLE','%SQL_API_SQLFREESTMT','%SQL_API_SQLGETCONNECTATTR','%SQL_API_SQLGETCONNECTOPTION','%SQL_API_SQLGETCURSORNAME',
                        '%SQL_API_SQLGETDATA','%SQL_API_SQLGETDESCFIELD','%SQL_API_SQLGETDESCREC','%SQL_API_SQLGETDIAGFIELD','%SQL_API_SQLGETDIAGREC','%SQL_API_SQLGETENVATTR','%SQL_API_SQLGETFUNCTIONS','%SQL_API_SQLGETINFO',
                        '%SQL_API_SQLGETSTMTATTR','%SQL_API_SQLGETSTMTOPTION','%SQL_API_SQLGETTYPEINFO','%SQL_API_SQLMORERESULTS','%SQL_API_SQLNATIVESQL','%SQL_API_SQLNUMPARAMS','%SQL_API_SQLNUMRESULTCOLS','%SQL_API_SQLPARAMDATA',
                        '%SQL_API_SQLPARAMOPTIONS','%SQL_API_SQLPREPARE','%SQL_API_SQLPRIMARYKEYS','%SQL_API_SQLPROCEDURECOLUMNS','%SQL_API_SQLPROCEDURES','%SQL_API_SQLPUTDATA','%SQL_API_SQLROWCOUNT','%SQL_API_SQLSETCONNECTATTR',
                        '%SQL_API_SQLSETCONNECTOPTION','%SQL_API_SQLSETCURSORNAME','%SQL_API_SQLSETDESCFIELD','%SQL_API_SQLSETDESCREC','%SQL_API_SQLSETENVATTR','%SQL_API_SQLSETPARAM','%SQL_API_SQLSETPOS','%SQL_API_SQLSETSCROLLOPTIONS',
                        '%SQL_API_SQLSETSTMTATTR','%SQL_API_SQLSETSTMTOPTION','%SQL_API_SQLSPECIALCOLUMNS','%SQL_API_SQLSTATISTICS','%SQL_API_SQLTABLEPRIVILEGES','%SQL_API_SQLTABLES','%SQL_API_SQLTRANSACT','%SQL_ARD_TYPE',
                        '%SQL_ASYNC_ENABLE','%SQL_ASYNC_ENABLE_DEFAULT','%SQL_ASYNC_ENABLE_OFF','%SQL_ASYNC_ENABLE_ON','%SQL_ASYNC_MODE','%SQL_ATTR_ACCESS_MODE','%SQL_ATTR_ANSI_APP','%SQL_ATTR_APP_PARAM_DESC',
                        '%SQL_ATTR_APP_ROW_DESC','%SQL_ATTR_ASYNC_ENABLE','%SQL_ATTR_AUTOCOMMIT','%SQL_ATTR_AUTO_IPD','%SQL_ATTR_CONCURRENCY','%SQL_ATTR_CONNECTION_DEAD','%SQL_ATTR_CONNECTION_POOLING','%SQL_ATTR_CONNECTION_TIMEOUT',
                        '%SQL_ATTR_CP_MATCH','%SQL_ATTR_CURRENT_CATALOG','%SQL_ATTR_CURSOR_SCROLLABLE','%SQL_ATTR_CURSOR_SENSITIVITY','%SQL_ATTR_CURSOR_TYPE','%SQL_ATTR_DISCONNECT_BEHAVIOR','%SQL_ATTR_ENABLE_AUTO_IPD','%SQL_ATTR_ENLIST_IN_DTC',
                        '%SQL_ATTR_ENLIST_IN_XA','%SQL_ATTR_FETCH_BOOKMARK_PTR','%SQL_ATTR_IMP_PARAM_DESC','%SQL_ATTR_IMP_ROW_DESC','%SQL_ATTR_KEYSET_SIZE','%SQL_ATTR_LOGIN_TIMEOUT','%SQL_ATTR_MAX_LENGTH','%SQL_ATTR_MAX_ROWS',
                        '%SQL_ATTR_METADATA_ID','%SQL_ATTR_NOSCAN','%SQL_ATTR_ODBC_CURSORS','%SQL_ATTR_ODBC_VERSION','%SQL_ATTR_OUTPUT_NTS','%SQL_ATTR_PACKET_SIZE','%SQL_ATTR_PARAMSET_SIZE','%SQL_ATTR_PARAMS_PROCESSED_PTR',
                        '%SQL_ATTR_PARAM_BIND_OFFSET_PTR','%SQL_ATTR_PARAM_BIND_TYPE','%SQL_ATTR_PARAM_OPERATION_PTR','%SQL_ATTR_PARAM_STATUS_PTR','%SQL_ATTR_QUERY_TIMEOUT','%SQL_ATTR_QUIET_MODE','%SQL_ATTR_READONLY','%SQL_ATTR_READWRITE_UNKNOWN',
                        '%SQL_ATTR_RETRIEVE_DATA','%SQL_ATTR_ROWS_FETCHED_PTR','%SQL_ATTR_ROW_ARRAY_SIZE','%SQL_ATTR_ROW_BIND_OFFSET_PTR','%SQL_ATTR_ROW_BIND_TYPE','%SQL_ATTR_ROW_NUMBER','%SQL_ATTR_ROW_OPERATION_PTR','%SQL_ATTR_ROW_STATUS_PTR',
                        '%SQL_ATTR_SIMULATE_CURSOR','%SQL_ATTR_TRACE','%SQL_ATTR_TRACEFILE','%SQL_ATTR_TRANSLATE_LIB','%SQL_ATTR_TRANSLATE_OPTION','%SQL_ATTR_TXN_ISOLATION','%SQL_ATTR_USE_BOOKMARKS','%SQL_ATTR_WRITE',
                        '%SQL_AT_ADD_COLUMN','%SQL_AT_ADD_COLUMN_COLLATION','%SQL_AT_ADD_COLUMN_DEFAULT','%SQL_AT_ADD_COLUMN_SINGLE','%SQL_AT_ADD_CONSTRAINT','%SQL_AT_ADD_TABLE_CONSTRAINT','%SQL_AT_CONSTRAINT_DEFERRABLE','%SQL_AT_CONSTRAINT_INITIALLY_DEFERRED',
                        '%SQL_AT_CONSTRAINT_INITIALLY_IMMEDIATE','%SQL_AT_CONSTRAINT_NAME_DEFINITION','%SQL_AT_CONSTRAINT_NON_DEFERRABLE','%SQL_AT_DROP_COLUMN','%SQL_AT_DROP_COLUMN_CASCADE','%SQL_AT_DROP_COLUMN_DEFAULT','%SQL_AT_DROP_COLUMN_RESTRICT','%SQL_AT_DROP_TABLE_CONSTRAINT_CASCADE',
                        '%SQL_AT_DROP_TABLE_CONSTRAINT_RESTRICT','%SQL_AT_SET_COLUMN_DEFAULT','%SQL_AUTOCOMMIT','%SQL_AUTOCOMMIT_DEFAULT','%SQL_AUTOCOMMIT_OFF','%SQL_AUTOCOMMIT_ON','%SQL_BATCH_ROW_COUNT','%SQL_BATCH_SUPPORT',
                        '%SQL_BEST_ROWID','%SQL_BIGINT','%SQL_BINARY','%SQL_BIND_BY_COLUMN','%SQL_BIND_TYPE','%SQL_BIND_TYPE_DEFAULT','%SQL_BIT','%SQL_BOOKMARK_PERSISTENCE',
                        '%SQL_BP_CLOSE','%SQL_BP_DELETE','%SQL_BP_DROP','%SQL_BP_OTHER_HSTMT','%SQL_BP_SCROLL','%SQL_BP_TRANSACTION','%SQL_BP_UPDATE','%SQL_BRC_EXPLICIT',
                        '%SQL_BRC_PROCEDURES','%SQL_BRC_ROLLED_UP','%SQL_BS_ROW_COUNT_EXPLICIT','%SQL_BS_ROW_COUNT_PROC','%SQL_BS_SELECT_EXPLICIT','%SQL_BS_SELECT_PROC','%SQL_CA1_ABSOLUTE','%SQL_CA1_BOOKMARK',
                        '%SQL_CA1_BULK_ADD','%SQL_CA1_BULK_DELETE_BY_BOOKMARK','%SQL_CA1_BULK_FETCH_BY_BOOKMARK','%SQL_CA1_BULK_UPDATE_BY_BOOKMARK','%SQL_CA1_LOCK_EXCLUSIVE','%SQL_CA1_LOCK_NO_CHANGE','%SQL_CA1_LOCK_UNLOCK','%SQL_CA1_NEXT',
                        '%SQL_CA1_POSITIONED_DELETE','%SQL_CA1_POSITIONED_UPDATE','%SQL_CA1_POS_DELETE','%SQL_CA1_POS_POSITION','%SQL_CA1_POS_REFRESH','%SQL_CA1_POS_UPDATE','%SQL_CA1_RELATIVE','%SQL_CA1_SELECT_FOR_UPDATE',
                        '%SQL_CA2_CRC_APPROXIMATE','%SQL_CA2_CRC_EXACT','%SQL_CA2_LOCK_CONCURRENCY','%SQL_CA2_MAX_ROWS_AFFECTS_ALL','%SQL_CA2_MAX_ROWS_CATALOG','%SQL_CA2_MAX_ROWS_DELETE','%SQL_CA2_MAX_ROWS_INSERT','%SQL_CA2_MAX_ROWS_SELECT',
                        '%SQL_CA2_MAX_ROWS_UPDATE','%SQL_CA2_OPT_ROWVER_CONCURRENCY','%SQL_CA2_OPT_VALUES_CONCURRENCY','%SQL_CA2_READ_ONLY_CONCURRENCY','%SQL_CA2_SENSITIVITY_ADDITIONS','%SQL_CA2_SENSITIVITY_DELETIONS','%SQL_CA2_SENSITIVITY_UPDATES','%SQL_CA2_SIMULATE_NON_UNIQUE',
                        '%SQL_CA2_SIMULATE_TRY_UNIQUE','%SQL_CA2_SIMULATE_UNIQUE','%SQL_CASCADE','%SQL_CATALOG_LOCATION','%SQL_CATALOG_NAME','%SQL_CATALOG_NAME_SEPARATOR','%SQL_CATALOG_TERM','%SQL_CATALOG_USAGE',
                        '%SQL_CA_CONSTRAINT_DEFERRABLE','%SQL_CA_CONSTRAINT_INITIALLY_DEFERRED','%SQL_CA_CONSTRAINT_INITIALLY_IMMEDIATE','%SQL_CA_CONSTRAINT_NON_DEFERRABLE','%SQL_CA_CREATE_ASSERTION','%SQL_CB_CLOSE','%SQL_CB_DELETE','%SQL_CB_NON_NULL',
                        '%SQL_CB_NULL','%SQL_CB_PRESERVE','%SQL_CCOL_CREATE_COLLATION','%SQL_CCS_COLLATE_CLAUSE','%SQL_CCS_CREATE_CHARACTER_SET','%SQL_CCS_LIMITED_COLLATION','%SQL_CC_CLOSE','%SQL_CC_DELETE',
                        '%SQL_CC_PRESERVE','%SQL_CDO_COLLATION','%SQL_CDO_CONSTRAINT','%SQL_CDO_CONSTRAINT_DEFERRABLE','%SQL_CDO_CONSTRAINT_INITIALLY_DEFERRED','%SQL_CDO_CONSTRAINT_INITIALLY_IMMEDIATE','%SQL_CDO_CONSTRAINT_NAME_DEFINITION','%SQL_CDO_CONSTRAINT_NON_DEFERRABLE',
                        '%SQL_CDO_CREATE_DOMAIN','%SQL_CDO_DEFAULT','%SQL_CD_FALSE','%SQL_CD_TRUE','%SQL_CHAR','%SQL_CLOSE','%SQL_CL_END','%SQL_CL_START',
                        '%SQL_CN_ANY','%SQL_CN_DIFFERENT','%SQL_CN_NONE','%SQL_CODE_DATE','%SQL_CODE_DAY','%SQL_CODE_DAY_TO_HOUR','%SQL_CODE_DAY_TO_MINUTE','%SQL_CODE_DAY_TO_SECOND',
                        '%SQL_CODE_HOUR','%SQL_CODE_HOUR_TO_MINUTE','%SQL_CODE_HOUR_TO_SECOND','%SQL_CODE_MINUTE','%SQL_CODE_MINUTE_TO_SECOND','%SQL_CODE_MONTH','%SQL_CODE_SECOND','%SQL_CODE_TIME',
                        '%SQL_CODE_TIMESTAMP','%SQL_CODE_YEAR','%SQL_CODE_YEAR_TO_MONTH','%SQL_COLATT_OPT_MAX','%SQL_COLATT_OPT_MIN','%SQL_COLLATION_SEQ','%SQL_COLUMN_ALIAS','%SQL_COLUMN_AUTO_INCREMENT',
                        '%SQL_COLUMN_CASE_SENSITIVE','%SQL_COLUMN_COUNT','%SQL_COLUMN_DISPLAY_SIZE','%SQL_COLUMN_IGNORE','%SQL_COLUMN_LABEL','%SQL_COLUMN_LENGTH','%SQL_COLUMN_MONEY','%SQL_COLUMN_NAME',
                        '%SQL_COLUMN_NULLABLE','%SQL_COLUMN_NUMBER_UNKNOWN','%SQL_COLUMN_OWNER_NAME','%SQL_COLUMN_PRECISION','%SQL_COLUMN_QUALIFIER_NAME','%SQL_COLUMN_SCALE','%SQL_COLUMN_SEARCHABLE','%SQL_COLUMN_TABLE_NAME',
                        '%SQL_COLUMN_TYPE','%SQL_COLUMN_TYPE_NAME','%SQL_COLUMN_UNSIGNED','%SQL_COLUMN_UPDATABLE','%SQL_COL_PRED_BASIC','%SQL_COL_PRED_CHAR','%SQL_COMMIT','%SQL_CONCAT_NULL_BEHAVIOR',
                        '%SQL_CONCURRENCY','%SQL_CONCUR_DEFAULT','%SQL_CONCUR_LOCK','%SQL_CONCUR_READ_ONLY','%SQL_CONCUR_ROWVER','%SQL_CONCUR_TIMESTAMP','%SQL_CONCUR_VALUES','%SQL_CONVERT_BIGINT',
                        '%SQL_CONVERT_BINARY','%SQL_CONVERT_BIT','%SQL_CONVERT_CHAR','%SQL_CONVERT_DATE','%SQL_CONVERT_DECIMAL','%SQL_CONVERT_DOUBLE','%SQL_CONVERT_FLOAT','%SQL_CONVERT_FUNCTIONS',
                        '%SQL_CONVERT_GUID','%SQL_CONVERT_INTEGER','%SQL_CONVERT_INTERVAL_DAY_TIME','%SQL_CONVERT_INTERVAL_YEAR_MONTH','%SQL_CONVERT_LONGVARBINARY','%SQL_CONVERT_LONGVARCHAR','%SQL_CONVERT_NUMERIC','%SQL_CONVERT_REAL',
                        '%SQL_CONVERT_SMALLINT','%SQL_CONVERT_TIME','%SQL_CONVERT_TIMESTAMP','%SQL_CONVERT_TINYINT','%SQL_CONVERT_VARBINARY','%SQL_CONVERT_VARCHAR','%SQL_CONVERT_WCHAR','%SQL_CONVERT_WLONGVARCHAR',
                        '%SQL_CONVERT_WVARCHAR','%SQL_CORRELATION_NAME','%SQL_CP_DEFAULT','%SQL_CP_MATCH_DEFAULT','%SQL_CP_OFF','%SQL_CP_ONE_PER_DRIVER','%SQL_CP_ONE_PER_HENV','%SQL_CP_RELAXED_MATCH',
                        '%SQL_CP_STRICT_MATCH','%SQL_CREATE_ASSERTION','%SQL_CREATE_CHARACTER_SET','%SQL_CREATE_COLLATION','%SQL_CREATE_DOMAIN','%SQL_CREATE_SCHEMA','%SQL_CREATE_TABLE','%SQL_CREATE_TRANSLATION',
                        '%SQL_CREATE_VIEW','%SQL_CR_CLOSE','%SQL_CR_DELETE','%SQL_CR_PRESERVE','%SQL_CS_AUTHORIZATION','%SQL_CS_CREATE_SCHEMA','%SQL_CS_DEFAULT_CHARACTER_SET','%SQL_CTR_CREATE_TRANSLATION',
                        '%SQL_CT_COLUMN_COLLATION','%SQL_CT_COLUMN_CONSTRAINT','%SQL_CT_COLUMN_DEFAULT','%SQL_CT_COMMIT_DELETE','%SQL_CT_COMMIT_PRESERVE','%SQL_CT_CONSTRAINT_DEFERRABLE','%SQL_CT_CONSTRAINT_INITIALLY_DEFERRED','%SQL_CT_CONSTRAINT_INITIALLY_IMMEDIATE',
                        '%SQL_CT_CONSTRAINT_NAME_DEFINITION','%SQL_CT_CONSTRAINT_NON_DEFERRABLE','%SQL_CT_CREATE_TABLE','%SQL_CT_GLOBAL_TEMPORARY','%SQL_CT_LOCAL_TEMPORARY','%SQL_CT_TABLE_CONSTRAINT','%SQL_CURRENT_QUALIFIER','%SQL_CURSOR_COMMIT_BEHAVIOR',
                        '%SQL_CURSOR_DYNAMIC','%SQL_CURSOR_FORWARD_ONLY','%SQL_CURSOR_KEYSET_DRIVEN','%SQL_CURSOR_ROLLBACK_BEHAVIOR','%SQL_CURSOR_SENSITIVITY','%SQL_CURSOR_STATIC','%SQL_CURSOR_TYPE','%SQL_CURSOR_TYPE_DEFAULT',
                        '%SQL_CUR_DEFAULT','%SQL_CUR_USE_DRIVER','%SQL_CUR_USE_IF_NEEDED','%SQL_CUR_USE_ODBC','%SQL_CU_DML_STATEMENTS','%SQL_CU_INDEX_DEFINITION','%SQL_CU_PRIVILEGE_DEFINITION','%SQL_CU_PROCEDURE_INVOCATION',
                        '%SQL_CU_TABLE_DEFINITION','%SQL_CVT_BIGINT','%SQL_CVT_BINARY','%SQL_CVT_BIT','%SQL_CVT_CHAR','%SQL_CVT_DATE','%SQL_CVT_DECIMAL','%SQL_CVT_DOUBLE',
                        '%SQL_CVT_FLOAT','%SQL_CVT_GUID','%SQL_CVT_INTEGER','%SQL_CVT_INTERVAL_DAY_TIME','%SQL_CVT_INTERVAL_YEAR_MONTH','%SQL_CVT_LONGVARBINARY','%SQL_CVT_LONGVARCHAR','%SQL_CVT_NUMERIC',
                        '%SQL_CVT_REAL','%SQL_CVT_SMALLINT','%SQL_CVT_TIME','%SQL_CVT_TIMESTAMP','%SQL_CVT_TINYINT','%SQL_CVT_VARBINARY','%SQL_CVT_VARCHAR','%SQL_CVT_WCHAR',
                        '%SQL_CVT_WLONGVARCHAR','%SQL_CVT_WVARCHAR','%SQL_CV_CASCADED','%SQL_CV_CHECK_OPTION','%SQL_CV_CREATE_VIEW','%SQL_CV_LOCAL','%SQL_C_BINARY','%SQL_C_BIT',
                        '%SQL_C_BOOKMARK','%SQL_C_CHAR','%SQL_C_DATE','%SQL_C_DEFAULT','%SQL_C_DOUBLE','%SQL_C_FLOAT','%SQL_C_GUID','%SQL_C_INTERVAL_DAY',
                        '%SQL_C_INTERVAL_DAY_TO_HOUR','%SQL_C_INTERVAL_DAY_TO_MINUTE','%SQL_C_INTERVAL_DAY_TO_SECOND','%SQL_C_INTERVAL_HOUR','%SQL_C_INTERVAL_HOUR_TO_MINUTE','%SQL_C_INTERVAL_HOUR_TO_SECOND','%SQL_C_INTERVAL_MINUTE','%SQL_C_INTERVAL_MINUTE_TO_SECOND',
                        '%SQL_C_INTERVAL_MONTH','%SQL_C_INTERVAL_SECOND','%SQL_C_INTERVAL_YEAR','%SQL_C_INTERVAL_YEAR_TO_MONTH','%SQL_C_LONG','%SQL_C_NUMERIC','%SQL_C_SBIGINT','%SQL_C_SHORT',
                        '%SQL_C_SLONG','%SQL_C_SSHORT','%SQL_C_STINYINT','%SQL_C_TIME','%SQL_C_TIMESTAMP','%SQL_C_TINYINT','%SQL_C_TYPE_DATE','%SQL_C_TYPE_TIME',
                        '%SQL_C_TYPE_TIMESTAMP','%SQL_C_UBIGINT','%SQL_C_ULONG','%SQL_C_USHORT','%SQL_C_UTINYINT','%SQL_C_VARBOOKMARK','%SQL_DATABASE_NAME','%SQL_DATA_AT_EXEC',
                        '%SQL_DATA_SOURCE_NAME','%SQL_DATA_SOURCE_READ_ONLY','%SQL_DATE','%SQL_DATETIME','%SQL_DATETIME_LITERALS','%SQL_DATE_LEN','%SQL_DAY','%SQL_DAY_TO_HOUR',
                        '%SQL_DAY_TO_MINUTE','%SQL_DAY_TO_SECOND','%SQL_DA_DROP_ASSERTION','%SQL_DBMS_NAME','%SQL_DBMS_VER','%SQL_DB_DEFAULT','%SQL_DB_DISCONNECT','%SQL_DB_RETURN_TO_POOL',
                        '%SQL_DCS_DROP_CHARACTER_SET','%SQL_DC_DROP_COLLATION','%SQL_DDL_INDEX','%SQL_DD_CASCADE','%SQL_DD_DROP_DOMAIN','%SQL_DD_RESTRICT','%SQL_DECIMAL','%SQL_DEFAULT',
                        '%SQL_DEFAULT_PARAM','%SQL_DEFAULT_TXN_ISOLATION','%SQL_DELETE','%SQL_DELETE_BY_BOOKMARK','%SQL_DESCRIBE_PARAMETER','%SQL_DESC_ALLOC_AUTO','%SQL_DESC_ALLOC_TYPE','%SQL_DESC_ALLOC_USER',
                        '%SQL_DESC_ARRAY_SIZE','%SQL_DESC_ARRAY_STATUS_PTR','%SQL_DESC_AUTO_UNIQUE_VALUE','%SQL_DESC_BASE_COLUMN_NAME','%SQL_DESC_BASE_TABLE_NAME','%SQL_DESC_BIND_OFFSET_PTR','%SQL_DESC_BIND_TYPE','%SQL_DESC_CASE_SENSITIVE',
                        '%SQL_DESC_CATALOG_NAME','%SQL_DESC_CONCISE_TYPE','%SQL_DESC_COUNT','%SQL_DESC_DATA_PTR','%SQL_DESC_DATETIME_INTERVAL_CODE','%SQL_DESC_DATETIME_INTERVAL_PRECISION','%SQL_DESC_DISPLAY_SIZE','%SQL_DESC_FIXED_PREC_SCALE',
                        '%SQL_DESC_INDICATOR_PTR','%SQL_DESC_LABEL','%SQL_DESC_LENGTH','%SQL_DESC_LITERAL_PREFIX','%SQL_DESC_LITERAL_SUFFIX','%SQL_DESC_LOCAL_TYPE_NAME','%SQL_DESC_MAXIMUM_SCALE','%SQL_DESC_MINIMUM_SCALE',
                        '%SQL_DESC_NAME','%SQL_DESC_NULLABLE','%SQL_DESC_NUM_PREC_RADIX','%SQL_DESC_OCTET_LENGTH','%SQL_DESC_OCTET_LENGTH_PTR','%SQL_DESC_PARAMETER_TYPE','%SQL_DESC_PRECISION','%SQL_DESC_ROWS_PROCESSED_PTR',
                        '%SQL_DESC_SCALE','%SQL_DESC_SCHEMA_NAME','%SQL_DESC_SEARCHABLE','%SQL_DESC_TABLE_NAME','%SQL_DESC_TYPE','%SQL_DESC_TYPE_NAME','%SQL_DESC_UNNAMED','%SQL_DESC_UNSIGNED',
                        '%SQL_DESC_UPDATABLE','%SQL_DIAG_ALTER_TABLE','%SQL_DIAG_CALL','%SQL_DIAG_CLASS_ORIGIN','%SQL_DIAG_COLUMN_NUMBER','%SQL_DIAG_CONNECTION_NAME','%SQL_DIAG_CREATE_INDEX','%SQL_DIAG_CREATE_TABLE',
                        '%SQL_DIAG_CREATE_VIEW','%SQL_DIAG_CURSOR_ROW_COUNT','%SQL_DIAG_DELETE_WHERE','%SQL_DIAG_DROP_INDEX','%SQL_DIAG_DROP_TABLE','%SQL_DIAG_DROP_VIEW','%SQL_DIAG_DYNAMIC_DELETE_CURSOR','%SQL_DIAG_DYNAMIC_FUNCTION',
                        '%SQL_DIAG_DYNAMIC_FUNCTION_CODE','%SQL_DIAG_DYNAMIC_UPDATE_CURSOR','%SQL_DIAG_GRANT','%SQL_DIAG_INSERT','%SQL_DIAG_MESSAGE_TEXT','%SQL_DIAG_NATIVE','%SQL_DIAG_NUMBER','%SQL_DIAG_RETURNCODE',
                        '%SQL_DIAG_REVOKE','%SQL_DIAG_ROW_COUNT','%SQL_DIAG_ROW_NUMBER','%SQL_DIAG_SELECT_CURSOR','%SQL_DIAG_SERVER_NAME','%SQL_DIAG_SQLSTATE','%SQL_DIAG_SUBCLASS_ORIGIN','%SQL_DIAG_UNKNOWN_STATEMENT',
                        '%SQL_DIAG_UPDATE_WHERE','%SQL_DI_CREATE_INDEX','%SQL_DI_DROP_INDEX','%SQL_DL_SQL92_DATE','%SQL_DL_SQL92_INTERVAL_DAY','%SQL_DL_SQL92_INTERVAL_DAY_TO_HOUR','%SQL_DL_SQL92_INTERVAL_DAY_TO_MINUTE','%SQL_DL_SQL92_INTERVAL_DAY_TO_SECOND',
                        '%SQL_DL_SQL92_INTERVAL_HOUR','%SQL_DL_SQL92_INTERVAL_HOUR_TO_MINUTE','%SQL_DL_SQL92_INTERVAL_HOUR_TO_SECOND','%SQL_DL_SQL92_INTERVAL_MINUTE','%SQL_DL_SQL92_INTERVAL_MINUTE_TO_SECOND','%SQL_DL_SQL92_INTERVAL_MONTH','%SQL_DL_SQL92_INTERVAL_SECOND','%SQL_DL_SQL92_INTERVAL_YEAR',
                        '%SQL_DL_SQL92_INTERVAL_YEAR_TO_MONTH','%SQL_DL_SQL92_TIME','%SQL_DL_SQL92_TIMESTAMP','%SQL_DM_VER','%SQL_DOUBLE','%SQL_DRIVER_COMPLETE','%SQL_DRIVER_COMPLETE_REQUIRED','%SQL_DRIVER_HDBC',
                        '%SQL_DRIVER_HDESC','%SQL_DRIVER_HENV','%SQL_DRIVER_HLIB','%SQL_DRIVER_HSTMT','%SQL_DRIVER_NAME','%SQL_DRIVER_NOPROMPT','%SQL_DRIVER_ODBC_VER','%SQL_DRIVER_PROMPT',
                        '%SQL_DRIVER_VER','%SQL_DROP','%SQL_DROP_ASSERTION','%SQL_DROP_CHARACTER_SET','%SQL_DROP_COLLATION','%SQL_DROP_DOMAIN','%SQL_DROP_SCHEMA','%SQL_DROP_TABLE',
                        '%SQL_DROP_TRANSLATION','%SQL_DROP_VIEW','%SQL_DS_CASCADE','%SQL_DS_DROP_SCHEMA','%SQL_DS_RESTRICT','%SQL_DTC_DONE','%SQL_DTC_ENLIST_EXPENSIVE','%SQL_DTC_TRANSITION_COST',
                        '%SQL_DTC_UNENLIST_EXPENSIVE','%SQL_DTR_DROP_TRANSLATION','%SQL_DT_CASCADE','%SQL_DT_DROP_TABLE','%SQL_DT_RESTRICT','%SQL_DV_CASCADE','%SQL_DV_DROP_VIEW','%SQL_DV_RESTRICT',
                        '%SQL_DYNAMIC_CURSOR_ATTRIBUTES1','%SQL_DYNAMIC_CURSOR_ATTRIBUTES2','%SQL_ENSURE','%SQL_ENTIRE_ROWSET','%SQL_ERROR','%SQL_EXPRESSIONS_IN_ORDERBY','%SQL_FALSE','%SQL_FD_FETCH_ABSOLUTE',
                        '%SQL_FD_FETCH_BOOKMARK','%SQL_FD_FETCH_FIRST','%SQL_FD_FETCH_LAST','%SQL_FD_FETCH_NEXT','%SQL_FD_FETCH_PREV','%SQL_FD_FETCH_PRIOR','%SQL_FD_FETCH_RELATIVE','%SQL_FETCH_ABSOLUTE',
                        '%SQL_FETCH_BOOKMARK','%SQL_FETCH_BY_BOOKMARK','%SQL_FETCH_DIRECTION','%SQL_FETCH_FIRST','%SQL_FETCH_FIRST_SYSTEM','%SQL_FETCH_FIRST_USER','%SQL_FETCH_LAST','%SQL_FETCH_NEXT',
                        '%SQL_FETCH_PREV','%SQL_FETCH_PRIOR','%SQL_FETCH_RELATIVE','%SQL_FILE_CATALOG','%SQL_FILE_NOT_SUPPORTED','%SQL_FILE_QUALIFIER','%SQL_FILE_TABLE','%SQL_FILE_USAGE',
                        '%SQL_FLOAT','%SQL_FN_CVT_CAST','%SQL_FN_CVT_CONVERT','%SQL_FN_NUM_ABS','%SQL_FN_NUM_ACOS','%SQL_FN_NUM_ASIN','%SQL_FN_NUM_ATAN','%SQL_FN_NUM_ATAN2',
                        '%SQL_FN_NUM_CEILING','%SQL_FN_NUM_COS','%SQL_FN_NUM_COT','%SQL_FN_NUM_DEGREES','%SQL_FN_NUM_EXP','%SQL_FN_NUM_FLOOR','%SQL_FN_NUM_LOG','%SQL_FN_NUM_LOG10',
                        '%SQL_FN_NUM_MOD','%SQL_FN_NUM_PI','%SQL_FN_NUM_POWER','%SQL_FN_NUM_RADIANS','%SQL_FN_NUM_RAND','%SQL_FN_NUM_ROUND','%SQL_FN_NUM_SIGN','%SQL_FN_NUM_SIN',
                        '%SQL_FN_NUM_SQRT','%SQL_FN_NUM_TAN','%SQL_FN_NUM_TRUNCATE','%SQL_FN_STR_ASCII','%SQL_FN_STR_BIT_LENGTH','%SQL_FN_STR_CHAR','%SQL_FN_STR_CHARACTER_LENGTH','%SQL_FN_STR_CHAR_LENGTH',
                        '%SQL_FN_STR_CONCAT','%SQL_FN_STR_DIFFERENCE','%SQL_FN_STR_INSERT','%SQL_FN_STR_LCASE','%SQL_FN_STR_LEFT','%SQL_FN_STR_LENGTH','%SQL_FN_STR_LOCATE','%SQL_FN_STR_LOCATE_2',
                        '%SQL_FN_STR_LTRIM','%SQL_FN_STR_OCTET_LENGTH','%SQL_FN_STR_POSITION','%SQL_FN_STR_REPEAT','%SQL_FN_STR_REPLACE','%SQL_FN_STR_RIGHT','%SQL_FN_STR_RTRIM','%SQL_FN_STR_SOUNDEX',
                        '%SQL_FN_STR_SPACE','%SQL_FN_STR_SUBSTRING','%SQL_FN_STR_UCASE','%SQL_FN_SYS_DBNAME','%SQL_FN_SYS_IFNULL','%SQL_FN_SYS_USERNAME','%SQL_FN_TD_CURDATE','%SQL_FN_TD_CURRENT_DATE',
                        '%SQL_FN_TD_CURRENT_TIME','%SQL_FN_TD_CURRENT_TIMESTAMP','%SQL_FN_TD_CURTIME','%SQL_FN_TD_DAYNAME','%SQL_FN_TD_DAYOFMONTH','%SQL_FN_TD_DAYOFWEEK','%SQL_FN_TD_DAYOFYEAR','%SQL_FN_TD_EXTRACT',
                        '%SQL_FN_TD_HOUR','%SQL_FN_TD_MINUTE','%SQL_FN_TD_MONTH','%SQL_FN_TD_MONTHNAME','%SQL_FN_TD_NOW','%SQL_FN_TD_QUARTER','%SQL_FN_TD_SECOND','%SQL_FN_TD_TIMESTAMPADD',
                        '%SQL_FN_TD_TIMESTAMPDIFF','%SQL_FN_TD_WEEK','%SQL_FN_TD_YEAR','%SQL_FN_TSI_DAY','%SQL_FN_TSI_FRAC_SECOND','%SQL_FN_TSI_HOUR','%SQL_FN_TSI_MINUTE','%SQL_FN_TSI_MONTH',
                        '%SQL_FN_TSI_QUARTER','%SQL_FN_TSI_SECOND','%SQL_FN_TSI_WEEK','%SQL_FN_TSI_YEAR','%SQL_FORWARD_ONLY_CURSOR_ATTRIBUTES1','%SQL_FORWARD_ONLY_CURSOR_ATTRIBUTES2','%SQL_GB_COLLATE','%SQL_GB_GROUP_BY_CONTAINS_SELECT',
                        '%SQL_GB_GROUP_BY_EQUALS_SELECT','%SQL_GB_NOT_SUPPORTED','%SQL_GB_NO_RELATION','%SQL_GD_ANY_COLUMN','%SQL_GD_ANY_ORDER','%SQL_GD_BLOCK','%SQL_GD_BOUND','%SQL_GETDATA_EXTENSIONS',
                        '%SQL_GET_BOOKMARK','%SQL_GROUP_BY','%SQL_GUID','%SQL_HANDLE_DBC','%SQL_HANDLE_DESC','%SQL_HANDLE_ENV','%SQL_HANDLE_SENV','%SQL_HANDLE_STMT',
                        '%SQL_HOUR','%SQL_HOUR_TO_MINUTE','%SQL_HOUR_TO_SECOND','%SQL_IC_LOWER','%SQL_IC_MIXED','%SQL_IC_SENSITIVE','%SQL_IC_UPPER','%SQL_IDENTIFIER_CASE',
                        '%SQL_IDENTIFIER_QUOTE_CHAR','%SQL_IGNORE','%SQL_IK_ALL','%SQL_IK_ASC','%SQL_IK_DESC','%SQL_IK_NONE','%SQL_INDEX_ALL','%SQL_INDEX_CLUSTERED',
                        '%SQL_INDEX_HASHED','%SQL_INDEX_KEYWORDS','%SQL_INDEX_OTHER','%SQL_INDEX_UNIQUE','%SQL_INFO_FIRST','%SQL_INFO_SCHEMA_VIEWS','%SQL_INITIALLY_DEFERRED','%SQL_INITIALLY_IMMEDIATE',
                        '%SQL_INSENSITIVE','%SQL_INSERT_STATEMENT','%SQL_INTEGER','%SQL_INTEGRITY','%SQL_INTERVAL','%SQL_INTERVAL_DAY','%SQL_INTERVAL_DAY_TO_HOUR','%SQL_INTERVAL_DAY_TO_MINUTE',
                        '%SQL_INTERVAL_DAY_TO_SECOND','%SQL_INTERVAL_HOUR','%SQL_INTERVAL_HOUR_TO_MINUTE','%SQL_INTERVAL_HOUR_TO_SECOND','%SQL_INTERVAL_MINUTE','%SQL_INTERVAL_MINUTE_TO_SECOND','%SQL_INTERVAL_MONTH','%SQL_INTERVAL_SECOND',
                        '%SQL_INTERVAL_YEAR','%SQL_INTERVAL_YEAR_TO_MONTH','%SQL_INVALID_HANDLE','%SQL_ISV_ASSERTIONS','%SQL_ISV_CHARACTER_SETS','%SQL_ISV_CHECK_CONSTRAINTS','%SQL_ISV_COLLATIONS','%SQL_ISV_COLUMNS',
                        '%SQL_ISV_COLUMN_DOMAIN_USAGE','%SQL_ISV_COLUMN_PRIVILEGES','%SQL_ISV_CONSTRAINT_COLUMN_USAGE','%SQL_ISV_CONSTRAINT_TABLE_USAGE','%SQL_ISV_DOMAINS','%SQL_ISV_DOMAIN_CONSTRAINTS','%SQL_ISV_KEY_COLUMN_USAGE','%SQL_ISV_REFERENTIAL_CONSTRAINTS',
                        '%SQL_ISV_SCHEMATA','%SQL_ISV_SQL_LANGUAGES','%SQL_ISV_TABLES','%SQL_ISV_TABLE_CONSTRAINTS','%SQL_ISV_TABLE_PRIVILEGES','%SQL_ISV_TRANSLATIONS','%SQL_ISV_USAGE_PRIVILEGES','%SQL_ISV_VIEWS',
                        '%SQL_ISV_VIEW_COLUMN_USAGE','%SQL_ISV_VIEW_TABLE_USAGE','%SQL_IS_DAY','%SQL_IS_DAY_TO_HOUR','%SQL_IS_DAY_TO_MINUTE','%SQL_IS_DAY_TO_SECOND','%SQL_IS_HOUR','%SQL_IS_HOUR_TO_MINUTE',
                        '%SQL_IS_HOUR_TO_SECOND','%SQL_IS_INSERT_LITERALS','%SQL_IS_INSERT_SEARCHED','%SQL_IS_INTEGER','%SQL_IS_MINUTE','%SQL_IS_MINUTE_TO_SECOND','%SQL_IS_MONTH','%SQL_IS_POINTER',
                        '%SQL_IS_SECOND','%SQL_IS_SELECT_INTO','%SQL_IS_SMALLINT','%SQL_IS_UINTEGER','%SQL_IS_USMALLINT','%SQL_IS_YEAR','%SQL_IS_YEAR_TO_MONTH','%SQL_KEYSET_CURSOR_ATTRIBUTES1',
                        '%SQL_KEYSET_CURSOR_ATTRIBUTES2','%SQL_KEYSET_SIZE','%SQL_KEYSET_SIZE_DEFAULT','%SQL_KEYWORDS','%SQL_LCK_EXCLUSIVE','%SQL_LCK_NO_CHANGE','%SQL_LCK_UNLOCK','%SQL_LEN_BINARY_ATTR_OFFSET',
                        '%SQL_LEN_DATA_AT_EXEC_OFFSET','%SQL_LIKE_ESCAPE_CLAUSE','%SQL_LIKE_ONLY','%SQL_LOCK_EXCLUSIVE','%SQL_LOCK_NO_CHANGE','%SQL_LOCK_TYPES','%SQL_LOCK_UNLOCK','%SQL_LOGIN_TIMEOUT',
                        '%SQL_LOGIN_TIMEOUT_DEFAULT','%SQL_LONGVARBINARY','%SQL_LONGVARCHAR','%SQL_MAXIMUM_CATALOG_NAME_LENGTH','%SQL_MAXIMUM_COLUMNS_IN_GROUP_BY','%SQL_MAXIMUM_COLUMNS_IN_INDEX','%SQL_MAXIMUM_COLUMNS_IN_ORDER_BY','%SQL_MAXIMUM_COLUMNS_IN_SELECT',
                        '%SQL_MAXIMUM_COLUMN_NAME_LENGTH','%SQL_MAXIMUM_CONCURRENT_ACTIVITIES','%SQL_MAXIMUM_CURSOR_NAME_LENGTH','%SQL_MAXIMUM_DRIVER_CONNECTIONS','%SQL_MAXIMUM_IDENTIFIER_LENGTH','%SQL_MAXIMUM_INDEX_SIZE','%SQL_MAXIMUM_ROW_SIZE','%SQL_MAXIMUM_SCHEMA_NAME_LENGTH',
                        '%SQL_MAXIMUM_STATEMENT_LENGTH','%SQL_MAXIMUM_TABLES_IN_SELECT','%SQL_MAXIMUM_USER_NAME_LENGTH','%SQL_MAX_ASYNC_CONCURRENT_STATEMENTS','%SQL_MAX_BINARY_LITERAL_LEN','%SQL_MAX_CATALOG_NAME_LEN','%SQL_MAX_CHAR_LITERAL_LEN','%SQL_MAX_COLUMNS_IN_GROUP_BY',
                        '%SQL_MAX_COLUMNS_IN_INDEX','%SQL_MAX_COLUMNS_IN_ORDER_BY','%SQL_MAX_COLUMNS_IN_SELECT','%SQL_MAX_COLUMNS_IN_TABLE','%SQL_MAX_COLUMN_NAME_LEN','%SQL_MAX_CONCURRENT_ACTIVITIES','%SQL_MAX_CURSOR_NAME_LEN','%SQL_MAX_DRIVER_CONNECTIONS',
                        '%SQL_MAX_DSN_LENGTH','%SQL_MAX_IDENTIFIER_LEN','%SQL_MAX_INDEX_SIZE','%SQL_MAX_LENGTH','%SQL_MAX_LENGTH_DEFAULT','%SQL_MAX_MESSAGE_LENGTH','%SQL_MAX_NUMERIC_LEN','%SQL_MAX_OPTION_STRING_LENGTH',
                        '%SQL_MAX_OWNER_NAME_LEN','%SQL_MAX_PROCEDURE_NAME_LEN','%SQL_MAX_QUALIFIER_NAME_LEN','%SQL_MAX_ROWS','%SQL_MAX_ROWS_DEFAULT','%SQL_MAX_ROW_SIZE','%SQL_MAX_ROW_SIZE_INCLUDES_LONG','%SQL_MAX_SCHEMA_NAME_LEN',
                        '%SQL_MAX_STATEMENT_LEN','%SQL_MAX_TABLES_IN_SELECT','%SQL_MAX_TABLE_NAME_LEN','%SQL_MAX_USER_NAME_LEN','%SQL_MINUTE','%SQL_MINUTE_TO_SECOND','%SQL_MODE_DEFAULT','%SQL_MODE_READ_ONLY',
                        '%SQL_MODE_READ_WRITE','%SQL_MONTH','%SQL_MULTIPLE_ACTIVE_TXN','%SQL_MULT_RESULT_SETS','%SQL_NAMED','%SQL_NC_END','%SQL_NC_HIGH','%SQL_NC_LOW',
                        '%SQL_NC_START','%SQL_NEED_DATA','%SQL_NEED_LONG_DATA_LEN','%SQL_NNC_NON_NULL','%SQL_NNC_NULL','%SQL_NONSCROLLABLE','%SQL_NON_NULLABLE_COLUMNS','%SQL_NOSCAN',
                        '%SQL_NOSCAN_DEFAULT','%SQL_NOSCAN_OFF','%SQL_NOSCAN_ON','%SQL_NOT_DEFERRABLE','%SQL_NO_ACTION','%SQL_NO_COLUMN_NUMBER','%SQL_NO_DATA','%SQL_NO_DATA_FOUND',
                        '%SQL_NO_NULLS','%SQL_NO_ROW_NUMBER','%SQL_NO_TOTAL','%SQL_NTS','%SQL_NTSL','%SQL_NULLABLE','%SQL_NULLABLE_UNKNOWN','%SQL_NULL_COLLATION',
                        '%SQL_NULL_DATA','%SQL_NULL_HANDLE','%SQL_NULL_HDBC','%SQL_NULL_HDESC','%SQL_NULL_HENV','%SQL_NULL_HSTMT','%SQL_NUMERIC','%SQL_NUMERIC_FUNCTIONS',
                        '%SQL_OAC_LEVEL1','%SQL_OAC_LEVEL2','%SQL_OAC_NONE','%SQL_ODBC_API_CONFORMANCE','%SQL_ODBC_CURSORS','%SQL_ODBC_INTERFACE_CONFORMANCE','%SQL_ODBC_SAG_CLI_CONFORMANCE','%SQL_ODBC_SQL_CONFORMANCE',
                        '%SQL_ODBC_SQL_OPT_IEF','%SQL_ODBC_VER','%SQL_OIC_CORE','%SQL_OIC_LEVEL1','%SQL_OIC_LEVEL2','%SQL_OJ_ALL_COMPARISON_OPS','%SQL_OJ_CAPABILITIES','%SQL_OJ_FULL',
                        '%SQL_OJ_INNER','%SQL_OJ_LEFT','%SQL_OJ_NESTED','%SQL_OJ_NOT_ORDERED','%SQL_OJ_RIGHT','%SQL_OPT_TRACE','%SQL_OPT_TRACEFILE','%SQL_OPT_TRACE_DEFAULT',
                        '%SQL_OPT_TRACE_OFF','%SQL_OPT_TRACE_ON','%SQL_ORDER_BY_COLUMNS_IN_SELECT','%SQL_OSCC_COMPLIANT','%SQL_OSCC_NOT_COMPLIANT','%SQL_OSC_CORE','%SQL_OSC_EXTENDED','%SQL_OSC_MINIMUM',
                        '%SQL_OUTER_JOINS','%SQL_OUTER_JOIN_CAPABILITIES','%SQL_OU_DML_STATEMENTS','%SQL_OU_INDEX_DEFINITION','%SQL_OU_PRIVILEGE_DEFINITION','%SQL_OU_PROCEDURE_INVOCATION','%SQL_OU_TABLE_DEFINITION','%SQL_OV_ODBC2',
                        '%SQL_OV_ODBC3','%SQL_OWNER_TERM','%SQL_OWNER_USAGE','%SQL_PACKET_SIZE','%SQL_PARAM_ARRAY_ROW_COUNTS','%SQL_PARAM_ARRAY_SELECTS','%SQL_PARAM_BIND_BY_COLUMN','%SQL_PARAM_BIND_TYPE_DEFAULT',
                        '%SQL_PARAM_DIAG_UNAVAILABLE','%SQL_PARAM_ERROR','%SQL_PARAM_IGNORE','%SQL_PARAM_INPUT','%SQL_PARAM_INPUT_OUTPUT','%SQL_PARAM_OUTPUT','%SQL_PARAM_PROCEED','%SQL_PARAM_SUCCESS',
                        '%SQL_PARAM_SUCCESS_WITH_INFO','%SQL_PARAM_TYPE_DEFAULT','%SQL_PARAM_TYPE_UNKNOWN','%SQL_PARAM_UNUSED','%SQL_PARC_BATCH','%SQL_PARC_NO_BATCH','%SQL_PAS_BATCH','%SQL_PAS_NO_BATCH',
                        '%SQL_PAS_NO_SELECT','%SQL_PC_NON_PSEUDO','%SQL_PC_NOT_PSEUDO','%SQL_PC_PSEUDO','%SQL_PC_UNKNOWN','%SQL_POSITION','%SQL_POSITIONED_STATEMENTS','%SQL_POS_ADD',
                        '%SQL_POS_DELETE','%SQL_POS_OPERATIONS','%SQL_POS_POSITION','%SQL_POS_REFRESH','%SQL_POS_UPDATE','%SQL_PRED_BASIC','%SQL_PRED_CHAR','%SQL_PRED_NONE',
                        '%SQL_PRED_SEARCHABLE','%SQL_PROCEDURES','%SQL_PROCEDURE_TERM','%SQL_PS_POSITIONED_DELETE','%SQL_PS_POSITIONED_UPDATE','%SQL_PS_SELECT_FOR_UPDATE','%SQL_PT_FUNCTION','%SQL_PT_PROCEDURE',
                        '%SQL_PT_UNKNOWN','%SQL_QL_END','%SQL_QL_START','%SQL_QUALIFIER_LOCATION','%SQL_QUALIFIER_NAME_SEPARATOR','%SQL_QUALIFIER_TERM','%SQL_QUALIFIER_USAGE','%SQL_QUERY_TIMEOUT',
                        '%SQL_QUERY_TIMEOUT_DEFAULT','%SQL_QUICK','%SQL_QUIET_MODE','%SQL_QUOTED_IDENTIFIER_CASE','%SQL_QU_DML_STATEMENTS','%SQL_QU_INDEX_DEFINITION','%SQL_QU_PRIVILEGE_DEFINITION','%SQL_QU_PROCEDURE_INVOCATION',
                        '%SQL_QU_TABLE_DEFINITION','%SQL_RD_DEFAULT','%SQL_RD_OFF','%SQL_RD_ON','%SQL_REAL','%SQL_REFRESH','%SQL_RESET_PARAMS','%SQL_RESTRICT',
                        '%SQL_RESULT_COL','%SQL_RETRIEVE_DATA','%SQL_RETURN_VALUE','%SQL_ROLLBACK','%SQL_ROWSET_SIZE','%SQL_ROWSET_SIZE_DEFAULT','%SQL_ROWVER','%SQL_ROW_ADDED',
                        '%SQL_ROW_DELETED','%SQL_ROW_ERROR','%SQL_ROW_IDENTIFIER','%SQL_ROW_IGNORE','%SQL_ROW_NOROW','%SQL_ROW_NUMBER','%SQL_ROW_NUMBER_UNKNOWN','%SQL_ROW_PROCEED',
                        '%SQL_ROW_SUCCESS','%SQL_ROW_SUCCESS_WITH_INFO','%SQL_ROW_UPDATED','%SQL_ROW_UPDATES','%SQL_SCCO_LOCK','%SQL_SCCO_OPT_ROWVER','%SQL_SCCO_OPT_TIMESTAMP','%SQL_SCCO_OPT_VALUES',
                        '%SQL_SCCO_READ_ONLY','%SQL_SCC_ISO92_CLI','%SQL_SCC_XOPEN_CLI_VERSION1','%SQL_SCHEMA_TERM','%SQL_SCHEMA_USAGE','%SQL_SCOPE_CURROW','%SQL_SCOPE_SESSION','%SQL_SCOPE_TRANSACTION',
                        '%SQL_SCROLLABLE','%SQL_SCROLL_CONCURRENCY','%SQL_SCROLL_DYNAMIC','%SQL_SCROLL_FORWARD_ONLY','%SQL_SCROLL_KEYSET_DRIVEN','%SQL_SCROLL_OPTIONS','%SQL_SCROLL_STATIC','%SQL_SC_FIPS127_2_TRANSITIONAL',
                        '%SQL_SC_NON_UNIQUE','%SQL_SC_SQL92_ENTRY','%SQL_SC_SQL92_FULL','%SQL_SC_SQL92_INTERMEDIATE','%SQL_SC_TRY_UNIQUE','%SQL_SC_UNIQUE','%SQL_SDF_CURRENT_DATE','%SQL_SDF_CURRENT_TIME',
                        '%SQL_SDF_CURRENT_TIMESTAMP','%SQL_SEARCHABLE','%SQL_SEARCH_PATTERN_ESCAPE','%SQL_SECOND','%SQL_SENSITIVE','%SQL_SERVER_NAME','%SQL_SETPARAM_VALUE_MAX','%SQL_SETPOS_MAX_LOCK_VALUE',
                        '%SQL_SETPOS_MAX_OPTION_VALUE','%SQL_SET_DEFAULT','%SQL_SET_NULL','%SQL_SFKD_CASCADE','%SQL_SFKD_NO_ACTION','%SQL_SFKD_SET_DEFAULT','%SQL_SFKD_SET_NULL','%SQL_SFKU_CASCADE',
                        '%SQL_SFKU_NO_ACTION','%SQL_SFKU_SET_DEFAULT','%SQL_SFKU_SET_NULL','%SQL_SG_DELETE_TABLE','%SQL_SG_INSERT_COLUMN','%SQL_SG_INSERT_TABLE','%SQL_SG_REFERENCES_COLUMN','%SQL_SG_REFERENCES_TABLE',
                        '%SQL_SG_SELECT_TABLE','%SQL_SG_UPDATE_COLUMN','%SQL_SG_UPDATE_TABLE','%SQL_SG_USAGE_ON_CHARACTER_SET','%SQL_SG_USAGE_ON_COLLATION','%SQL_SG_USAGE_ON_DOMAIN','%SQL_SG_USAGE_ON_TRANSLATION','%SQL_SG_WITH_GRANT_OPTION',
                        '%SQL_SIGNED_OFFSET','%SQL_SIMULATE_CURSOR','%SQL_SMALLINT','%SQL_SNVF_BIT_LENGTH','%SQL_SNVF_CHARACTER_LENGTH','%SQL_SNVF_CHAR_LENGTH','%SQL_SNVF_EXTRACT','%SQL_SNVF_OCTET_LENGTH',
                        '%SQL_SNVF_POSITION','%SQL_SO_DYNAMIC','%SQL_SO_FORWARD_ONLY','%SQL_SO_KEYSET_DRIVEN','%SQL_SO_MIXED','%SQL_SO_STATIC','%SQL_SPECIAL_CHARACTERS','%SQL_SPEC_MAJOR',
                        '%SQL_SPEC_MINOR','%SQL_SP_BETWEEN','%SQL_SP_COMPARISON','%SQL_SP_EXISTS','%SQL_SP_IN','%SQL_SP_ISNOTNULL','%SQL_SP_ISNULL','%SQL_SP_LIKE',
                        '%SQL_SP_MATCH_FULL','%SQL_SP_MATCH_PARTIAL','%SQL_SP_MATCH_UNIQUE_FULL','%SQL_SP_MATCH_UNIQUE_PARTIAL','%SQL_SP_OVERLAPS','%SQL_SP_QUANTIFIED_COMPARISON','%SQL_SP_UNIQUE','%SQL_SQL92_DATETIME_FUNCTIONS',
                        '%SQL_SQL92_FOREIGN_KEY_DELETE_RULE','%SQL_SQL92_FOREIGN_KEY_UPDATE_RULE','%SQL_SQL92_GRANT','%SQL_SQL92_NUMERIC_VALUE_FUNCTIONS','%SQL_SQL92_PREDICATES','%SQL_SQL92_RELATIONAL_JOIN_OPERATORS','%SQL_SQL92_REVOKE','%SQL_SQL92_ROW_VALUE_CONSTRUCTOR',
                        '%SQL_SQL92_STRING_FUNCTIONS','%SQL_SQL92_VALUE_EXPRESSIONS','%SQL_SQLSTATE_SIZE','%SQL_SQL_CONFORMANCE','%SQL_SQ_COMPARISON','%SQL_SQ_CORRELATED_SUBQUERIES','%SQL_SQ_EXISTS','%SQL_SQ_IN',
                        '%SQL_SQ_QUANTIFIED','%SQL_SRJO_CORRESPONDING_CLAUSE','%SQL_SRJO_CROSS_JOIN','%SQL_SRJO_EXCEPT_JOIN','%SQL_SRJO_FULL_OUTER_JOIN','%SQL_SRJO_INNER_JOIN','%SQL_SRJO_INTERSECT_JOIN','%SQL_SRJO_LEFT_OUTER_JOIN',
                        '%SQL_SRJO_NATURAL_JOIN','%SQL_SRJO_RIGHT_OUTER_JOIN','%SQL_SRJO_UNION_JOIN','%SQL_SRVC_DEFAULT','%SQL_SRVC_NULL','%SQL_SRVC_ROW_SUBQUERY','%SQL_SRVC_VALUE_EXPRESSION','%SQL_SR_CASCADE',
                        '%SQL_SR_DELETE_TABLE','%SQL_SR_GRANT_OPTION_FOR','%SQL_SR_INSERT_COLUMN','%SQL_SR_INSERT_TABLE','%SQL_SR_REFERENCES_COLUMN','%SQL_SR_REFERENCES_TABLE','%SQL_SR_RESTRICT','%SQL_SR_SELECT_TABLE',
                        '%SQL_SR_UPDATE_COLUMN','%SQL_SR_UPDATE_TABLE','%SQL_SR_USAGE_ON_CHARACTER_SET','%SQL_SR_USAGE_ON_COLLATION','%SQL_SR_USAGE_ON_DOMAIN','%SQL_SR_USAGE_ON_TRANSLATION','%SQL_SSF_CONVERT','%SQL_SSF_LOWER',
                        '%SQL_SSF_SUBSTRING','%SQL_SSF_TRANSLATE','%SQL_SSF_TRIM_BOTH','%SQL_SSF_TRIM_LEADING','%SQL_SSF_TRIM_TRAILING','%SQL_SSF_UPPER','%SQL_SS_ADDITIONS','%SQL_SS_DELETIONS',
                        '%SQL_SS_UPDATES','%SQL_STANDARD_CLI_CONFORMANCE','%SQL_STATIC_CURSOR_ATTRIBUTES1','%SQL_STATIC_CURSOR_ATTRIBUTES2','%SQL_STATIC_SENSITIVITY','%SQL_STILL_EXECUTING','%SQL_STRING_FUNCTIONS','%SQL_SUBQUERIES',
                        '%SQL_SUCCESS','%SQL_SUCCESS_WITH_INFO','%SQL_SU_DML_STATEMENTS','%SQL_SU_INDEX_DEFINITION','%SQL_SU_PRIVILEGE_DEFINITION','%SQL_SU_PROCEDURE_INVOCATION','%SQL_SU_TABLE_DEFINITION','%SQL_SVE_CASE',
                        '%SQL_SVE_CAST','%SQL_SVE_COALESCE','%SQL_SVE_NULLIF','%SQL_SYSTEM_FUNCTIONS','%SQL_TABLE_STAT','%SQL_TABLE_TERM','%SQL_TC_ALL','%SQL_TC_DDL_COMMIT',
                        '%SQL_TC_DDL_IGNORE','%SQL_TC_DML','%SQL_TC_NONE','%SQL_TIME','%SQL_TIMEDATE_ADD_INTERVALS','%SQL_TIMEDATE_DIFF_INTERVALS','%SQL_TIMEDATE_FUNCTIONS','%SQL_TIMESTAMP',
                        '%SQL_TIMESTAMP_LEN','%SQL_TIME_LEN','%SQL_TINYINT','%SQL_TRANSACTION_CAPABLE','%SQL_TRANSACTION_ISOLATION_OPTION','%SQL_TRANSACTION_READ_COMMITTED','%SQL_TRANSACTION_READ_UNCOMMITTED','%SQL_TRANSACTION_REPEATABLE_READ',
                        '%SQL_TRANSACTION_SERIALIZABLE','%SQL_TRANSLATE_DLL','%SQL_TRANSLATE_OPTION','%SQL_TRUE','%SQL_TXN_CAPABLE','%SQL_TXN_ISOLATION','%SQL_TXN_ISOLATION_OPTION','%SQL_TXN_READ_COMMITTED',
                        '%SQL_TXN_READ_UNCOMMITTED','%SQL_TXN_REPEATABLE_READ','%SQL_TXN_SERIALIZABLE','%SQL_TYPE_DATE','%SQL_TYPE_NULL','%SQL_TYPE_TIME','%SQL_TYPE_TIMESTAMP','%SQL_UB_DEFAULT',
                        '%SQL_UB_FIXED','%SQL_UB_OFF','%SQL_UB_ON','%SQL_UB_VARIABLE','%SQL_UNBIND','%SQL_UNICODE','%SQL_UNICODE_CHAR','%SQL_UNICODE_LONGVARCHAR',
                        '%SQL_UNICODE_VARCHAR','%SQL_UNION','%SQL_UNION_STATEMENT','%SQL_UNKNOWN_TYPE','%SQL_UNNAMED','%SQL_UNSEARCHABLE','%SQL_UNSIGNED_OFFSET','%SQL_UNSPECIFIED',
                        '%SQL_UPDATE','%SQL_UPDATE_BY_BOOKMARK','%SQL_USER_NAME','%SQL_USE_BOOKMARKS','%SQL_US_UNION','%SQL_US_UNION_ALL','%SQL_U_UNION','%SQL_U_UNION_ALL',
                        '%SQL_VARBINARY','%SQL_VARCHAR','%SQL_XOPEN_CLI_YEAR','%SQL_YEAR','%SQL_YEAR_TO_MONTH','%SS_BITMAP','%SS_BLACKFRAME','%SS_BLACKRECT',
                        '%SS_CENTER','%SS_CENTERIMAGE','%SS_ENDELLIPSIS','%SS_ETCHEDFRAME','%SS_ETCHEDHORZ','%SS_ETCHEDVERT','%SS_GRAYFRAME','%SS_GRAYRECT',
                        '%SS_LEFT','%SS_NOPREFIX','%SS_NOTIFY','%SS_NOWORDWRAP','%SS_PATHELLIPSIS','%SS_RIGHT','%SS_RIGHTJUST','%SS_SIMPLE',
                        '%SS_SUNKEN','%SS_WHITEFRAME','%SS_WHITERECT','%SS_WORDELLIPSIS','%STAT_FILL_NATURAL','%STAT_FILL_NATURAL_ERASTONE','%STAT_FILL_NATURAL_EVEN','%STAT_FILL_NATURAL_FIBONACCI',
                        '%STAT_FILL_NATURAL_ODD','%STAT_FILL_WITH_NUMBER','%STAT_MINMAX_INDEX','%STAT_MINMAX_VALUE','%SW_FORCEMINIMIZE','%SW_HIDE','%SW_MAXIMIZE','%SW_MINIMIZE',
                        '%SW_NORMAL','%SW_RESTORE','%SW_SHOW','%SW_SHOWDEFAULT','%SW_SHOWMAXIMIZED','%SW_SHOWMINIMIZED','%SW_SHOWMINNOACTIVE','%SW_SHOWNA',
                        '%SW_SHOWNOACTIVATE','%SW_SHOWNORMAL','%TBGL_ERROR_FILE','%TBGL_ERROR_MSGBOX','%TBGL_ERROR_NONE','%TBGL_M15B','%TBGL_M15G','%TBGL_M15LAYER',
                        '%TBGL_M15PSTOP','%TBGL_M15R','%TBGL_M15TEXN','%TBGL_M15TEXX','%TBGL_M15TEXY','%TBGL_M15X','%TBGL_M15Y','%TBGL_M15Z',
                        '%TBGL_NORMAL_PRECISE','%TBGL_NORMAL_SMOOTH','%TBGL_TEX_LINEAR','%TBGL_TEX_MIPMAP','%TBGL_TEX_NEAREST','%TB_%VT_BSTR','%TB_%VT_CY','%TB_%VT_DATE',
                        '%TB_%VT_EMPTY','%TB_%VT_I2','%TB_%VT_I4','%TB_%VT_NULL','%TB_%VT_R4','%TB_%VT_R8','%TB_CLASS_E_NOAGGREGATION','%TB_CO_E_CLASSSTRING',
                        '%TB_DISPATCH_METHOD','%TB_DISPATCH_PROPERTYGET','%TB_DISPATCH_PROPERTYPUT','%TB_DISPATCH_PROPERTYPUTREF','%TB_E_INVALIDARG','%TB_E_NOINTERFACE','%TB_E_OUTOFMEMORY','%TB_MK_E_CONNECTMANUALLY',
                        '%TB_MK_E_EXCEEDEDDEADLINE','%TB_MK_E_INTERMEDIATEINTERFACENOTSUPPORTED','%TB_MK_E_NOOBJECT','%TB_MK_E_SYNTAX','%TB_REGDB_E_CLASSNOTREG','%TB_REGDB_E_WRITEREGDB','%TB_SIZEOF_TBVARIANT','%TB_S_FALSE',
                        '%TB_S_OK','%TCM_FIRST','%TCS_BOTTOM','%TCS_BUTTONS','%TCS_EX_FLATSEPARATORS','%TCS_EX_REGISTERDROP','%TCS_FIXEDWIDTH','%TCS_FLATBUTTONS',
                        '%TCS_FOCUSNEVER','%TCS_FOCUSONBUTTONDOWN','%TCS_FORCEICONLEFT','%TCS_FORCELABELLEFT','%TCS_HOTTRACK','%TCS_MULTILINE','%TCS_MULTISELECT','%TCS_OWNERDRAWFIXED',
                        '%TCS_RAGGEDRIGHT','%TCS_RIGHT','%TCS_RIGHTJUSTIFY','%TCS_SCROLLOPPOSITE','%TCS_SINGLELINE','%TCS_TABS','%TCS_TOOLTIPS','%TCS_VERTICAL',
                        '%TM_PLAINTEXT','%TM_RICHTEXT','%TOKENIZER_DELIMITER','%TOKENIZER_EOL','%TOKENIZER_ERROR','%TOKENIZER_FINISHED','%TOKENIZER_NUMBER','%TOKENIZER_QUOTE',
                        '%TOKENIZER_STRING','%TOKENIZER_UNDEFTOK','%TRUE','%TV_FIRST','%VK_0','%VK_1','%VK_2','%VK_3',
                        '%VK_4','%VK_5','%VK_6','%VK_7','%VK_8','%VK_9','%VK_A','%VK_ACCEPT',
                        '%VK_ADD','%VK_APPS','%VK_B','%VK_BACK','%VK_C','%VK_CANCEL','%VK_CAPITAL','%VK_CLEAR',
                        '%VK_CONTROL','%VK_CONVERT','%VK_D','%VK_DECIMAL','%VK_DELETE','%VK_DIVIDE','%VK_DOWN','%VK_E',
                        '%VK_END','%VK_ESCAPE','%VK_EXECUTE','%VK_F','%VK_F1','%VK_F10','%VK_F11','%VK_F12',
                        '%VK_F13','%VK_F14','%VK_F15','%VK_F16','%VK_F17','%VK_F18','%VK_F19','%VK_F2',
                        '%VK_F20','%VK_F21','%VK_F22','%VK_F23','%VK_F24','%VK_F3','%VK_F4','%VK_F5',
                        '%VK_F6','%VK_F7','%VK_F8','%VK_F9','%VK_FINAL','%VK_G','%VK_H','%VK_HANGEUL',
                        '%VK_HANGUL','%VK_HANJA','%VK_HELP','%VK_HOME','%VK_I','%VK_INSERT','%VK_J','%VK_JUNJA',
                        '%VK_K','%VK_KANA','%VK_KANJI','%VK_L','%VK_LBUTTON','%VK_LEFT','%VK_LINEFEED','%VK_LWIN',
                        '%VK_M','%VK_MBUTTON','%VK_MENU','%VK_MODECHANGE','%VK_MULTIPLY','%VK_N','%VK_NEXT','%VK_NONCONVERT',
                        '%VK_NUMLOCK','%VK_NUMPAD0','%VK_NUMPAD1','%VK_NUMPAD2','%VK_NUMPAD3','%VK_NUMPAD4','%VK_NUMPAD5','%VK_NUMPAD6',
                        '%VK_NUMPAD7','%VK_NUMPAD8','%VK_NUMPAD9','%VK_O','%VK_P','%VK_PAUSE','%VK_PGDN','%VK_PGUP',
                        '%VK_PRINT','%VK_PRIOR','%VK_Q','%VK_R','%VK_RBUTTON','%VK_RETURN','%VK_RIGHT','%VK_RWIN',
                        '%VK_S','%VK_SCROLL','%VK_SELECT','%VK_SEPARATOR','%VK_SHIFT','%VK_SLEEP','%VK_SNAPSHOT','%VK_SPACE',
                        '%VK_SUBTRACT','%VK_T','%VK_TAB','%VK_U','%VK_UP','%VK_V','%VK_W','%VK_X',
                        '%VK_XBUTTON1','%VK_XBUTTON2','%VK_Y','%VK_Z','%VT_ARRAY','%VT_BLOB','%VT_BLOB_OBJECT','%VT_BOOL',
                        '%VT_BSTR','%VT_BYREF','%VT_CARRAY','%VT_CF','%VT_CLSID','%VT_CY','%VT_DATE','%VT_DISPATCH',
                        '%VT_EMPTY','%VT_ERROR','%VT_FILETIME','%VT_HRESULT','%VT_I1','%VT_I2','%VT_I4','%VT_I8',
                        '%VT_INT','%VT_LPSTR','%VT_LPWSTR','%VT_NULL','%VT_PTR','%VT_R4','%VT_R8','%VT_RECORD',
                        '%VT_RESERVED','%VT_SAFEARRAY','%VT_STORAGE','%VT_STORED_OBJECT','%VT_STREAM','%VT_STREAMED_OBJECT','%VT_UI1','%VT_UI2',
                        '%VT_UI4','%VT_UI8','%VT_UINT','%VT_UNKNOWN','%VT_USERDEFINED','%VT_VARIANT','%VT_VECTOR','%VT_VOID',
                        '%WBF_CUSTOM','%WBF_LEVEL1','%WBF_LEVEL2','%WBF_OVERFLOW','%WBF_WORDBREAK','%WBF_WORDWRAP','%WHITE','%WIN_FINDTITLECONTAIN',
                        '%WIN_FINDTITLEEND','%WIN_FINDTITLEEQUAL','%WIN_FINDTITLESTART','%WM_ACTIVATE','%WM_ACTIVATEAPP','%WM_CAPTURECHANGED','%WM_CHAR','%WM_CLOSE',
                        '%WM_COMMAND','%WM_DESTROY','%WM_GETTEXTLENGTH','%WM_HOTKEY','%WM_INITDIALOG','%WM_KEYDOWN','%WM_KEYUP','%WM_KILLFOCUS',
                        '%WM_MOUSEMOVE','%WM_MOVE','%WM_MOVING','%WM_NOTIFY','%WM_PAINT','%WM_QUIT','%WM_SETFOCUS','%WM_SETFONT',
                        '%WM_SETTEXT','%WM_SIZE','%WM_SIZING','%WM_SYSCOMMAND','%WM_TIMER','%WM_USER','%WS_BORDER','%WS_CAPTION',
                        '%WS_CHILD','%WS_CLIPCHILDREN','%WS_CLIPSIBLINGS','%WS_DISABLED','%WS_DLGFRAME','%WS_EX_ACCEPTFILES','%WS_EX_APPWINDOW','%WS_EX_CLIENTEDGE',
                        '%WS_EX_CONTEXTHELP','%WS_EX_CONTROLPARENT','%WS_EX_LEFT','%WS_EX_LEFTSCROLLBAR','%WS_EX_LTRREADING','%WS_EX_MDICHILD','%WS_EX_NOPARENTNOTIFY','%WS_EX_OVERLAPPEDWINDOW',
                        '%WS_EX_PALETTEWINDOW','%WS_EX_RIGHT','%WS_EX_RIGHTSCROLLBAR','%WS_EX_RTLREADING','%WS_EX_STATICEDGE','%WS_EX_TOOLWINDOW','%WS_EX_TOPMOST','%WS_EX_TRANSPARENT',
                        '%WS_EX_WINDOWEDGE','%WS_GROUP','%WS_HSCROLL','%WS_ICONIC','%WS_MAXIMIZE','%WS_MAXIMIZEBOX','%WS_MINIMIZE','%WS_MINIMIZEBOX',
                        '%WS_OVERLAPPEDWINDOW','%WS_POPUP','%WS_POPUPWINDOW','%WS_SYSMENU','%WS_TABSTOP','%WS_THICKFRAME','%WS_VISIBLE','%WS_VSCROLL',
                        '%YELLOW','CRLF','FALSE','NULL','TAB','TRUE'
                        )
                ),
        'SYMBOLS' => array(
          '(', ')', '{', '}', '[', ']', '=', '+', '-', '*', '/', '!', '%', '^', '&', ':'
          ),
        'CASE_SENSITIVE' => array(
                GESHI_COMMENTS => false,
                1 => false
                ),
        'STYLES' => array(
                'KEYWORDS' => array(
                        1 => 'color: #0000FF; font-weight: bold;',
                        2 => 'color: #993333; font-style: italic; font-weight: bold;',
                        3 => 'color: #000066;',
                        4 => 'color: #993333;'
                        ),
                'COMMENTS' => array(
                        1 => 'color: #008000;'
                        ),
                'BRACKETS' => array(
                        0 => 'color: #333333;'
                        ),
                'STRINGS' => array(
                        0 => 'color: #800080;'
                        ),
                'NUMBERS' => array(
                        0 => 'color: #CC0000;'
                        ),
                'METHODS' => array(
                        1 => 'color: #66cc66;'
                        ),
                'SYMBOLS' => array(
                        0 => 'color: #333333;'
                        ),
                'ESCAPE_CHAR' => array(
                        0 => 'color: #000099;'
                        ),
                'SCRIPT' => array(
                        ),
                'REGEXPS' => array(
                        )
                ),
        'OOLANG' => false,
        'OBJECT_SPLITTERS' => array(
                1 => '_'
                ),
        'REGEXPS' => array(
                ),
        'STRICT_MODE_APPLIES' => GESHI_NEVER,
        'SCRIPT_DELIMITERS' => array(
                ),
        'HIGHLIGHT_STRICT_BLOCK' => array(
                )
);

?>
