//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/compute/armcompute/v5"
	"net/http"
	"net/url"
	"reflect"
	"regexp"
	"strconv"
)

// VirtualMachinesServer is a fake server for instances of the armcompute.VirtualMachinesClient type.
type VirtualMachinesServer struct {
	// BeginAssessPatches is the fake for method VirtualMachinesClient.BeginAssessPatches
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginAssessPatches func(ctx context.Context, resourceGroupName string, vmName string, options *armcompute.VirtualMachinesClientBeginAssessPatchesOptions) (resp azfake.PollerResponder[armcompute.VirtualMachinesClientAssessPatchesResponse], errResp azfake.ErrorResponder)

	// BeginCapture is the fake for method VirtualMachinesClient.BeginCapture
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginCapture func(ctx context.Context, resourceGroupName string, vmName string, parameters armcompute.VirtualMachineCaptureParameters, options *armcompute.VirtualMachinesClientBeginCaptureOptions) (resp azfake.PollerResponder[armcompute.VirtualMachinesClientCaptureResponse], errResp azfake.ErrorResponder)

	// BeginConvertToManagedDisks is the fake for method VirtualMachinesClient.BeginConvertToManagedDisks
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginConvertToManagedDisks func(ctx context.Context, resourceGroupName string, vmName string, options *armcompute.VirtualMachinesClientBeginConvertToManagedDisksOptions) (resp azfake.PollerResponder[armcompute.VirtualMachinesClientConvertToManagedDisksResponse], errResp azfake.ErrorResponder)

	// BeginCreateOrUpdate is the fake for method VirtualMachinesClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateOrUpdate func(ctx context.Context, resourceGroupName string, vmName string, parameters armcompute.VirtualMachine, options *armcompute.VirtualMachinesClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armcompute.VirtualMachinesClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDeallocate is the fake for method VirtualMachinesClient.BeginDeallocate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginDeallocate func(ctx context.Context, resourceGroupName string, vmName string, options *armcompute.VirtualMachinesClientBeginDeallocateOptions) (resp azfake.PollerResponder[armcompute.VirtualMachinesClientDeallocateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method VirtualMachinesClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, vmName string, options *armcompute.VirtualMachinesClientBeginDeleteOptions) (resp azfake.PollerResponder[armcompute.VirtualMachinesClientDeleteResponse], errResp azfake.ErrorResponder)

	// Generalize is the fake for method VirtualMachinesClient.Generalize
	// HTTP status codes to indicate success: http.StatusOK
	Generalize func(ctx context.Context, resourceGroupName string, vmName string, options *armcompute.VirtualMachinesClientGeneralizeOptions) (resp azfake.Responder[armcompute.VirtualMachinesClientGeneralizeResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method VirtualMachinesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, vmName string, options *armcompute.VirtualMachinesClientGetOptions) (resp azfake.Responder[armcompute.VirtualMachinesClientGetResponse], errResp azfake.ErrorResponder)

	// BeginInstallPatches is the fake for method VirtualMachinesClient.BeginInstallPatches
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginInstallPatches func(ctx context.Context, resourceGroupName string, vmName string, installPatchesInput armcompute.VirtualMachineInstallPatchesParameters, options *armcompute.VirtualMachinesClientBeginInstallPatchesOptions) (resp azfake.PollerResponder[armcompute.VirtualMachinesClientInstallPatchesResponse], errResp azfake.ErrorResponder)

	// InstanceView is the fake for method VirtualMachinesClient.InstanceView
	// HTTP status codes to indicate success: http.StatusOK
	InstanceView func(ctx context.Context, resourceGroupName string, vmName string, options *armcompute.VirtualMachinesClientInstanceViewOptions) (resp azfake.Responder[armcompute.VirtualMachinesClientInstanceViewResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method VirtualMachinesClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceGroupName string, options *armcompute.VirtualMachinesClientListOptions) (resp azfake.PagerResponder[armcompute.VirtualMachinesClientListResponse])

	// NewListAllPager is the fake for method VirtualMachinesClient.NewListAllPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListAllPager func(options *armcompute.VirtualMachinesClientListAllOptions) (resp azfake.PagerResponder[armcompute.VirtualMachinesClientListAllResponse])

	// NewListAvailableSizesPager is the fake for method VirtualMachinesClient.NewListAvailableSizesPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListAvailableSizesPager func(resourceGroupName string, vmName string, options *armcompute.VirtualMachinesClientListAvailableSizesOptions) (resp azfake.PagerResponder[armcompute.VirtualMachinesClientListAvailableSizesResponse])

	// NewListByLocationPager is the fake for method VirtualMachinesClient.NewListByLocationPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByLocationPager func(location string, options *armcompute.VirtualMachinesClientListByLocationOptions) (resp azfake.PagerResponder[armcompute.VirtualMachinesClientListByLocationResponse])

	// BeginPerformMaintenance is the fake for method VirtualMachinesClient.BeginPerformMaintenance
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginPerformMaintenance func(ctx context.Context, resourceGroupName string, vmName string, options *armcompute.VirtualMachinesClientBeginPerformMaintenanceOptions) (resp azfake.PollerResponder[armcompute.VirtualMachinesClientPerformMaintenanceResponse], errResp azfake.ErrorResponder)

	// BeginPowerOff is the fake for method VirtualMachinesClient.BeginPowerOff
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginPowerOff func(ctx context.Context, resourceGroupName string, vmName string, options *armcompute.VirtualMachinesClientBeginPowerOffOptions) (resp azfake.PollerResponder[armcompute.VirtualMachinesClientPowerOffResponse], errResp azfake.ErrorResponder)

	// BeginReapply is the fake for method VirtualMachinesClient.BeginReapply
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginReapply func(ctx context.Context, resourceGroupName string, vmName string, options *armcompute.VirtualMachinesClientBeginReapplyOptions) (resp azfake.PollerResponder[armcompute.VirtualMachinesClientReapplyResponse], errResp azfake.ErrorResponder)

	// BeginRedeploy is the fake for method VirtualMachinesClient.BeginRedeploy
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginRedeploy func(ctx context.Context, resourceGroupName string, vmName string, options *armcompute.VirtualMachinesClientBeginRedeployOptions) (resp azfake.PollerResponder[armcompute.VirtualMachinesClientRedeployResponse], errResp azfake.ErrorResponder)

	// BeginReimage is the fake for method VirtualMachinesClient.BeginReimage
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginReimage func(ctx context.Context, resourceGroupName string, vmName string, options *armcompute.VirtualMachinesClientBeginReimageOptions) (resp azfake.PollerResponder[armcompute.VirtualMachinesClientReimageResponse], errResp azfake.ErrorResponder)

	// BeginRestart is the fake for method VirtualMachinesClient.BeginRestart
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginRestart func(ctx context.Context, resourceGroupName string, vmName string, options *armcompute.VirtualMachinesClientBeginRestartOptions) (resp azfake.PollerResponder[armcompute.VirtualMachinesClientRestartResponse], errResp azfake.ErrorResponder)

	// RetrieveBootDiagnosticsData is the fake for method VirtualMachinesClient.RetrieveBootDiagnosticsData
	// HTTP status codes to indicate success: http.StatusOK
	RetrieveBootDiagnosticsData func(ctx context.Context, resourceGroupName string, vmName string, options *armcompute.VirtualMachinesClientRetrieveBootDiagnosticsDataOptions) (resp azfake.Responder[armcompute.VirtualMachinesClientRetrieveBootDiagnosticsDataResponse], errResp azfake.ErrorResponder)

	// BeginRunCommand is the fake for method VirtualMachinesClient.BeginRunCommand
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginRunCommand func(ctx context.Context, resourceGroupName string, vmName string, parameters armcompute.RunCommandInput, options *armcompute.VirtualMachinesClientBeginRunCommandOptions) (resp azfake.PollerResponder[armcompute.VirtualMachinesClientRunCommandResponse], errResp azfake.ErrorResponder)

	// SimulateEviction is the fake for method VirtualMachinesClient.SimulateEviction
	// HTTP status codes to indicate success: http.StatusNoContent
	SimulateEviction func(ctx context.Context, resourceGroupName string, vmName string, options *armcompute.VirtualMachinesClientSimulateEvictionOptions) (resp azfake.Responder[armcompute.VirtualMachinesClientSimulateEvictionResponse], errResp azfake.ErrorResponder)

	// BeginStart is the fake for method VirtualMachinesClient.BeginStart
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginStart func(ctx context.Context, resourceGroupName string, vmName string, options *armcompute.VirtualMachinesClientBeginStartOptions) (resp azfake.PollerResponder[armcompute.VirtualMachinesClientStartResponse], errResp azfake.ErrorResponder)

	// BeginUpdate is the fake for method VirtualMachinesClient.BeginUpdate
	// HTTP status codes to indicate success: http.StatusOK
	BeginUpdate func(ctx context.Context, resourceGroupName string, vmName string, parameters armcompute.VirtualMachineUpdate, options *armcompute.VirtualMachinesClientBeginUpdateOptions) (resp azfake.PollerResponder[armcompute.VirtualMachinesClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewVirtualMachinesServerTransport creates a new instance of VirtualMachinesServerTransport with the provided implementation.
// The returned VirtualMachinesServerTransport instance is connected to an instance of armcompute.VirtualMachinesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewVirtualMachinesServerTransport(srv *VirtualMachinesServer) *VirtualMachinesServerTransport {
	return &VirtualMachinesServerTransport{
		srv:                        srv,
		beginAssessPatches:         newTracker[azfake.PollerResponder[armcompute.VirtualMachinesClientAssessPatchesResponse]](),
		beginCapture:               newTracker[azfake.PollerResponder[armcompute.VirtualMachinesClientCaptureResponse]](),
		beginConvertToManagedDisks: newTracker[azfake.PollerResponder[armcompute.VirtualMachinesClientConvertToManagedDisksResponse]](),
		beginCreateOrUpdate:        newTracker[azfake.PollerResponder[armcompute.VirtualMachinesClientCreateOrUpdateResponse]](),
		beginDeallocate:            newTracker[azfake.PollerResponder[armcompute.VirtualMachinesClientDeallocateResponse]](),
		beginDelete:                newTracker[azfake.PollerResponder[armcompute.VirtualMachinesClientDeleteResponse]](),
		beginInstallPatches:        newTracker[azfake.PollerResponder[armcompute.VirtualMachinesClientInstallPatchesResponse]](),
		newListPager:               newTracker[azfake.PagerResponder[armcompute.VirtualMachinesClientListResponse]](),
		newListAllPager:            newTracker[azfake.PagerResponder[armcompute.VirtualMachinesClientListAllResponse]](),
		newListAvailableSizesPager: newTracker[azfake.PagerResponder[armcompute.VirtualMachinesClientListAvailableSizesResponse]](),
		newListByLocationPager:     newTracker[azfake.PagerResponder[armcompute.VirtualMachinesClientListByLocationResponse]](),
		beginPerformMaintenance:    newTracker[azfake.PollerResponder[armcompute.VirtualMachinesClientPerformMaintenanceResponse]](),
		beginPowerOff:              newTracker[azfake.PollerResponder[armcompute.VirtualMachinesClientPowerOffResponse]](),
		beginReapply:               newTracker[azfake.PollerResponder[armcompute.VirtualMachinesClientReapplyResponse]](),
		beginRedeploy:              newTracker[azfake.PollerResponder[armcompute.VirtualMachinesClientRedeployResponse]](),
		beginReimage:               newTracker[azfake.PollerResponder[armcompute.VirtualMachinesClientReimageResponse]](),
		beginRestart:               newTracker[azfake.PollerResponder[armcompute.VirtualMachinesClientRestartResponse]](),
		beginRunCommand:            newTracker[azfake.PollerResponder[armcompute.VirtualMachinesClientRunCommandResponse]](),
		beginStart:                 newTracker[azfake.PollerResponder[armcompute.VirtualMachinesClientStartResponse]](),
		beginUpdate:                newTracker[azfake.PollerResponder[armcompute.VirtualMachinesClientUpdateResponse]](),
	}
}

// VirtualMachinesServerTransport connects instances of armcompute.VirtualMachinesClient to instances of VirtualMachinesServer.
// Don't use this type directly, use NewVirtualMachinesServerTransport instead.
type VirtualMachinesServerTransport struct {
	srv                        *VirtualMachinesServer
	beginAssessPatches         *tracker[azfake.PollerResponder[armcompute.VirtualMachinesClientAssessPatchesResponse]]
	beginCapture               *tracker[azfake.PollerResponder[armcompute.VirtualMachinesClientCaptureResponse]]
	beginConvertToManagedDisks *tracker[azfake.PollerResponder[armcompute.VirtualMachinesClientConvertToManagedDisksResponse]]
	beginCreateOrUpdate        *tracker[azfake.PollerResponder[armcompute.VirtualMachinesClientCreateOrUpdateResponse]]
	beginDeallocate            *tracker[azfake.PollerResponder[armcompute.VirtualMachinesClientDeallocateResponse]]
	beginDelete                *tracker[azfake.PollerResponder[armcompute.VirtualMachinesClientDeleteResponse]]
	beginInstallPatches        *tracker[azfake.PollerResponder[armcompute.VirtualMachinesClientInstallPatchesResponse]]
	newListPager               *tracker[azfake.PagerResponder[armcompute.VirtualMachinesClientListResponse]]
	newListAllPager            *tracker[azfake.PagerResponder[armcompute.VirtualMachinesClientListAllResponse]]
	newListAvailableSizesPager *tracker[azfake.PagerResponder[armcompute.VirtualMachinesClientListAvailableSizesResponse]]
	newListByLocationPager     *tracker[azfake.PagerResponder[armcompute.VirtualMachinesClientListByLocationResponse]]
	beginPerformMaintenance    *tracker[azfake.PollerResponder[armcompute.VirtualMachinesClientPerformMaintenanceResponse]]
	beginPowerOff              *tracker[azfake.PollerResponder[armcompute.VirtualMachinesClientPowerOffResponse]]
	beginReapply               *tracker[azfake.PollerResponder[armcompute.VirtualMachinesClientReapplyResponse]]
	beginRedeploy              *tracker[azfake.PollerResponder[armcompute.VirtualMachinesClientRedeployResponse]]
	beginReimage               *tracker[azfake.PollerResponder[armcompute.VirtualMachinesClientReimageResponse]]
	beginRestart               *tracker[azfake.PollerResponder[armcompute.VirtualMachinesClientRestartResponse]]
	beginRunCommand            *tracker[azfake.PollerResponder[armcompute.VirtualMachinesClientRunCommandResponse]]
	beginStart                 *tracker[azfake.PollerResponder[armcompute.VirtualMachinesClientStartResponse]]
	beginUpdate                *tracker[azfake.PollerResponder[armcompute.VirtualMachinesClientUpdateResponse]]
}

// Do implements the policy.Transporter interface for VirtualMachinesServerTransport.
func (v *VirtualMachinesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "VirtualMachinesClient.BeginAssessPatches":
		resp, err = v.dispatchBeginAssessPatches(req)
	case "VirtualMachinesClient.BeginCapture":
		resp, err = v.dispatchBeginCapture(req)
	case "VirtualMachinesClient.BeginConvertToManagedDisks":
		resp, err = v.dispatchBeginConvertToManagedDisks(req)
	case "VirtualMachinesClient.BeginCreateOrUpdate":
		resp, err = v.dispatchBeginCreateOrUpdate(req)
	case "VirtualMachinesClient.BeginDeallocate":
		resp, err = v.dispatchBeginDeallocate(req)
	case "VirtualMachinesClient.BeginDelete":
		resp, err = v.dispatchBeginDelete(req)
	case "VirtualMachinesClient.Generalize":
		resp, err = v.dispatchGeneralize(req)
	case "VirtualMachinesClient.Get":
		resp, err = v.dispatchGet(req)
	case "VirtualMachinesClient.BeginInstallPatches":
		resp, err = v.dispatchBeginInstallPatches(req)
	case "VirtualMachinesClient.InstanceView":
		resp, err = v.dispatchInstanceView(req)
	case "VirtualMachinesClient.NewListPager":
		resp, err = v.dispatchNewListPager(req)
	case "VirtualMachinesClient.NewListAllPager":
		resp, err = v.dispatchNewListAllPager(req)
	case "VirtualMachinesClient.NewListAvailableSizesPager":
		resp, err = v.dispatchNewListAvailableSizesPager(req)
	case "VirtualMachinesClient.NewListByLocationPager":
		resp, err = v.dispatchNewListByLocationPager(req)
	case "VirtualMachinesClient.BeginPerformMaintenance":
		resp, err = v.dispatchBeginPerformMaintenance(req)
	case "VirtualMachinesClient.BeginPowerOff":
		resp, err = v.dispatchBeginPowerOff(req)
	case "VirtualMachinesClient.BeginReapply":
		resp, err = v.dispatchBeginReapply(req)
	case "VirtualMachinesClient.BeginRedeploy":
		resp, err = v.dispatchBeginRedeploy(req)
	case "VirtualMachinesClient.BeginReimage":
		resp, err = v.dispatchBeginReimage(req)
	case "VirtualMachinesClient.BeginRestart":
		resp, err = v.dispatchBeginRestart(req)
	case "VirtualMachinesClient.RetrieveBootDiagnosticsData":
		resp, err = v.dispatchRetrieveBootDiagnosticsData(req)
	case "VirtualMachinesClient.BeginRunCommand":
		resp, err = v.dispatchBeginRunCommand(req)
	case "VirtualMachinesClient.SimulateEviction":
		resp, err = v.dispatchSimulateEviction(req)
	case "VirtualMachinesClient.BeginStart":
		resp, err = v.dispatchBeginStart(req)
	case "VirtualMachinesClient.BeginUpdate":
		resp, err = v.dispatchBeginUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (v *VirtualMachinesServerTransport) dispatchBeginAssessPatches(req *http.Request) (*http.Response, error) {
	if v.srv.BeginAssessPatches == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginAssessPatches not implemented")}
	}
	beginAssessPatches := v.beginAssessPatches.get(req)
	if beginAssessPatches == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Compute/virtualMachines/(?P<vmName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/assessPatches`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		vmNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vmName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := v.srv.BeginAssessPatches(req.Context(), resourceGroupNameParam, vmNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginAssessPatches = &respr
		v.beginAssessPatches.add(req, beginAssessPatches)
	}

	resp, err := server.PollerResponderNext(beginAssessPatches, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		v.beginAssessPatches.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginAssessPatches) {
		v.beginAssessPatches.remove(req)
	}

	return resp, nil
}

func (v *VirtualMachinesServerTransport) dispatchBeginCapture(req *http.Request) (*http.Response, error) {
	if v.srv.BeginCapture == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCapture not implemented")}
	}
	beginCapture := v.beginCapture.get(req)
	if beginCapture == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Compute/virtualMachines/(?P<vmName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/capture`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcompute.VirtualMachineCaptureParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		vmNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vmName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := v.srv.BeginCapture(req.Context(), resourceGroupNameParam, vmNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCapture = &respr
		v.beginCapture.add(req, beginCapture)
	}

	resp, err := server.PollerResponderNext(beginCapture, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		v.beginCapture.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCapture) {
		v.beginCapture.remove(req)
	}

	return resp, nil
}

func (v *VirtualMachinesServerTransport) dispatchBeginConvertToManagedDisks(req *http.Request) (*http.Response, error) {
	if v.srv.BeginConvertToManagedDisks == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginConvertToManagedDisks not implemented")}
	}
	beginConvertToManagedDisks := v.beginConvertToManagedDisks.get(req)
	if beginConvertToManagedDisks == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Compute/virtualMachines/(?P<vmName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/convertToManagedDisks`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		vmNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vmName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := v.srv.BeginConvertToManagedDisks(req.Context(), resourceGroupNameParam, vmNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginConvertToManagedDisks = &respr
		v.beginConvertToManagedDisks.add(req, beginConvertToManagedDisks)
	}

	resp, err := server.PollerResponderNext(beginConvertToManagedDisks, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		v.beginConvertToManagedDisks.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginConvertToManagedDisks) {
		v.beginConvertToManagedDisks.remove(req)
	}

	return resp, nil
}

func (v *VirtualMachinesServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if v.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := v.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Compute/virtualMachines/(?P<vmName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcompute.VirtualMachine](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		vmNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vmName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := v.srv.BeginCreateOrUpdate(req.Context(), resourceGroupNameParam, vmNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		v.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		v.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		v.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (v *VirtualMachinesServerTransport) dispatchBeginDeallocate(req *http.Request) (*http.Response, error) {
	if v.srv.BeginDeallocate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDeallocate not implemented")}
	}
	beginDeallocate := v.beginDeallocate.get(req)
	if beginDeallocate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Compute/virtualMachines/(?P<vmName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/deallocate`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		vmNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vmName")])
		if err != nil {
			return nil, err
		}
		hibernateUnescaped, err := url.QueryUnescape(qp.Get("hibernate"))
		if err != nil {
			return nil, err
		}
		hibernateParam, err := parseOptional(hibernateUnescaped, strconv.ParseBool)
		if err != nil {
			return nil, err
		}
		var options *armcompute.VirtualMachinesClientBeginDeallocateOptions
		if hibernateParam != nil {
			options = &armcompute.VirtualMachinesClientBeginDeallocateOptions{
				Hibernate: hibernateParam,
			}
		}
		respr, errRespr := v.srv.BeginDeallocate(req.Context(), resourceGroupNameParam, vmNameParam, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDeallocate = &respr
		v.beginDeallocate.add(req, beginDeallocate)
	}

	resp, err := server.PollerResponderNext(beginDeallocate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		v.beginDeallocate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDeallocate) {
		v.beginDeallocate.remove(req)
	}

	return resp, nil
}

func (v *VirtualMachinesServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if v.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := v.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Compute/virtualMachines/(?P<vmName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		vmNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vmName")])
		if err != nil {
			return nil, err
		}
		forceDeletionUnescaped, err := url.QueryUnescape(qp.Get("forceDeletion"))
		if err != nil {
			return nil, err
		}
		forceDeletionParam, err := parseOptional(forceDeletionUnescaped, strconv.ParseBool)
		if err != nil {
			return nil, err
		}
		var options *armcompute.VirtualMachinesClientBeginDeleteOptions
		if forceDeletionParam != nil {
			options = &armcompute.VirtualMachinesClientBeginDeleteOptions{
				ForceDeletion: forceDeletionParam,
			}
		}
		respr, errRespr := v.srv.BeginDelete(req.Context(), resourceGroupNameParam, vmNameParam, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		v.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		v.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		v.beginDelete.remove(req)
	}

	return resp, nil
}

func (v *VirtualMachinesServerTransport) dispatchGeneralize(req *http.Request) (*http.Response, error) {
	if v.srv.Generalize == nil {
		return nil, &nonRetriableError{errors.New("fake for method Generalize not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Compute/virtualMachines/(?P<vmName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/generalize`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	vmNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vmName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := v.srv.Generalize(req.Context(), resourceGroupNameParam, vmNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (v *VirtualMachinesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if v.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Compute/virtualMachines/(?P<vmName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	vmNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vmName")])
	if err != nil {
		return nil, err
	}
	expandUnescaped, err := url.QueryUnescape(qp.Get("$expand"))
	if err != nil {
		return nil, err
	}
	expandParam := getOptional(armcompute.InstanceViewTypes(expandUnescaped))
	var options *armcompute.VirtualMachinesClientGetOptions
	if expandParam != nil {
		options = &armcompute.VirtualMachinesClientGetOptions{
			Expand: expandParam,
		}
	}
	respr, errRespr := v.srv.Get(req.Context(), resourceGroupNameParam, vmNameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).VirtualMachine, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (v *VirtualMachinesServerTransport) dispatchBeginInstallPatches(req *http.Request) (*http.Response, error) {
	if v.srv.BeginInstallPatches == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginInstallPatches not implemented")}
	}
	beginInstallPatches := v.beginInstallPatches.get(req)
	if beginInstallPatches == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Compute/virtualMachines/(?P<vmName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/installPatches`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcompute.VirtualMachineInstallPatchesParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		vmNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vmName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := v.srv.BeginInstallPatches(req.Context(), resourceGroupNameParam, vmNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginInstallPatches = &respr
		v.beginInstallPatches.add(req, beginInstallPatches)
	}

	resp, err := server.PollerResponderNext(beginInstallPatches, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		v.beginInstallPatches.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginInstallPatches) {
		v.beginInstallPatches.remove(req)
	}

	return resp, nil
}

func (v *VirtualMachinesServerTransport) dispatchInstanceView(req *http.Request) (*http.Response, error) {
	if v.srv.InstanceView == nil {
		return nil, &nonRetriableError{errors.New("fake for method InstanceView not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Compute/virtualMachines/(?P<vmName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/instanceView`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	vmNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vmName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := v.srv.InstanceView(req.Context(), resourceGroupNameParam, vmNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).VirtualMachineInstanceView, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (v *VirtualMachinesServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if v.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := v.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Compute/virtualMachines`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		expandUnescaped, err := url.QueryUnescape(qp.Get("$expand"))
		if err != nil {
			return nil, err
		}
		expandParam := getOptional(armcompute.ExpandTypeForListVMs(expandUnescaped))
		var options *armcompute.VirtualMachinesClientListOptions
		if filterParam != nil || expandParam != nil {
			options = &armcompute.VirtualMachinesClientListOptions{
				Filter: filterParam,
				Expand: expandParam,
			}
		}
		resp := v.srv.NewListPager(resourceGroupNameParam, options)
		newListPager = &resp
		v.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armcompute.VirtualMachinesClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		v.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		v.newListPager.remove(req)
	}
	return resp, nil
}

func (v *VirtualMachinesServerTransport) dispatchNewListAllPager(req *http.Request) (*http.Response, error) {
	if v.srv.NewListAllPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListAllPager not implemented")}
	}
	newListAllPager := v.newListAllPager.get(req)
	if newListAllPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Compute/virtualMachines`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		statusOnlyUnescaped, err := url.QueryUnescape(qp.Get("statusOnly"))
		if err != nil {
			return nil, err
		}
		statusOnlyParam := getOptional(statusOnlyUnescaped)
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		expandUnescaped, err := url.QueryUnescape(qp.Get("$expand"))
		if err != nil {
			return nil, err
		}
		expandParam := getOptional(armcompute.ExpandTypesForListVMs(expandUnescaped))
		var options *armcompute.VirtualMachinesClientListAllOptions
		if statusOnlyParam != nil || filterParam != nil || expandParam != nil {
			options = &armcompute.VirtualMachinesClientListAllOptions{
				StatusOnly: statusOnlyParam,
				Filter:     filterParam,
				Expand:     expandParam,
			}
		}
		resp := v.srv.NewListAllPager(options)
		newListAllPager = &resp
		v.newListAllPager.add(req, newListAllPager)
		server.PagerResponderInjectNextLinks(newListAllPager, req, func(page *armcompute.VirtualMachinesClientListAllResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListAllPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		v.newListAllPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListAllPager) {
		v.newListAllPager.remove(req)
	}
	return resp, nil
}

func (v *VirtualMachinesServerTransport) dispatchNewListAvailableSizesPager(req *http.Request) (*http.Response, error) {
	if v.srv.NewListAvailableSizesPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListAvailableSizesPager not implemented")}
	}
	newListAvailableSizesPager := v.newListAvailableSizesPager.get(req)
	if newListAvailableSizesPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Compute/virtualMachines/(?P<vmName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/vmSizes`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		vmNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vmName")])
		if err != nil {
			return nil, err
		}
		resp := v.srv.NewListAvailableSizesPager(resourceGroupNameParam, vmNameParam, nil)
		newListAvailableSizesPager = &resp
		v.newListAvailableSizesPager.add(req, newListAvailableSizesPager)
	}
	resp, err := server.PagerResponderNext(newListAvailableSizesPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		v.newListAvailableSizesPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListAvailableSizesPager) {
		v.newListAvailableSizesPager.remove(req)
	}
	return resp, nil
}

func (v *VirtualMachinesServerTransport) dispatchNewListByLocationPager(req *http.Request) (*http.Response, error) {
	if v.srv.NewListByLocationPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByLocationPager not implemented")}
	}
	newListByLocationPager := v.newListByLocationPager.get(req)
	if newListByLocationPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Compute/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/virtualMachines`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
		if err != nil {
			return nil, err
		}
		resp := v.srv.NewListByLocationPager(locationParam, nil)
		newListByLocationPager = &resp
		v.newListByLocationPager.add(req, newListByLocationPager)
		server.PagerResponderInjectNextLinks(newListByLocationPager, req, func(page *armcompute.VirtualMachinesClientListByLocationResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByLocationPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		v.newListByLocationPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByLocationPager) {
		v.newListByLocationPager.remove(req)
	}
	return resp, nil
}

func (v *VirtualMachinesServerTransport) dispatchBeginPerformMaintenance(req *http.Request) (*http.Response, error) {
	if v.srv.BeginPerformMaintenance == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginPerformMaintenance not implemented")}
	}
	beginPerformMaintenance := v.beginPerformMaintenance.get(req)
	if beginPerformMaintenance == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Compute/virtualMachines/(?P<vmName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/performMaintenance`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		vmNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vmName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := v.srv.BeginPerformMaintenance(req.Context(), resourceGroupNameParam, vmNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginPerformMaintenance = &respr
		v.beginPerformMaintenance.add(req, beginPerformMaintenance)
	}

	resp, err := server.PollerResponderNext(beginPerformMaintenance, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		v.beginPerformMaintenance.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginPerformMaintenance) {
		v.beginPerformMaintenance.remove(req)
	}

	return resp, nil
}

func (v *VirtualMachinesServerTransport) dispatchBeginPowerOff(req *http.Request) (*http.Response, error) {
	if v.srv.BeginPowerOff == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginPowerOff not implemented")}
	}
	beginPowerOff := v.beginPowerOff.get(req)
	if beginPowerOff == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Compute/virtualMachines/(?P<vmName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/powerOff`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		vmNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vmName")])
		if err != nil {
			return nil, err
		}
		skipShutdownUnescaped, err := url.QueryUnescape(qp.Get("skipShutdown"))
		if err != nil {
			return nil, err
		}
		skipShutdownParam, err := parseOptional(skipShutdownUnescaped, strconv.ParseBool)
		if err != nil {
			return nil, err
		}
		var options *armcompute.VirtualMachinesClientBeginPowerOffOptions
		if skipShutdownParam != nil {
			options = &armcompute.VirtualMachinesClientBeginPowerOffOptions{
				SkipShutdown: skipShutdownParam,
			}
		}
		respr, errRespr := v.srv.BeginPowerOff(req.Context(), resourceGroupNameParam, vmNameParam, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginPowerOff = &respr
		v.beginPowerOff.add(req, beginPowerOff)
	}

	resp, err := server.PollerResponderNext(beginPowerOff, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		v.beginPowerOff.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginPowerOff) {
		v.beginPowerOff.remove(req)
	}

	return resp, nil
}

func (v *VirtualMachinesServerTransport) dispatchBeginReapply(req *http.Request) (*http.Response, error) {
	if v.srv.BeginReapply == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginReapply not implemented")}
	}
	beginReapply := v.beginReapply.get(req)
	if beginReapply == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Compute/virtualMachines/(?P<vmName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/reapply`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		vmNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vmName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := v.srv.BeginReapply(req.Context(), resourceGroupNameParam, vmNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginReapply = &respr
		v.beginReapply.add(req, beginReapply)
	}

	resp, err := server.PollerResponderNext(beginReapply, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		v.beginReapply.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginReapply) {
		v.beginReapply.remove(req)
	}

	return resp, nil
}

func (v *VirtualMachinesServerTransport) dispatchBeginRedeploy(req *http.Request) (*http.Response, error) {
	if v.srv.BeginRedeploy == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginRedeploy not implemented")}
	}
	beginRedeploy := v.beginRedeploy.get(req)
	if beginRedeploy == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Compute/virtualMachines/(?P<vmName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/redeploy`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		vmNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vmName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := v.srv.BeginRedeploy(req.Context(), resourceGroupNameParam, vmNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginRedeploy = &respr
		v.beginRedeploy.add(req, beginRedeploy)
	}

	resp, err := server.PollerResponderNext(beginRedeploy, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		v.beginRedeploy.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginRedeploy) {
		v.beginRedeploy.remove(req)
	}

	return resp, nil
}

func (v *VirtualMachinesServerTransport) dispatchBeginReimage(req *http.Request) (*http.Response, error) {
	if v.srv.BeginReimage == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginReimage not implemented")}
	}
	beginReimage := v.beginReimage.get(req)
	if beginReimage == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Compute/virtualMachines/(?P<vmName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/reimage`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcompute.VirtualMachineReimageParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		vmNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vmName")])
		if err != nil {
			return nil, err
		}
		var options *armcompute.VirtualMachinesClientBeginReimageOptions
		if !reflect.ValueOf(body).IsZero() {
			options = &armcompute.VirtualMachinesClientBeginReimageOptions{
				Parameters: &body,
			}
		}
		respr, errRespr := v.srv.BeginReimage(req.Context(), resourceGroupNameParam, vmNameParam, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginReimage = &respr
		v.beginReimage.add(req, beginReimage)
	}

	resp, err := server.PollerResponderNext(beginReimage, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		v.beginReimage.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginReimage) {
		v.beginReimage.remove(req)
	}

	return resp, nil
}

func (v *VirtualMachinesServerTransport) dispatchBeginRestart(req *http.Request) (*http.Response, error) {
	if v.srv.BeginRestart == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginRestart not implemented")}
	}
	beginRestart := v.beginRestart.get(req)
	if beginRestart == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Compute/virtualMachines/(?P<vmName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/restart`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		vmNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vmName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := v.srv.BeginRestart(req.Context(), resourceGroupNameParam, vmNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginRestart = &respr
		v.beginRestart.add(req, beginRestart)
	}

	resp, err := server.PollerResponderNext(beginRestart, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		v.beginRestart.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginRestart) {
		v.beginRestart.remove(req)
	}

	return resp, nil
}

func (v *VirtualMachinesServerTransport) dispatchRetrieveBootDiagnosticsData(req *http.Request) (*http.Response, error) {
	if v.srv.RetrieveBootDiagnosticsData == nil {
		return nil, &nonRetriableError{errors.New("fake for method RetrieveBootDiagnosticsData not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Compute/virtualMachines/(?P<vmName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/retrieveBootDiagnosticsData`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	vmNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vmName")])
	if err != nil {
		return nil, err
	}
	sasURIExpirationTimeInMinutesUnescaped, err := url.QueryUnescape(qp.Get("sasUriExpirationTimeInMinutes"))
	if err != nil {
		return nil, err
	}
	sasURIExpirationTimeInMinutesParam, err := parseOptional(sasURIExpirationTimeInMinutesUnescaped, func(v string) (int32, error) {
		p, parseErr := strconv.ParseInt(v, 10, 32)
		if parseErr != nil {
			return 0, parseErr
		}
		return int32(p), nil
	})
	if err != nil {
		return nil, err
	}
	var options *armcompute.VirtualMachinesClientRetrieveBootDiagnosticsDataOptions
	if sasURIExpirationTimeInMinutesParam != nil {
		options = &armcompute.VirtualMachinesClientRetrieveBootDiagnosticsDataOptions{
			SasURIExpirationTimeInMinutes: sasURIExpirationTimeInMinutesParam,
		}
	}
	respr, errRespr := v.srv.RetrieveBootDiagnosticsData(req.Context(), resourceGroupNameParam, vmNameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).RetrieveBootDiagnosticsDataResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (v *VirtualMachinesServerTransport) dispatchBeginRunCommand(req *http.Request) (*http.Response, error) {
	if v.srv.BeginRunCommand == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginRunCommand not implemented")}
	}
	beginRunCommand := v.beginRunCommand.get(req)
	if beginRunCommand == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Compute/virtualMachines/(?P<vmName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/runCommand`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcompute.RunCommandInput](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		vmNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vmName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := v.srv.BeginRunCommand(req.Context(), resourceGroupNameParam, vmNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginRunCommand = &respr
		v.beginRunCommand.add(req, beginRunCommand)
	}

	resp, err := server.PollerResponderNext(beginRunCommand, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		v.beginRunCommand.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginRunCommand) {
		v.beginRunCommand.remove(req)
	}

	return resp, nil
}

func (v *VirtualMachinesServerTransport) dispatchSimulateEviction(req *http.Request) (*http.Response, error) {
	if v.srv.SimulateEviction == nil {
		return nil, &nonRetriableError{errors.New("fake for method SimulateEviction not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Compute/virtualMachines/(?P<vmName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/simulateEviction`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	vmNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vmName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := v.srv.SimulateEviction(req.Context(), resourceGroupNameParam, vmNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (v *VirtualMachinesServerTransport) dispatchBeginStart(req *http.Request) (*http.Response, error) {
	if v.srv.BeginStart == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginStart not implemented")}
	}
	beginStart := v.beginStart.get(req)
	if beginStart == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Compute/virtualMachines/(?P<vmName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/start`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		vmNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vmName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := v.srv.BeginStart(req.Context(), resourceGroupNameParam, vmNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginStart = &respr
		v.beginStart.add(req, beginStart)
	}

	resp, err := server.PollerResponderNext(beginStart, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		v.beginStart.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginStart) {
		v.beginStart.remove(req)
	}

	return resp, nil
}

func (v *VirtualMachinesServerTransport) dispatchBeginUpdate(req *http.Request) (*http.Response, error) {
	if v.srv.BeginUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdate not implemented")}
	}
	beginUpdate := v.beginUpdate.get(req)
	if beginUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Compute/virtualMachines/(?P<vmName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcompute.VirtualMachineUpdate](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		vmNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vmName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := v.srv.BeginUpdate(req.Context(), resourceGroupNameParam, vmNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdate = &respr
		v.beginUpdate.add(req, beginUpdate)
	}

	resp, err := server.PollerResponderNext(beginUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		v.beginUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdate) {
		v.beginUpdate.remove(req)
	}

	return resp, nil
}
