/*
 *  $Id: mfmops.h 28809 2025-11-05 18:36:20Z yeti-dn $
 *  Copyright (C) 2017-2018 David Necas (Yeti), Petr Klapetek.
 *  E-mail: yeti@gwyddion.net, klapetek@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 */

#ifndef __GWY_MFMOPS_H__
#define __GWY_MFMOPS_H__

#include <libgwyddion/math.h>

#define MU_0 1.256637061435917295e-6

static gdouble
mfm_factor(GwyMFMGradientType type, gdouble dx, gdouble dy)
{
    if (type == GWY_MFM_GRADIENT_MFM)
        return 1.0/MU_0;

    if (type == GWY_MFM_GRADIENT_MFM_AREA)
        return 1.0/(MU_0*dx*dy);

    return 1.0;
}

static gchar*
mfm_unit(GwyMFMGradientType type)
{
    if (type == GWY_MFM_GRADIENT_MFM)
        return g_strdup("A^2/m");

    if (type == GWY_MFM_GRADIENT_MFM_AREA)
        return g_strdup("A^2/m^3");

    return g_strdup("N/m");
}

// the same code for volume data, this should not be here repeated twice !!!

#endif

/* vim: set cin et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
