//===- X86LegalizerInfo.h ------------------------------------------*- C++
//-*-==//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//
/// \file
/// This file declares the targeting of the Machinelegalizer class for X86.
/// \todo This should be generated by TableGen.
//===----------------------------------------------------------------------===//

#ifndef LLVM_LIB_TARGET_X86_X86MACHINELEGALIZER_H
#define LLVM_LIB_TARGET_X86_X86MACHINELEGALIZER_H

#include "llvm/CodeGen/GlobalISel/LegalizerInfo.h"

namespace llvm {

class X86Subtarget;
class X86TargetMachine;

class X86LegalizerInfo : public LegalizerInfo {
private:
  /// Keep a reference to the X86Subtarget around so that we can
  /// make the right decision when generating code for different targets.
  const X86Subtarget &Subtarget;

public:
  X86LegalizerInfo(const X86Subtarget &STI, const X86TargetMachine &TM);

  bool legalizeCustom(LegalizerHelper &Helper, MachineInstr &MI,
                      LostDebugLocObserver &LocObserver) const override;

  bool legalizeIntrinsic(LegalizerHelper &Helper,
                         MachineInstr &MI) const override;

private:
  bool legalizeBuildVector(MachineInstr &MI, MachineRegisterInfo &MRI,
                           LegalizerHelper &Helper) const;

  bool legalizeFPTOUI(MachineInstr &MI, MachineRegisterInfo &MRI,
                      LegalizerHelper &Helper) const;

  bool legalizeUITOFP(MachineInstr &MI, MachineRegisterInfo &MRI,
                      LegalizerHelper &Helper) const;

  bool legalizeNarrowingStore(MachineInstr &MI, MachineRegisterInfo &MRI,
                              LegalizerHelper &Helper) const;

  bool legalizeSITOFP(MachineInstr &MI, MachineRegisterInfo &MRI,
                      LegalizerHelper &Helper) const;

  bool legalizeFPTOSI(MachineInstr &MI, MachineRegisterInfo &MRI,
                      LegalizerHelper &Helper) const;

  bool legalizeGETROUNDING(MachineInstr &MI, MachineRegisterInfo &MRI,
                           LegalizerHelper &Helper) const;

  bool legalizeSETROUNDING(MachineInstr &MI, MachineRegisterInfo &MRI,
                           LegalizerHelper &Helper) const;
};
} // namespace llvm
#endif
