// RUN: mlir-opt -allow-unregistered-dialect %s -mlir-print-debuginfo -mlir-print-local-scope | FileCheck %s
// RUN: mlir-opt -allow-unregistered-dialect %s -mlir-print-debuginfo | FileCheck %s --check-prefix=CHECK-ALIAS
// RUN: mlir-opt -allow-unregistered-dialect %s -mlir-print-debuginfo | mlir-opt -allow-unregistered-dialect -mlir-print-debuginfo | FileCheck %s --check-prefix=CHECK-ALIAS
// This test verifies that debug locations are round-trippable.

#set0 = affine_set<(d0) : (1 == 0)>

// CHECK-LABEL: func @inline_notation
func.func @inline_notation() -> i32 {
  // CHECK: -> i32 loc("foo")
  %1 = "foo"() : () -> i32 loc("foo")

  // CHECK: arith.constant 4 : index loc(callsite("foo" at "mysource.cc":10:8))
  %2 = arith.constant 4 : index loc(callsite("foo" at "mysource.cc":10:8))

  // CHECK: affine.for %arg0 loc("IVlocation") = 0 to 8 {
  // CHECK: } loc(fused["foo", "mysource.cc":10:8])
  affine.for %i0 loc("IVlocation") = 0 to 8 {
  } loc(fused["foo", "mysource.cc":10:8])

  // CHECK: } loc(fused<"myPass">["foo", "foo2"])
  affine.if #set0(%2) {
  } loc(fused<"myPass">["foo", "foo2"])

  // CHECK: } loc(fused<"myPass">["foo"])
  affine.if #set0(%2) {
  } loc(fused<"myPass">["foo"])

  // CHECK: return %0 : i32 loc(unknown)
  return %1 : i32 loc(unknown)
}

// CHECK-LABEL: func private @loc_attr(i1 {foo.loc_attr = loc(callsite("foo" at "mysource.cc":10:8))})
func.func private @loc_attr(i1 {foo.loc_attr = loc(callsite("foo" at "mysource.cc":10:8))})

// CHECK-LABEL: func.func private @filelocrange_attr1(i1 {foo.loc_attr = loc("mysource.cc":10:0)})
func.func private @filelocrange_attr1(i1 {foo.loc_attr = loc("mysource.cc":10)})
// CHECK-LABEL: func.func private @filelocrange_attr2(i1 {foo.loc_attr = loc("mysource.cc":10:8)})
func.func private @filelocrange_attr2(i1 {foo.loc_attr = loc("mysource.cc":10:8)})
// CHECK-LABEL: func.func private @filelocrange_attr3(i1 {foo.loc_attr = loc("mysource.cc":10:8 to :12)})
func.func private @filelocrange_attr3(i1 {foo.loc_attr = loc("mysource.cc":10:8 to :12)})
// CHECK-LABEL: func.func private @filelocrange_attr4(i1 {foo.loc_attr = loc("mysource.cc":10:8 to 12:4)})
func.func private @filelocrange_attr4(i1 {foo.loc_attr = loc("mysource.cc":10:8 to 12:4)})

  // Check that locations get properly escaped.
// CHECK-LABEL: func @escape_strings()
func.func @escape_strings() {
  // CHECK: loc("escaped\0A")
  "foo"() : () -> () loc("escaped\n")

  // CHECK: loc("escaped\0A")
  "foo"() : () -> () loc("escaped\0A")

  // CHECK: loc("escaped\0A":0:0)
  "foo"() : () -> () loc("escaped\n":0:0)
  return
}

// CHECK-ALIAS: "foo.op"() : () -> () loc(#[[LOC:.*]])
"foo.op"() : () -> () loc(#loc)

// CHECK-LABEL: func @argLocs(
// CHECK-SAME:  %arg0: i32 loc({{.*}}locations.mlir":[[# @LINE+1]]:20),
func.func @argLocs(%x: i32,
// CHECK-SAME:  %arg1: i64 loc("hotdog")
              %y: i64 loc("hotdog")) {
  return
}

// CHECK-LABEL: "foo.unknown_op_with_bbargs"()
// CHECK-ALIAS: "foo.unknown_op_with_bbargs"()
"foo.unknown_op_with_bbargs"() ({
// CHECK-NEXT: ^bb0(%arg0: i32 loc({{.*}}locations.mlir":[[# @LINE+2]]:7),
// CHECK-ALIAS-NEXT: ^bb0(%arg0: i32 loc({{.*}}locations.mlir":[[# @LINE+1]]:7),
 ^bb0(%x: i32,
// CHECK-SAME: %arg1: i32 loc("cheetos"),
// CHECK-ALIAS-SAME: %arg1: i32 loc("cheetos"),
      %y: i32 loc("cheetos"),
// CHECK-SAME: %arg2: i32 loc("out_of_line_location2")):
// CHECK-ALIAS-SAME: %arg2: i32 loc("out_of_line_location2")):
      %z: i32 loc("out_of_line_location2")):
    %1 = arith.addi %x, %y : i32
    "foo.yield"(%1) : (i32) -> ()
  }) : () -> ()

// CHECK-LABEL: func @location_name_child_is_name
func.func @location_name_child_is_name() {
  // CHECK: "foo"("foo")
  return loc("foo"("foo"))
}

// CHECK-ALIAS: #[[LOC]] = loc("out_of_line_location")
#loc = loc("out_of_line_location")

// CHECK-LABEL: @optional_location_specifier
// CHECK: test.attr_with_loc("foo" loc("foo_loc"))
func.func @optional_location_specifier() {
  test.attr_with_loc("foo" loc("foo_loc"))
  return
}

// CHECK-LABEL: @dialect_location
// CHECK: test.attr_with_loc("dialectLoc" loc(#test.custom_location<"foo.mlir" * 32>))
func.func @dialect_location() {
  test.attr_with_loc("dialectLoc" loc(#test.custom_location<"foo.mlir"*32>))
  return
}

// CHECK-LABEL: @location_attr
// CHECK: test.op_with_loc_attr loc("loc1":10:20) {foo.discardable_loc_attr = loc("loc2":20:30)} loc({{.*}}locations.mlir":[[# @LINE+2]]:3)
func.func @location_attr() {
  test.op_with_loc_attr loc("loc1":10:20) {foo.discardable_loc_attr = loc("loc2":20:30)}
  return
}
