#include <scfg.h>
#include <stdlib.h>

#include "private.h"

void _scfg_directive_finish(struct scfg_directive *dir) {
	free(dir->name);
	for (size_t i = 0; i < dir->params_len; i++) {
		free(dir->params[i]);
	}
	free(dir->params);
	scfg_block_finish(&dir->children);
}

void scfg_block_finish(struct scfg_block *block) {
	for (size_t i = 0; i < block->directives_len; i++) {
		_scfg_directive_finish(&block->directives[i]);
	}
	free(block->directives);
}
